//=============================================================================
// VisuStella MZ - Skills & States Core
// VisuMZ_1_SkillsStatesCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_SkillsStatesCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.SkillsStatesCore = VisuMZ.SkillsStatesCore || {};
VisuMZ.SkillsStatesCore.version = 1.44;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.44] [SkillsStatesCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Skills_and_States_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Skills & States Core plugin extends and builds upon the functionality of
 * RPG Maker MZ's inherent skill, state, and buff functionalities and allows
 * game devs to customize its various aspects.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Assigning multiple Skill Types to Skills.
 * * Making custom Skill Cost Types (such as HP, Gold, and Items).
 * * Allowing Skill Costs to become percentile-based or dynamic either directly
 *   through the Skills themselves or through trait-like notetags.
 * * Replacing gauges for different classes to display different types of
 *   Skill Cost Type resources.
 * * Hiding/Showing and enabling/disabling skills based on switches, learned
 *   skills, and code.
 * * Setting rulings for states, including if they're cleared upon death, how
 *   reapplying the state affects their turn count, and more.
 * * Allowing states to be categorized and affected by categories, too.
 * * Displaying turn counts on states drawn in the window or on sprites.
 * * Manipulation of state, buff, and debuff turns through skill and item
 *   effect notetags.
 * * Create custom damage over time state calculations through notetags.
 * * Allow database objects to apply passive states to its user.
 * * Passive states can have conditions before they become active as well.
 * * Updated Skill Menu Scene layout to fit more modern appearances.
 * * Added bonus if Items & Equips Core is installed to utilize the Shop Status
 *   Window to display skill data inside the Skill Menu.
 * * Control over various aspects of the Skill Menu Scene.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 * 
 * Action End Removal for States
 * 
 * - If your Plugin Parameter settings for "Action End Update" are enabled,
 * then "Action End" has been updated so that it actually applies per action
 * used instead of just being at the start of a battler's action set.
 * 
 * - However, there are side effects to this: if a state has the "Cannot Move"
 * restriction along with the "Action End" removal timing, then unsurprisingly,
 * the state will never wear off because it's now based on actual actions
 * ending. To offset this and remove confusion, "Action End" auto-removal
 * timings for states with "Cannot Move" restrictions will be turned into
 * "Turn End" auto-removal timings while the "Action End Update" is enabled.
 * 
 * - This automatic change won't make it behave like an "Action End" removal
 * timing would, but it's better than completely softlocking a battler.
 * 
 * ---
 *
 * Buff & Debuff Level Management
 *
 * - In RPG Maker MZ, buffs and debuffs when applied to one another will shift
 * the buff modifier level up or down. This plugin will add an extra change to
 * the mechanic by making it so that once the buff modifier level reaches a
 * neutral point, the buff or debuff is removed altogether and resets the buff
 * and debuff turn counter for better accuracy.
 *
 * ---
 *
 * Skill Costs
 *
 * - In RPG Maker MZ, skill costs used to be hard-coded. Now, all Skill Cost
 * Types are now moved to the Plugin Parameters, including MP and TP. This
 * means that from payment to checking for them, it's all done through the
 * options available.
 *
 * - By default in RPG Maker MZ, displayed skill costs would only display only
 * one type: TP if available, then MP. If a skill costs both TP and MP, then
 * only TP was displayed. This plugin changes that aspect by displaying all the
 * cost types available in order of the Plugin Parameter Skill Cost Types.
 *
 * - By default in RPG Maker MZ, displayed skill costs were only color-coded.
 * This plugin changes that aspect by displaying the Skill Cost Type's name
 * alongside the cost. This is to help color-blind players distinguish what
 * costs a skill has.
 *
 * ---
 *
 * Sprite Gauges
 *
 * - Sprite Gauges in RPG Maker MZ by default are hard-coded and only work for
 * HP, MP, TP, and Time (used for ATB). This plugin makes it possible for them
 * to be customized through the use of Plugin Parameters under the Skill Cost
 * Types and their related-JavaScript entries.
 *
 * ---
 * 
 * State Displays
 * 
 * - To put values onto states and display them separately from the state turns
 * you can use the following script calls.
 * 
 *   battler.getStateDisplay(stateId)
 *   - This returns whatever value is stored for the specified battler under
 *     that specific state value.
 *   - If there is no value to be returned it will return an empty string.
 * 
 *   battler.setStateDisplay(stateId, value)
 *   - This sets the display for the battler's specific state to whatever you
 *     declared as the value.
 *   - The value is best used as a number or a string.
 * 
 *   battler.clearStateDisplay(stateId)
 *   - This clears the display for the battler's specific state.
 *   - In short, this sets the stored display value to an empty string.
 * 
 * ---
 *
 * Window Functions Moved
 *
 * - Some functions found in RPG Maker MZ's default code for Window_StatusBase
 * and Window_SkillList are now moved to Window_Base to make the functions
 * available throughout all windows for usage.
 *
 * ---
 *
 * ============================================================================
 * Slip Damage Popup Clarification
 * ============================================================================
 * 
 * Slip Damage popups only show one popup for HP, MP, and TP each and it is the
 * grand total of all the states and effects combined regardless of the number
 * of states and effects on a battler. This is how it is in vanilla RPG Maker
 * MZ and this is how we intend for it to be with the VisuStella MZ library.
 * 
 * This is NOT a bug!
 * 
 * The reason we are not changing this is because it does not properly relay
 * information to the player accurately. When multiple popups appear, players
 * only have roughly a second and a half to calculate it all for any form of
 * information takeaway. We feel it is better suited for the player's overall
 * convenience to show a cummulative change and steer the experience towards a
 * more positive one.
 *
 * ============================================================================
 * Passive State Clarification
 * ============================================================================
 * 
 * This section will explain various misconceptions regarding passive states.
 * No, passive states do not work the same way as states code-wise. Yes, they
 * use the same effects as states mechanically, but there are differences.
 * 
 * ---
 * 
 * For those using the code "a.isStateAffected(10)" to check if a target is
 * affected by a state or not, this does NOT check passive states. This only
 * checks for states that were directly applied to the target.
 * 
 * This is NOT a bug.
 * 
 * Instead, use "a.states().includes($dataStates[10])" to check for them. This
 * code will search for both directly applied states and passive states alike.
 *
 * ---
 * 
 * As passive states are NOT considered directly applied to, they do NOT match
 * a Conditional Branch's state check as well. The Conditional Branch effect
 * checks for an affected state.
 * 
 * ---
 * 
 * Because passive states are NOT directly applied to a battler, the functions
 * of "addNewState", "addState", "eraseState", "removeState" do NOT apply to
 * passive states either. This means that any of the related JS notetags tied
 * to those functions will not occur either.
 * 
 * ---
 * 
 * Why are passive states not considered affected by? Let's look at it
 * differently. There are two ways to grant skills to actors. They can acquire
 * skills by levels/items/events or they can equip gear that temporarily grants
 * the skill in question.
 * 
 * Learning the skill is direct. Temporarily granting the skill is indirect.
 * These two factors have mechanical importance and require differentiation.
 * 
 * Regular states and passive states are the same way. Regular states are
 * directly applied, therefore, need to be distinguished in order for things
 * like state turns and steps, removal conditionals, and similar to matter at
 * all. Passive states are indirect and are therefore, unaffected by state
 * turns, steps, and removal conditions. These mechanical differences are
 * important for how RPG Maker works.
 * 
 * ---
 * 
 * Once again, it is NOT a bug that when using "a.isStateAffected(10)" to
 * check if a target has a passive state will return false.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * === General Skill Notetags ===
 *
 * The following are general notetags that are skill-related.
 *
 * ---
 *
 * <Skill Type: x>
 * <Skill Types: x,x,x>
 *
 * <Skill Type: name>
 * <Skill Types: name, name, name>
 *
 * - Used for: Skill Notetags
 * - Marks the skill to have multiple Skill Types, meaning they would appear
 *   under different skill types without needing to create duplicate skills.
 * - Replace 'x' with a number value representing the Skill Type's ID.
 * - If using 'name' notetag variant, replace 'name' with the Skill Type(s)
 *   name desired to be added.
 *
 * ---
 * 
 * <List Name: name>
 * 
 * - Used for: Skill Notetags
 * - Makes the name of the skill appear different when show in the skill list.
 * - Using \V[x] as a part of the name will display that variable.
 * 
 * ---
 *
 * === Skill Cost Notetags ===
 *
 * The following are notetags that can be used to adjust skill costs. Some of
 * these notetags are added through the Plugin Parameter: Skill Cost Types and
 * can be altered there. This also means that some of these notetags can have
 * their functionality altered and/or removed.
 *
 * ---
 *
 * <type Cost: x>
 * <type Cost: x%>
 *
 * - Used for: Skill Notetags
 * - These notetags are used to designate costs of custom or already existing
 *   types that cannot be made by the Database Editor.
 * - Replace 'type' with a resource type. Existing ones found in the Plugin
 *   Parameters are 'HP', 'MP', 'TP', 'Gold', and 'Potion'. More can be added.
 * - Replace 'x' with a number value to determine the exact type cost value.
 *   This lets you bypass the Database Editor's limit of 9,999 MP and 100 TP.
 * - The 'x%' version is replaced with a percentile value to determine a cost
 *   equal to a % of the type's maximum quantity limit.
 * - Functionality for these notetags can be altered in the Plugin Parameters.
 *
 * Examples:
 *   <HP Cost: 500>
 *   <MP Cost: 25%>
 *   <Gold Cost: 3000>
 *   <Potion Cost: 5>
 *
 * ---
 *
 * <type Cost Max: x>
 * <type Cost Min: x>
 *
 * - Used for: Skill Notetags
 * - These notetags are used to ensure conditional and % costs don't become too
 *   large or too small.
 * - Replace 'type' with a resource type. Existing ones found in the Plugin
 *   Parameters are 'HP', 'MP', 'TP', 'Gold', and 'Potion'. More can be added.
 * - Replace 'x' with a number value to determine the maximum or minimum values
 *   that the cost can be.
 * - Functionality for these notetags can be altered in the Plugin Parameters.
 *
 * Examples:
 *   <HP Cost Max: 1500>
 *   <MP Cost Min: 5>
 *   <Gold Cost Max: 10000>
 *   <Potion Cost Min: 3>
 *
 * ---
 *
 * <type Cost: +x>
 * <type Cost: -x>
 *
 * <type Cost: x%>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - The related actor will raise/lower the cost of any skill that uses the
 *   'type' cost by a specified amount.
 * - Replace 'type' with a resource type. Existing ones found in the Plugin
 *   Parameters are 'HP', 'MP', 'TP', 'Gold', and 'Potion'. More can be added.
 * - For % notetag variant: Replace 'x' with a number value to determine the
 *   rate to adjust the Skill Cost Type by as a rate value. This is applied
 *   before <type Cost: +x> and <type Cost: -x> notetags.
 * - For + and - notetag variants: Replace 'x' with a number value to determine
 *   how much to adjust the Skill Cost Type by as a flat value. This is applied
 *   after <type Cost: x%> notetags.
 * - Functionality for these notetags can be altered in the Plugin Parameters.
 *
 * Examples:
 *   <HP Cost: +20>
 *   <MP Cost: -10>
 *   <Gold Cost: 50%>
 *   <Potion Cost: 200%>
 *
 * ---
 *
 * <Custom Cost Text>
 *  text
 * </Custom Cost Text>
 *
 * - Used for: Skill Notetags
 * - Allows you to insert custom text into the skill's cost area towards the
 *   end of the costs.
 * - Replace 'text' with the text you wish to display.
 * - Text codes may be used.
 *
 * ---
 *
 * === JavaScript Notetags: Skill Costs ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine any dynamic Skill Cost Types used for particular skills.
 *
 * ---
 *
 * <JS type Cost>
 *  code
 *  code
 *  cost = code;
 * </JS type Cost>
 *
 * - Used for: Skill Notetags
 * - Replace 'type' with a resource type. Existing ones found in the Plugin
 *   Parameters are 'HP', 'MP', 'TP', 'Gold', and 'Potion'. More can be added.
 * - Replace 'code' to determine the type 'cost' of the skill.
 * - Insert the final type cost into the 'cost' variable.
 * - The 'user' variable refers to the user about to perform the skill.
 * - The 'skill' variable refers to the skill being used.
 * - Functionality for the notetag can be altered in the Plugin Parameters.
 *
 * ---
 *
 * === Gauge Replacement Notetags ===
 *
 * Certain classes can have their gauges swapped out for other Skill Cost
 * Types. This is especially helpful for the classes that don't utilize those
 * Skill Cost Types. You can mix and match them however you want.
 *
 * ---
 *
 * <Replace HP Gauge: type>
 * <Replace MP Gauge: type>
 * <Replace TP Gauge: type>
 *
 * - Used for: Class Notetags
 * - Replaces the HP (1st), MP (2nd), or TP (3rd) gauge with a different Skill
 *   Cost Type.
 * - Replace 'type' with a resource type. Existing ones found in the Plugin
 *   Parameters are 'HP', 'MP', 'TP', 'Gold', and 'Potion'. More can be added.
 *   - Does not work with 'Item Cost', 'Weapon Cost', or 'Armor Cost'.
 * - Replace 'type' with 'none' to not display any gauges there.
 * - The <Replace TP Gauge: type> will require 'Display TP in Window' setting
 *   to be on in the Database > System 1 tab.
 * - Functionality for the notetags can be altered by changes made to the
 *   Skill & States Core Plugin Parameters.
 *
 * ---
 * 
 * === Item Cost-Related Notetags ===
 * 
 * ---
 * 
 * <Item Cost: x name>
 * <Weapon Cost: x name>
 * <Armor Cost: x name>
 * 
 * - Used for: Skill Notetags
 * - The skill will consume items, weapons, and/or armors in order to be used.
 *   - Even non-consumable items will be consumed.
 * - Replace 'x' with a number representing the respective item cost.
 * - Replace 'name' with text representing the respective item, weapon, or
 *   armor to be consumed.
 * - Insert multiples of this notetag to consume multiple items, weapons,
 *   and/or armors.
 * - Functionality for these notetags can be altered in the Plugin Parameters.
 * 
 * Examples:
 * 
 *   <Item Cost: 5 Magic Water>
 *   <Item Cost: 2 Antidote>
 *   <Weapon Cost: 1 Short Sword>
 *   <Armor Cost: 3 Cloth Armor>
 * 
 * ---
 *
 * <Item Cost Max: x name>
 * <Item Cost Min: x name>
 *
 * <Weapon Cost Max: x name>
 * <Weapon Cost Min: x name>
 *
 * <Armor Cost Max: x name>
 * <Armor Cost Min: x name>
 * 
 * - Used for: Skill Notetags
 * - Sets up a maximum/minimum cost for the item, weapon, armor type costs.
 * - Replace 'x' with a number representing the maximum or minimum cost.
 * - Replace 'name' with text representing the respective item, weapon, or
 *   armor to be consumed.
 * 
 * Examples:
 * 
 *   <Item Cost Max: 10 Magic Water>
 *   <Item Cost Min: 2 Antidote>
 *   <Weapon Cost Max: 3 Short Sword>
 *   <Armor Cost Min: 1 Cloth Armor>
 * 
 * ---
 *
 * <Item Cost: +x name>
 * <Item Cost: -x name>
 *
 * <Weapon Cost: +x name>
 * <Weapon Cost: -x name>
 *
 * <Armor Cost: +x name>
 * <Armor Cost: -x name>
 * 
 * <Item Cost: x% name>
 * <Weapon Cost: x% name>
 * <Armor Cost: x% name>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - The related actor will raise/lower the item, weapon, and/or armor costs of
 *   any skill that costs those items, weapons, and/or armors by x%.
 * - For % notetag variant: Replace 'x' with a number value to determine the
 *   rate to adjust the Skill Cost Type by as a rate value. This is applied
 *   before <type Cost: +x> and <type Cost: -x> notetags.
 * - For + and - notetag variants: Replace 'x' with a number value to determine
 *   how much to adjust the Skill Cost Type by as a flat value. This is applied
 *   after <type Cost: x%> notetags.
 * - Replace 'name' with text representing the respective item, weapon, or
 *   armor to be consumed.
 * - Insert multiples of this notetag to consume multiple items, weapons,
 *   and/or armors.
 * - Functionality for these notetags can be altered in the Plugin Parameters.
 * 
 * Examples:
 * 
 *   <Item Cost: +1 Magic Water>
 *   <Item Cost: -2 Antidote>
 *   <Weapon Cost: 50% Short Sword>
 *   <Armor Cost: 200% Cloth Armor>
 * 
 * ---
 * 
 * <Replace Item name1 Cost: name2>
 * <Replace Weapon name1 Cost: name2>
 * <Replace Armor name1 Cost: name2>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - The related actor will not consume 'name1' items, weapons, or armors.
 *   Instead, the cost will be redirected to 'name2' items, weapons, or armors.
 *   - Even non-consumable items will be consumed.
 * - Replace 'name1' with text representing the respective item, weapon, or
 *   armor that is the original cost type.
 * - Replace 'name2' with text representing the respective item, weapon, or
 *   armor that will be consumed instead.
 * 
 * Examples:
 * 
 *   <Replace Item Magic Water Cost: Potion>
 *   <Replace Item Antidote Cost: Dispel Herb>
 *   <Replace Weapon Short Sword Cost: Falchion>
 *   <Replace Armor Cloth Armor Cost: Leather Armor>
 * 
 * ---
 *
 * === Skill Accessibility Notetags ===
 *
 * Sometimes, you don't want all skills to be visible whether it be to hide
 * menu-only skills during battle, until certain switches are turned ON/OFF, or
 * until certain skills have been learned.
 *
 * ---
 *
 * <Hide in Battle>
 * <Hide outside Battle>
 *
 * - Used for: Skill Notetags
 * - Makes the specific skill visible or hidden depending on whether or not the
 *   player is currently in battle.
 *
 * ---
 *
 * <Show Switch: x>
 *
 * <Show All Switches: x,x,x>
 * <Show Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, skill will be hidden until all switches
 *   are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, skill will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 *
 * ---
 *
 * <Hide Switch: x>
 *
 * <Hide All Switches: x,x,x>
 * <Hide Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, skill will be shown until all switches
 *   are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, skill will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 *
 * ---
 *
 * <Show if learned Skill: x>
 *
 * <Show if learned All Skills: x,x,x>
 * <Show if learned Any Skills: x,x,x>
 *
 * <Show if learned Skill: name>
 *
 * <Show if learned All Skills: name, name, name>
 * <Show if learned Any Skills: name, name, name>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on skills learned.
 * - This does not apply to skills added by traits on actors, classes, any
 *   equipment, or states. These are not considered learned skills. They are
 *   considered temporary skills.
 * - Replace 'x' with the skill ID to determine the skill's visibility.
 * - If 'name' notetag viarant is used, replace 'name' with the skill's name to
 *   be checked for the notetag.
 * - If 'All' notetag variant is used, skill will be hidden until all skills
 *   are learned. Then, it would be shown.
 * - If 'Any' notetag variant is used, skill will be shown if any of the skills
 *   are learned. Otherwise, it would be hidden.
 *
 * ---
 *
 * <Hide if learned Skill: x>
 *
 * <Hide if learned All Skills: x,x,x>
 * <Hide if learned Any Skills: x,x,x>
 *
 * <Hide if learned Skill: name>
 *
 * <Hide if learned All Skills: name, name, name>
 * <Hide if learned Any Skills: name, name, name>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on skills learned.
 * - This does not apply to skills added by traits on actors, classes, any
 *   equipment, or states. These are not considered learned skills. They are
 *   considered temporary skills.
 * - Replace 'x' with the skill ID to determine the skill's visibility.
 * - If 'name' notetag viarant is used, replace 'name' with the skill's name to
 *   be checked for the notetag.
 * - If 'All' notetag variant is used, skill will be shown until all skills
 *   are learned. Then, it would be hidden.
 * - If 'Any' notetag variant is used, skill will be hidden if any of the
 *   skills are learned. Otherwise, it would be shown.
 *
 * ---
 *
 * <Show if has Skill: x>
 *
 * <Show if have All Skills: x,x,x>
 * <Show if have Any Skills: x,x,x>
 *
 * <Show if has Skill: name>
 *
 * <Show if have All Skills: name, name, name>
 * <Show if have Any Skills: name, name, name>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on skills available.
 * - This applies to both skills that have been learned and/or temporarily
 *   added through traits on actors, classes, equipment, or states.
 * - Replace 'x' with the skill ID to determine the skill's visibility.
 * - If 'name' notetag viarant is used, replace 'name' with the skill's name to
 *   be checked for the notetag.
 * - If 'All' notetag variant is used, skill will be hidden until all skills
 *   are learned. Then, it would be shown.
 * - If 'Any' notetag variant is used, skill will be shown if any of the skills
 *   are learned. Otherwise, it would be hidden.
 *
 * ---
 *
 * <Hide if has Skill: x>
 *
 * <Hide if have All Skills: x,x,x>
 * <Hide if have Any Skills: x,x,x>
 *
 * <Hide if has Skill: name>
 *
 * <Hide if have All Skills: name, name, name>
 * <Hide if have Any Skills: name, name, name>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on skills available.
 * - This applies to both skills that have been learned and/or temporarily
 *   added through traits on actors, classes, equipment, or states.
 * - Replace 'x' with the skill ID to determine the skill's visibility.
 * - If 'name' notetag viarant is used, replace 'name' with the skill's name to
 *   be checked for the notetag.
 * - If 'All' notetag variant is used, skill will be shown until all skills
 *   are learned. Then, it would be hidden.
 * - If 'Any' notetag variant is used, skill will be hidden if any of the
 *   skills are learned. Otherwise, it would be shown.
 *
 * ---
 *
 * <Enable Switch: x>
 *
 * <Enable All Switches: x,x,x>
 * <Enable Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines the enabled status of the skill based on switches.
 * - Replace 'x' with the switch ID to determine the skill's enabled status.
 * - If 'All' notetag variant is used, skill will be disabled until all
 *   switches are ON. Then, it would be enabled.
 * - If 'Any' notetag variant is used, skill will be enabled if any of the
 *   switches are ON. Otherwise, it would be disabled.
 *
 * ---
 *
 * <Disable Switch: x>
 *
 * <Disable All Switches: x,x,x>
 * <Disable Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines the enabled status of the skill based on switches.
 * - Replace 'x' with the switch ID to determine the skill's enabled status.
 * - If 'All' notetag variant is used, skill will be enabled until all switches
 *   are ON. Then, it would be disabled.
 * - If 'Any' notetag variant is used, skill will be disabled if any of the
 *   switches are ON. Otherwise, it would be enabled.
 *
 * ---
 *
 * === JavaScript Notetags: Skill Accessibility ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if a skill can be accessible visibly or through usage.
 *
 * ---
 *
 * <JS Skill Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Skill Visible>
 *
 * - Used for: Skill Notetags
 * - Determines the visibility of the skill based on JavaScript code.
 * - Replace 'code' to determine the type visibility of the skill.
 * - The 'visible' variable returns a boolean (true/false) to determine if the
 *   skill will be visible or not.
 * - The 'user' variable refers to the user with the skill.
 * - The 'skill' variable refers to the skill being checked.
 * - All other visibility conditions must be met for this code to count.
 *
 * ---
 *
 * <JS Skill Enable>
 *  code
 *  code
 *  enabled = code;
 * </JS Skill Enable>
 *
 * - Used for: Skill Notetags
 * - Determines the enabled status of the skill based on JavaScript code.
 * - Replace 'code' to determine the type enabled status of the skill.
 * - The 'enabled' variable returns a boolean (true/false) to determine if the
 *   skill will be enabled or not.
 * - The 'user' variable refers to the user with the skill.
 * - The 'skill' variable refers to the skill being checked.
 * - All other skill conditions must be met in order for this to code to count.
 *
 * ---
 *
 * === General State-Related Notetags ===
 *
 * The following notetags are centered around states, such as how their turn
 * counts are displayed, items and skills that affect state turns, if the state
 * can avoid removal by death state, etc.
 *
 * ---
 *
 * <No Death Clear>
 *
 * - Used for: State Notetags
 * - Prevents this state from being cleared upon death.
 * - This allows this state to be added to an already dead battler, too.
 *
 * ---
 *
 * <No Recover All Clear>
 *
 * - Used for: State Notetags
 * - Prevents this state from being cleared upon using the Recover All command.
 *
 * ---
 *
 * <Group Defeat>
 *
 * - Used for: State Notetags
 * - If an entire party is affected by states with the <Group Defeat> notetag,
 *   they are considered defeated.
 * - Usage for this includes party-wide petrification, frozen, etc.
 *
 * ---
 *
 * <Reapply Rules: Ignore>
 * <Reapply Rules: Reset>
 * <Reapply Rules: Greater>
 * <Reapply Rules: Add>
 *
 * - Used for: State Notetags
 * - Choose what kind of rules this state follows if the state is being applied
 *   to a target that already has the state. This affects turns specifically.
 * - 'Ignore' will bypass any turn changes.
 * - 'Reset' will recalculate the state's turns.
 * - 'Greater' will choose to either keep the current turn count if it's higher
 *   than the reset amount or reset it if the current turn count is lower.
 * - 'Add' will add the state's turn count to the applied amount.
 * - If this notetag isn't used, it will use the rules set in the States >
 *   Plugin Parameters.
 *
 * ---
 *
 * <Positive State>
 * <Negative State>
 *
 * - Used for: State Notetags
 * - Marks the state as a positive state or negative state, also altering the
 *   state's turn count color to match the Plugin Parameter settings.
 * - This also puts the state into either the 'Positive' category or
 *   'Negative' category.
 *
 * ---
 *
 * <Category: name>
 * <Category: name, name, name>
 *
 * - Used for: State Notetags
 * - Arranges states into certain/multiple categories.
 * - Replace 'name' with a category name to mark this state as.
 * - Insert multiples of this to mark the state with  multiple categories.
 *
 * ---
 *
 * <Categories>
 *  name
 *  name
 * </Categories>
 *
 * - Used for: State Notetags
 * - Arranges states into certain/multiple categories.
 * - Replace each 'name' with a category name to mark this state as.
 *
 * ---
 * 
 * <Resist State Category: name>
 * <Resist State Categories: name, name, name>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Causes the affected battler resist the listed categories.
 * - Replace each 'name' with a category name to resist.
 *   - Insert multiple 'name' entries to add more categories.
 * - This works exactly like how state resistances work in-game. If a battler
 *   who was originally NOT resistant to "Poison" before gaining a
 *   poison-resistant trait, the "Poison" state will remain because it was
 *   applied before poison-resistance as enabled.
 * 
 * ---
 * 
 * <Resist State Categories>
 *  name
 *  name
 *  name
 * </Resist State Categories>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Causes the affected battler resist the listed categories.
 * - Replace each 'name' with a category name to resist.
 *   - Insert multiple 'name' entries to add more categories.
 * - This works exactly like how state resistances work in-game. If a battler
 *   who was originally NOT resistant to "Poison" before gaining a
 *   poison-resistant trait, the "Poison" state will remain because it was
 *   applied before poison-resistance as enabled.
 * 
 * ---
 *
 * <State x Category Remove: y>
 * 
 * <State x Category Remove: All>
 *
 * - Used for: Skill, Item Notetags
 * - Allows the skill/item to remove 'y' states from specific category 'x'.
 * - Replace 'x' with a category name to remove from.
 * - Replace 'y' with the number of times to remove from that category.
 * - Use the 'All' variant to remove all of the states of that category.
 * - Insert multiples of this to remove different types of categories.
 *
 * ---
 * 
 * <Remove Other x States>
 * 
 * - Used for: State Notetags
 * - When the state with this notetag is added, remove other 'x' category
 *   states from the battler (except for the state being added).
 * - Replace 'x' with a category name to remove from.
 * - Insert multiples of this to remove different types of categories.
 * - Useful for thing state types like stances and forms that there is usually
 *   only one active at a time.
 * 
 * ---
 *
 * <Hide State Turns>
 *
 * - Used for: State Notetags
 * - Hides the state turns from being shown at all.
 * - This will by pass any Plugin Parameter settings.
 *
 * ---
 *
 * <Turn Color: x>
 * <Turn Color: #rrggbb>
 *
 * - Used for: State Notetags
 * - Hides the state turns from being shown at all.
 * - Determines the color of the state's turn count.
 * - Replace 'x' with a number value depicting a window text color.
 * - Replace 'rrggbb' with a hex color code for a more custom color.
 *
 * ---
 * 
 * <Max Turns: x>
 * 
 * - Used for: State Notetags
 * - Determines the upper limit on the maximum number of turns for this state.
 * - Replace 'x' with a number representing the maximum number of turns used
 *   for this state.
 * - If no notetag is used, refer to the default setting found in the Plugin
 *   Parameters under "State Settings".
 * 
 * ---
 *
 * <State id Turns: +x>
 * <State id Turns: -x>
 *
 * <Set State id Turns: x>
 *
 * <State name Turns: +x>
 * <State name Turns: -x>
 *
 * <Set State name Turns: x>
 *
 * - Used for: Skill, Item Notetags
 * - If the target is affected by state 'id' or state 'name', change the state
 *   turn duration for target.
 * - For 'id' variant, replace 'id' with the ID of the state to modify.
 * - For 'name' variant, replace 'name' with the name of the state to modify.
 * - Replace 'x' with the value you wish to increase, decrease, or set to.
 * - Insert multiples of this notetag to affect multiple states at once.
 *
 * ---
 *
 * <param Buff Turns: +x>
 * <param Buff Turns: -x>
 *
 * <Set param Buff Turns: x>
 *
 * - Used for: Skill, Item Notetags
 * - If the target is affected by a 'param' buff, change that buff's turn
 *   duration for target.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter buff to modify.
 * - Replace 'x' with the value you wish to increase, decrease, or set to.
 * - Insert multiples of this notetag to affect multiple parameters at once.
 *
 * ---
 *
 * <param Debuff Turns: +x>
 * <param Debuff Turns: -x>
 *
 * <Set param Debuff Turns: x>
 *
 * - Used for: Skill, Item Notetags
 * - If the target is affected by a 'param' debuff, change that debuff's turn
 *   duration for target.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter debuff to modify.
 * - Replace 'x' with the value you wish to increase, decrease, or set to.
 * - Insert multiples of this notetag to affect multiple parameters at once.
 *
 * ---
 *
 * === JavaScript Notetags: On Add/Erase/Expire ===
 *
 * Using JavaScript code, you can use create custom effects that occur when a
 * state has bee added, erased, or expired.
 * 
 * ---
 *
 * <JS On Add State>
 *  code
 *  code
 * </JS On Add State>
 *
 * - Used for: State Notetags
 * - When a state is added, run the code added by this notetag.
 * - The 'user' variable refers to the current active battler.
 * - The 'target' variable refers to the battler affected by this state.
 * - The 'origin' variable refers to the one who applied this state.
 * - The 'state' variable refers to the current state being affected.
 *
 * ---
 *
 * <JS On Erase State>
 *  code
 *  code
 * </JS On Erase State>
 *
 * - Used for: State Notetags
 * - When a state is erased, run the code added by this notetag.
 * - The 'user' variable refers to the current active battler.
 * - The 'target' variable refers to the battler affected by this state.
 * - The 'origin' variable refers to the one who applied this state.
 * - The 'state' variable refers to the current state being affected.
 *
 * ---
 *
 * <JS On Expire State>
 *  code
 *  code
 * </JS On Expire State>
 *
 * - Used for: State Notetags
 * - When a state has expired, run the code added by this notetag.
 * - The 'user' variable refers to the current active battler.
 * - The 'target' variable refers to the battler affected by this state.
 * - The 'origin' variable refers to the one who applied this state.
 * - The 'state' variable refers to the current state being affected.
 *
 * ---
 *
 * === JavaScript Notetags: Slip Damage/Healing ===
 *
 * Slip Damage, in RPG Maker vocabulary, refers to damage over time. The
 * following notetags allow you to perform custom slip damage/healing.
 *
 * ---
 *
 * <JS type Slip Damage>
 *  code
 *  code
 *  damage = code;
 * </JS type Slip Damage>
 *
 * - Used for: State Notetags
 * - Code used to determine how much slip damage is dealt to the affected unit
 *   during each regeneration phase.
 * - Replace 'type' with 'HP', 'MP', or 'TP'.
 * - Replace 'code' with the calculations on what to determine slip damage.
 * - The 'user' variable refers to the origin of the state.
 * - The 'target' variable refers to the affected unit receiving the damage.
 * - The 'state' variable refers to the current state being affected.
 * - The 'damage' variable is the finalized slip damage to be dealt.
 * - When these states are applied via action effects, the slip calculations
 *   are one time calculations made upon applying and the damage is cached to
 *   be used for future on regeneration calculations.
 * - For that reason, do not include game mechanics here such as adding states,
 *   buffs, debuffs, etc. as this notetag is meant for calculations only. Use
 *   the VisuStella Battle Core's <JS Pre-Regenerate> and <JS Post-Regenerate>
 *   notetags for game mechanics instead.
 * - Passive states and states with the <JS Slip Refresh> notetag are exempt
 *   from the one time calculation and recalculated each regeneration phase.
 *
 * ---
 *
 * <JS type Slip Heal>
 *  code
 *  code
 *  heal = code;
 * </JS type Slip Heal>
 *
 * - Used for: State Notetags
 * - Code used to determine how much slip healing is dealt to the affected unit
 *   during each regeneration phase.
 * - Replace 'type' with 'HP', 'MP', or 'TP'.
 * - Replace 'code' with the calculations on what to determine slip healing.
 * - The 'user' variable refers to the origin of the state.
 * - The 'target' variable refers to the affected unit receiving the healing.
 * - The 'state' variable refers to the current state being affected.
 * - The 'heal' variable is the finalized slip healing to be recovered.
 * - When these states are applied via action effects, the slip calculations
 *   are one time calculations made upon applying and the damage is cached to
 *   be used for future on regeneration calculations.
 * - For that reason, do not include game mechanics here such as adding states,
 *   buffs, debuffs, etc. as this notetag is meant for calculations only. Use
 *   the VisuStella Battle Core's <JS Pre-Regenerate> and <JS Post-Regenerate>
 *   notetags for game mechanics instead.
 * - Passive states and states with the <JS Slip Refresh> notetag are exempt
 *   from the one time calculation and recalculated each regeneration phase.
 *
 * ---
 * 
 * <JS Slip Refresh>
 * 
 * - Used for: State Notetags
 * - Refreshes the calculations made for the JS Slip Damage/Heal amounts at the
 *   start of each regeneration phase to allow for dynamic damage ranges.
 * 
 * ---
 *
 * === Passive State Notetags ===
 *
 * Passive States are states that are always applied to actors and enemies
 * provided that their conditions have been met. These can be granted through
 * database objects or through the Passive States Plugin Parameters.
 * 
 * ---
 * 
 * For those using the code "a.isStateAffected(10)" to check if a target is
 * affected by a state or not, this does NOT check passive states. This only
 * checks for states that were directly applied to the target.
 * 
 * This is NOT a bug.
 * 
 * Instead, use "a.states().includes($dataStates[10])" to check for them. This
 * code will search for both directly applied states and passive states alike.
 *
 * ---
 * 
 * As passive states are NOT considered directly applied to, they do NOT match
 * a Conditional Branch's state check as well. The Conditional Branch effect
 * checks for an affected state.
 * 
 * ---
 * 
 * Because passive states are NOT directly applied to a battler, the functions
 * of "addNewState", "addState", "eraseState", "removeState" do NOT apply to
 * passive states either. This means that any of the related JS notetags tied
 * to those functions will not occur either.
 * 
 * ---
 * 
 * Why are passive states not considered affected by? Let's look at it
 * differently. There are two ways to grant skills to actors. They can acquire
 * skills by levels/items/events or they can equip gear that temporarily grants
 * the skill in question.
 * 
 * Learning the skill is direct. Temporarily granting the skill is indirect.
 * These two factors have mechanical importance and require differentiation.
 * 
 * Regular states and passive states are the same way. Regular states are
 * directly applied, therefore, need to be distinguished in order for things
 * like state turns and steps, removal conditionals, and similar to matter at
 * all. Passive states are indirect and are therefore, unaffected by state
 * turns, steps, and removal conditions. These mechanical differences are
 * important for how RPG Maker works.
 * 
 * ---
 * 
 * Once again, it is NOT a bug that when using "a.isStateAffected(10)" to
 * check if a target has a passive state will return false.
 * 
 * ---
 *
 * <Passive State: x>
 * <Passive States: x,x,x>
 *
 * <Passive State: name>
 * <Passive States: name, name, name>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy Notetags
 * - Adds passive state(s) x to trait object, applying it to related actor or
 *   enemy unit(s).
 * - Replace 'x' with a number to determine which state to add as a passive.
 * - If using 'name' notetag variant, replace 'name' with the name of the
 *   state(s) to add as a passive.
 * - Note: If you plan on applying a passive state through a skill, it must be
 *   through a skill that has been learned by the target and not a skill that
 *   is given through a trait.
 *
 * ---
 *
 * <Passive Stackable>
 *
 * - Used for: State Notetags
 * - Makes it possible for this passive state to be added multiple times.
 * - Otherwise, only one instance of the passive state can be available.
 *
 * ---
 *
 * <Passive Condition Class: id>
 * <Passive Condition Classes: id, id, id>
 *
 * <Passive Condition Class: name>
 * <Passive Condition Classes: name, name, name>
 *
 * - Used for: State Notetags
 * - Determines the passive condition of the passive state based on the actor's
 *   current class. As long as the actor's current class matches one of the
 *   data entries, the passive condition is considered passed.
 * - For 'id' variant, replace 'id' with a number representing class's ID.
 * - For 'name' variant, replace 'name' with the class's name.
 *
 * ---
 *
 * <Passive Condition Multiclass: id>
 * <Passive Condition Multiclass: id, id, id>
 *
 * <Passive Condition Multiclass: name>
 * <Passive Condition Multiclass: name, name, name>
 *
 * - Used for: State Notetags
 * - Requires VisuMZ_2_ClassChangeSystem!
 * - Determines the passive condition of the passive state based on the actor's
 *   multiclasses. As long as the actor has any of the matching classes
 *   assigned as a multiclass, the passive condition is considered passed.
 * - For 'id' variant, replace 'id' with a number representing class's ID.
 * - For 'name' variant, replace 'name' with the class's name.
 *
 * ---
 *
 * <Passive Condition Switch ON: x>
 *
 * <Passive Condition All Switches ON: x,x,x>
 * <Passive Condition Any Switch ON: x,x,x>
 *
 * - Used for: State Notetags
 * - Determines the passive condition of the passive state based on switches.
 * - Replace 'x' with the switch ID to determine the state's passive condition.
 * - If 'All' notetag variant is used, conditions will not be met until all
 *   switches are ON. Then, it would be met.
 * - If 'Any' notetag variant is used, conditions will be met if any of the
 *   switches are ON. Otherwise, it would not be met.
 *
 * ---
 *
 * <Passive Condition Switch OFF: x>
 *
 * <Passive Condition All Switches OFF: x,x,x>
 * <Passive Condition Any Switch OFF: x,x,x>
 *
 * - Used for: State Notetags
 * - Determines the passive condition of the passive state based on switches.
 * - Replace 'x' with the switch ID to determine the state's passive condition.
 * - If 'All' notetag variant is used, conditions will not be met until all
 *   switches are OFF. Then, it would be met.
 * - If 'Any' notetag variant is used, conditions will be met if any of the
 *   switches are OFF. Otherwise, it would not be met.
 *
 * ---
 *
 * === JavaScript Notetags: Passive State ===
 *
 * The following is a notetag made for users with JavaScript knowledge to
 * determine if a passive state's condition can be met.
 *
 * ---
 *
 * <JS Passive Condition>
 *  code
 *  code
 *  condition = code;
 * </JS Passive Condition>
 *
 * - Used for: State Notetags
 * - Determines the passive condition of the state based on JavaScript code.
 * - Replace 'code' to determine if a passive state's condition has been met.
 * - The 'condition' variable returns a boolean (true/false) to determine if
 *   the passive state's condition is met or not.
 * - The 'user' variable refers to the user affected by the passive state.
 * - The 'state' variable refers to the passive state being checked.
 * - All other passive conditions must be met for this code to count.
 * 
 * **NOTE** Not everything can be used as a custom JS Passive Condition due to
 * limitations of the code. There are failsafe checks to prevent infinite loops
 * and some passive conditions will not register for this reason and the
 * conditional checks will behave as if the passive states have NOT been
 * applied for this reason. Such examples include the following:
 * 
 * - A passive state that requires another passive state
 * - A passive state that requires a trait effect from another state
 * - A passive state that requires a parameter value altered by another state
 * - A passive state that requires equipment to be worn but its equipment type
 *   access is provided by another state.
 * - Anything else that is similar in style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Skill Cost Plugin Commands ===
 * 
 * ---
 * 
 * Skill Cost: Emulate Actor Pay
 * - Target actor(s) emulates paying for skill cost.
 * - 
 * 
 *   Actor ID(s):
 *   - Select which Actor ID(s) will pay skill cost.
 * 
 *   Skill ID:
 *   - What is the ID of the skill to emulate paying the skill cost for?
 * 
 * ---
 * 
 * Skill Cost: Emulate Enemy Pay
 * - Target enemy(s) emulates paying for skill cost.
 * - 
 * 
 *   Enemy Index(es):
 *   - Select which enemy index(es) will pay skill cost.
 * 
 *   Skill ID:
 *   - What is the ID of the skill to emulate paying the skill cost for?
 * 
 * ---
 * 
 * === State Turns Plugin Commands ===
 * 
 * ---
 * 
 * State Turns: Actor State Turns Change By
 * - Changes actor(s) state turns by an amount.
 * - Only works on states that can have turns.
 * 
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * State Turns: Actor State Turns Change To
 * - Changes actor(s) state turns to a specific value.
 * - Only works on states that can have turns.
 * 
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * State Turns: Enemy State Turns Change By
 * - Changes enemy(s) state turns by an amount.
 * - Only works on states that can have turns.
 * 
 *   Enemy Index(es):
 *   - Select which enemy index(es) to affect.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * State Turns: Enemy State Turns Change To
 * - Changes enemy(s) state turns to a specific value.
 * - Only works on states that can have turns.
 * 
 *   Enemy Index(es):
 *   - Select which enemy index(es) to affect.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 *
 * ============================================================================
 * Plugin Parameters: General Skill Settings
 * ============================================================================
 *
 * These Plugin Parameters adjust various aspects of the game regarding skills
 * from the custom Skill Menu Layout to global custom effects made in code.
 *
 * ---
 *
 * General
 * 
 *   Use Updated Layout:
 *   - Use the Updated Skill Menu Layout provided by this plugin?
 *   - This will automatically enable the Status Window.
 *   - This will override the Core Engine windows settings.
 *
 *   Layout Style:
 *   - If using an updated layout, how do you want to style the menu scene?
 *     - Upper Help, Left Input
 *     - Upper Help, Right Input
 *     - Lower Help, Left Input
 *     - Lower Help, Right Input
 *
 * ---
 *
 * Skill Type Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Skill Type Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Skill Type Window.
 * 
 *   Window Width:
 *   - What is the desired pixel width of this window?
 *   - Default: 240
 *
 * ---
 *
 * List Window
 * 
 *   Columns:
 *   - Number of maximum columns.
 *
 * ---
 *
 * Shop Status Window
 * 
 *   Show in Skill Menu?:
 *   - Show the Shop Status Window in the Skill Menu?
 *   - This is enabled if the Updated Layout is on.
 * 
 *   Adjust List Window?:
 *   - Automatically adjust the Skill List Window in the Skill Menu if using
 *     the Shop Status Window?
 * 
 *   Background Type:
 *   - Select background type for this window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this Shop Status Window in the
 *     Skill Menu.
 *
 * ---
 *
 * Skill Types
 * 
 *   Hidden Skill Types:
 *   - Insert the ID's of the Skill Types you want hidden from view ingame.
 * 
 *   Hidden During Battle:
 *   - Insert the ID's of the Skill Types you want hidden during battle only.
 * 
 *   Icon: Normal Type:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - To assign icons to skill types, simply insert \I[x] into the
 *     skill type's name in the Database > Types tab.
 * 
 *   Icon: Magic Type:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - To assign icons to skill types, simply insert \I[x] into the
 *     skill type's name in the Database > Types tab.
 *
 * ---
 *
 * Global JS Effects
 * 
 *   JS: Skill Conditions:
 *   - JavaScript code for a global-wide skill condition check.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Skill Cost Types
 * ============================================================================
 *
 * Skill Cost Types are the resources that are used for your skills. These can
 * range from the default MP and TP resources to the newly added HP, Gold, and
 * Potion resources.
 *
 * ---
 *
 * Settings
 * 
 *   Name:
 *   - A name for this Skill Cost Type.
 * 
 *   Icon:
 *   - Icon used for this Skill Cost Type.
 *   - Use 0 for no icon.
 * 
 *   Font Color:
 *   - Text Color used to display this cost.
 *   - For a hex color, use #rrggbb with VisuMZ_1_MessageCore
 * 
 *   Font Size:
 *   - Font size used to display this cost.
 *
 * ---
 *
 * Cost Processing
 * 
 *   JS: Cost Calculation:
 *   - Code on how to calculate this resource cost for the skill.
 * 
 *   JS: Can Pay Cost?:
 *   - Code on calculating whether or not the user is able to pay the cost.
 * 
 *   JS: Paying Cost:
 *   - Code for if met, this is the actual process of paying of the cost.
 *
 * ---
 *
 * Window Display
 * 
 *   JS: Show Cost?:
 *   - Code for determining if the cost is shown or not.
 * 
 *   JS: Cost Text:
 *   - Code to determine the text (with Text Code support) used for the
 *     displayed cost.
 *
 * ---
 *
 * Gauge Display
 * 
 *   JS: Maximum Value:
 *   - Code to determine the maximum value used for this Skill Cost resource
 *     for gauges.
 * 
 *   JS: Current Value:
 *   - Code to determine the current value used for this Skill Cost resource
 *     for gauges.
 * 
 *   JS: Draw Gauge:
 *   - Code to determine how to draw the Skill Cost resource for this 
 *     gauge type.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Gauge Settings
 * ============================================================================
 *
 * Settings in regards to how skill cost gauges function and appear.
 *
 * ---
 *
 * Labels
 * 
 *   Font Type:
 *   - Which font type should be used for labels?
 * 
 *   Match Label Color:
 *   - Match the label color to the Gauge Color being used?
 * 
 *     Match: Gauge # ?:
 *     - Which Gauge Color should be matched?
 * 
 *     Preset: Gauge Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *   Solid Outline:
 *   - Make the label outline a solid black color?
 * 
 *   Outline Width:
 *   - What width do you wish to use for your outline?
 *   - Use 0 to not use an outline.
 *
 * ---
 *
 * Values
 * 
 *   Font Type:
 *   - Which font type should be used for values?
 * 
 *   Solid Outline:
 *   - Make the value outline a solid black color?
 * 
 *   Outline Width:
 *   - What width do you wish to use for your outline?
 *   - Use 0 to not use an outline.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General State Settings
 * ============================================================================
 *
 * These are general settings regarding RPG Maker MZ's state-related aspects
 * from how turns are reapplied to custom code that's ran whenever states are
 * added, erased, or expired.
 *
 * ---
 *
 * General
 * 
 *   Reapply Rules:
 *   - These are the rules when reapplying states.
 *   - Ignore: State doesn't get added.
 *   - Reset: Turns get reset.
 *   - Greater: Turns take greater value (current vs reset).
 *   - Add: Turns add upon existing turns.
 * 
 *   Maximum Turns:
 *   - Maximum number of turns to let states go up to.
 *   - This can be changed with the <Max Turns: x> notetag.
 * 
 *   Action End Update:
 *   - States with "Action End" auto-removal will also update turns at the end
 *     of each action instead of all actions.
 * 
 *   Turn End on Map:
 *   - Update any state and buff turns on the map after this many steps.
 *   - Use 0 to disable.
 *
 * ---
 *
 * Turn Display
 * 
 *   Show Turns?:
 *   - Display state turns on top of window icons and sprites?
 * 
 *   Turn Font Size:
 *   - Font size used for displaying turns.
 * 
 *   Offset X:
 *   - Offset the X position of the turn display.
 * 
 *   Offset Y:
 *   - Offset the Y position of the turn display.
 * 
 *   Turn Font Size:
 *   - Font size used for displaying turns.
 * 
 *   Turn Color: Neutral:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Turn Color: Positive:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Turn Color: Negative:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 *
 * ---
 *
 * Data Display
 * 
 *   Show Data?:
 *   - Display state data on top of window icons and sprites?
 * 
 *   Data Font Size:
 *   - Font size used for displaying state data.
 * 
 *   Offset X:
 *   - Offset the X position of the state data display.
 * 
 *   Offset Y:
 *   - Offset the Y position of the state data display.
 *
 * ---
 *
 * Global JS Effects
 * 
 *   JS: On Add State:
 *   - JavaScript code for a global-wide custom effect whenever a state
 *     is added.
 * 
 *   JS: On Erase State:
 *   - JavaScript code for a global-wide custom effect whenever a state
 *     is erased.
 * 
 *   JS: On Expire State:
 *   - JavaScript code for a global-wide custom effect whenever a state
 *     has expired.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General Buff/Debuff Settings
 * ============================================================================
 *
 * Buffs and debuffs don't count as states by RPG Maker MZ's mechanics, but
 * they do function close enough for them to be added to this plugin for
 * adjusting. Change these settings to make buffs and debuffs work to your
 * game's needs.
 *
 * ---
 *
 * General
 * 
 *   Reapply Rules:
 *   - These are the rules when reapplying buffs/debuffs.
 *   - Ignore: Buff/Debuff doesn't get added.
 *   - Reset: Turns get reset.
 *   - Greater: Turns take greater value (current vs reset).
 *   - Add: Turns add upon existing turns.
 * 
 *   Maximum Turns:
 *   - Maximum number of turns to let buffs and debuffs go up to.
 *
 * ---
 *
 * Stacking
 * 
 *   Max Stacks: Buff:
 *   - Maximum number of stacks for buffs.
 * 
 *   Max Stacks: Debuff:
 *   - Maximum number of stacks for debuffs.
 * 
 *   JS: Buff/Debuff Rate:
 *   - Code to determine how much buffs and debuffs affect parameters.
 *
 * ---
 *
 * Turn Display
 * 
 *   Show Turns?:
 *   - Display buff and debuff turns on top of window icons and sprites?
 * 
 *   Turn Font Size:
 *   - Font size used for displaying turns.
 * 
 *   Offset X:
 *   - Offset the X position of the turn display.
 * 
 *   Offset Y:
 *   - Offset the Y position of the turn display.
 * 
 *   Turn Color: Buffs:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Turn Color: Debuffs:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 *
 * ---
 *
 * Rate Display
 * 
 *   Show Rate?:
 *   - Display buff and debuff rate on top of window icons and sprites?
 * 
 *   Rate Font Size:
 *   - Font size used for displaying rate.
 * 
 *   Offset X:
 *   - Offset the X position of the rate display.
 * 
 *   Offset Y:
 *   - Offset the Y position of the rate display.
 *
 * ---
 *
 * Global JS Effects
 * 
 *   JS: On Add Buff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     buff is added.
 * 
 *   JS: On Add Debuff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     debuff is added.
 * 
 *   JS: On Erase Buff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     buff is added.
 * 
 *   JS: On Erase Debuff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     debuff is added.
 * 
 *   JS: On Expire Buff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     buff is added.
 * 
 *   JS: On Expire Debuff:
 *   - JavaScript code for a global-wide custom effect whenever a
 *     debuff is added.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Passive State Settings
 * ============================================================================
 *
 * These Plugin Parameters adjust passive states that can affect all actors and
 * enemies as well as have global conditions.
 * 
 * ---
 * 
 * For those using the code "a.isStateAffected(10)" to check if a target is
 * affected by a state or not, this does NOT check passive states. This only
 * checks for states that were directly applied to the target.
 * 
 * This is NOT a bug.
 * 
 * Instead, use "a.states().includes($dataStates[10])" to check for them. This
 * code will search for both directly applied states and passive states alike.
 *
 * ---
 * 
 * As passive states are NOT considered directly applied to, they do NOT match
 * a Conditional Branch's state check as well. The Conditional Branch effect
 * checks for an affected state.
 * 
 * ---
 * 
 * Because passive states are NOT directly applied to a battler, the functions
 * of "addNewState", "addState", "eraseState", "removeState" do NOT apply to
 * passive states either. This means that any of the related JS notetags tied
 * to those functions will not occur either.
 * 
 * ---
 * 
 * Why are passive states not considered affected by? Let's look at it
 * differently. There are two ways to grant skills to actors. They can acquire
 * skills by levels/items/events or they can equip gear that temporarily grants
 * the skill in question.
 * 
 * Learning the skill is direct. Temporarily granting the skill is indirect.
 * These two factors have mechanical importance and require differentiation.
 * 
 * Regular states and passive states are the same way. Regular states are
 * directly applied, therefore, need to be distinguished in order for things
 * like state turns and steps, removal conditionals, and similar to matter at
 * all. Passive states are indirect and are therefore, unaffected by state
 * turns, steps, and removal conditions. These mechanical differences are
 * important for how RPG Maker works.
 * 
 * ---
 * 
 * Once again, it is NOT a bug that when using "a.isStateAffected(10)" to
 * check if a target has a passive state will return false.
 * 
 * ---
 *
 * List
 * 
 *   Global Passives:
 *   - A list of passive states to affect actors and enemies.
 * 
 *   Actor-Only Passives:
 *   - A list of passive states to affect actors only.
 * 
 *   Enemy Passives:
 *   - A list of passive states to affect enemies only.
 *
 * ---
 * 
 * Cache
 * 
 *   Switch Refresh?:
 *   - Refresh all battle members when switches are changed in battle?
 *   - This is primarily used for passive state conditions involve parameters
 *     that do not update due to cached data until a refresh occurs.
 *   - If this is on, do not spam Switch changes during battle in order to
 *     prevent lag spikes.
 * 
 *   Variable Refresh?:
 *   - Refresh all battle members when variables are changed in battle?
 *   - This is primarily used for passive state conditions involve parameters
 *     that do not update due to cached data until a refresh occurs.
 *   - If this is on, do not spam Variable changes during battle in order to
 *     prevent lag spikes.
 * 
 * ---
 *
 * Global JS Effects
 * 
 *   JS: Condition Check:
 *   - JavaScript code for a global-wide passive condition check.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * - Yanfly
 * - Arisu
 * - Olivia
 * - Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.44: April 18, 2024
 * * Bug Fixes!
 * ** Fixed a bug where passive states would not appear. Fix made by Olivia.
 * ** Fixed a bug where a crash would occur if certain plugins cleared the
 *    passive state cache midway through trying to register it. Fix by Olivia.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * ** States with lots and lots of text data within their notes will no longer
 *    cause FPS drops.
 * 
 * Version 1.43: January 18, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Arisu!
 * *** Skill Cost: Emulate Actor Pay
 * *** Skill Cost: Emulate Enemy Pay
 * **** Target actor(s)/enemy(s) emulates paying for skill cost.
 * *** State Turns: Actor State Turns Change By
 * *** State Turns: Actor State Turns Change To
 * *** State Turns: Enemy State Turns Change By
 * *** State Turns: Enemy State Turns Change To
 * **** Changes actor(s)/enemy(s) state turns to a specific value/by an amount.
 * **** Only works on states that can have turns.
 * 
 * Version 1.42: November 16, 2023
 * * Bug Fixes!
 * ** 'origin' variable was not working properly for <JS On Expire State>
 *    JavaScript notetag. Should now be working properly. Fix made by Irina.
 * 
 * Version 1.41: September 14, 2023
 * * Bug Fixes!
 * ** Fixed a bug that prevented <Max Turns: x> for states from working due to
 *    one of the recent updates. Fix made by Arisu.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Apparently, we never put <Max Turns: x> in the help notetag section.
 *    Woops... It's there now.
 * 
 * Version 1.40: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug involving the "Item Cost" skill cost type found in the Plugin
 *    Parameters when involving consumable items.
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_SkillsStatesCore.js in the Plugin Manager
 *      list and install the newest version.
 * **** Or create a new project, install VisuMZ_1_SkillsStatesCore.js there,
 *      then copy over the "Item Cost" plugin parameters found in the "Skill
 *      Cost Types" plugin parameter settings to your current project.
 * 
 * Version 1.39: July 13, 2023
 * * Feature Update!
 * ** Updated the "Item Cost" skill cost type found in the Plugin Parameters to
 *    no longer consume items that are key items or nonconsumable.
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_SkillsStatesCore.js in the Plugin Manager
 *      list and install the newest version.
 * **** Or create a new project, install VisuMZ_1_SkillsStatesCore.js there,
 *      then copy over the "Item Cost" plugin parameters found in the "Skill
 *      Cost Types" plugin parameter settings to your current project.
 * 
 * Version 1.38: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added segment to <Replace x Gauge: type> in documentation:
 * *** Does not work with 'Item Cost', 'Weapon Cost', or 'Armor Cost'.
 * * New Features!
 * ** New "Skill Cost Type" and notetags added by Arisu and sponsored by FAQ.
 * *** <Item Cost: x name>
 * *** <Weapon Cost: x name>
 * *** <Armor Cost: x name>
 * **** The skill will consume items, weapons, and/or armors in order to be
 *      used. Even non-consumable items will be consumed.
 * *** <Item Cost Max/Min: x name>
 * *** <Weapon Cost Max/Min: x name>
 * *** <Armor Cost Max/Min: x name>
 * **** Sets up a maximum/minimum cost for the item, weapon, armor type costs.
 * *** <Item Cost: x% name>
 * *** <Weapon Cost: x% name>
 * *** <Armor Cost: x% name>
 * **** Alters cost rate of skills that would consume item, weapon, or armor.
 * *** <Item Cost: +/-x name>
 * *** <Weapon Cost: +/-x name>
 * *** <Armor Cost: +/-x name>
 * **** Alters flat costs of skills that would consume item, weapon, or armor.
 * *** <Replace Item name1 Cost: name2>
 * *** <Replace Weapon name1 Cost: name2>
 * *** <Replace Armor name1 Cost: name2>
 * **** Replaces item, weapon, or armor to be consumed for another type.
 * *** Projects with the Skills and States Core already installed will not have
 *     this update, but you can copy over the settings from a new project with
 *     the following steps:
 * **** Create a new project. Install Skills and States Core. Open up the new
 *      project's 'Skill Cost Types'.
 * **** Right click the 'Item Cost' option(s) and click copy.
 * **** Go to the target project's Skills and States Core's 'Skill Cost Types'
 *      plugin parameter. Paste the command where you want it to go.
 * **** Only 'Item Cost' is needed as it encompasses all three types for item,
 *      weapon, and armor costs.
 * 
 * Version 1.38: February 16, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.37: January 20, 2023
 * * Bug Fixes!
 * ** Fixed a bug that caused equipment to unequip if the needed equipment
 *    traits came from passive states upon learning new skills. Fix by Irina.
 * 
 * Version 1.36: December 15, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** When enemies are defeated with their entire party having a state with the
 *    <Group Defeat> notetag, then the party will gain EXP, Gold, and Drops
 *    before when they wouldn't. Update made by Irina.
 * * New Features!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > Skill Settings > Skill Type Window > Window Width
 * **** What is the desired pixel width of this window? Default: 240
 * 
 * Verison 1.35: October 13, 2022
 * * Feature Update!
 * ** Default values for Passive States > Cache > Switch Refresh? and Variable
 *    Refresh? are now set to "false" in order to prevent sudden lag spikes for
 *    those who are unfamiliar with how this setting works.
 * ** Update made by Irina.
 * 
 * Version 1.34: September 29, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Gauge Settings
 * **** These settings allow you to make minor tweaks to how the gauges look
 *      ranging from the color used for the labels to the outline types used
 *      for the values.
 * 
 * Version 1.33: August 11, 2022
 * * Bug Fixes!
 * ** Fixed a crash that occurs when performing a custom action sequence
 *    without a skill attached to it. Fix made by Olivia.
 * 
 * Version 1.32: June 16, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Passive State Settings > Cache > Switch Refresh?
 * *** Plugin Parameters > Passive State Settings > Cache > Variable Refresh?
 * **** Refresh all battle members when switches/variables are changed in
 *      battle?
 * **** This is primarily used for passive state conditions involve parameters
 *      that do not update due to cached data until a refresh occurs.
 * **** If this is on, do not spam Switch/Variable changes during battle in
 *      order to prevent lag spikes.
 * 
 * Version 1.31: April 28, 2022
 * * Bug Fixes!
 * ** Custom Slip Damage JS is now totalled correctly into regular slip damage
 *    totals for damage popups. Fix made by Olivia.
 * 
 * Version 1.30: April 14, 2022
 * * Feature Update!
 * ** Changed the state data removal timing to be after JS notetag effects
 *    take place in order for data such as origin data to remain intact. Update
 *    made by Irina.
 * 
 * Version 1.29: March 31, 2022
 * * Bug Fixes!
 * ** Fixed an error with <State x Category Remove: y> not countaing correctly
 *    unless the state count matched the exact amount. The notetag effect
 *    should work properly now. Fix made by Olivia.
 * 
 * Version 1.28: March 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** <State x Category Remove: All> updated to allow multiple cases in a
 *    single notebox. Updated by Arisu.
 * * New Features!
 * ** New Notetag added by Arisu and sponsored by Archeia!
 * *** <Remove Other x States>
 * **** When the state with this notetag is added, remove other 'x' category
 *      states from the battler (except for the state being added).
 * **** Useful for thing state types like stances and forms that there is
 *      usually only one active at a time.
 * 
 * Version 1.27: January 27, 2022
 * * Bug Fixes!
 * ** Custom JS Slip Damage/Healing values should now be recalculated on
 *    demand. Fix made by Olivia.
 * 
 * Version 1.26: January 20, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Conditional Passive Bypass check is now stronger to prevent even more
 *    infinite loops from happening. Update made by Olivia.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > State Settings > General > Turn End on Map
 * **** Update any state and buff turns on the map after this many steps.
 * **** Use 0 to disable.
 * 
 * Version 1.25: November 11, 2021
 * * Bug Fixes!
 * ** Hidden skill notetags should no longer crash upon not detecting actors
 *    for learned skills. Fix made by Olivia.
 * 
 * Version 1.24: November 4, 2021
 * * Documentation Update!
 * ** Added section: "Slip Damage Popup Clarification"
 * *** Slip Damage popups only show one popup for HP, MP, and TP each and it is
 *     the grand total of all the states and effects combined regardless of the
 *     number of states and effects on a battler. This is how it is in vanilla
 *     RPG Maker MZ and this is how we intend for it to be with the VisuStella
 *     MZ library.
 * *** This is NOT a bug!
 * *** The reason we are not changing this is because it does not properly
 *     relay information to the player accurately. When multiple popups appear,
 *     players only have roughly a second and a half to calculate it all for
 *     any form of information takeaway. We feel it is better suited for the
 *     player's overall convenience to show a cummulative change and steer the
 *     experience towards a more positive one.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.23: September 17, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.3.3 compatibility.
 * *** Updated how gauges are drawn.
 * *** Skill Cost Types Plugin Parameters need to be updated for those who want
 *     the updated gauges. This can be done easily with the following steps:
 * **** Step 1: Create a new project.
 * **** Step 2: Install Skills and States Core version 1.23 into it.
 * **** Step 3: Copy the Plugin Parameter Settings for "Skill Cost Types".
 * **** Step 4: Return back to your original project.
 * **** Step 5: Paste Plugin Parameter Settings on top of "Skill Cost Types".
 * 
 * Version 1.22: August 6, 2021
 * * Documentation Update!
 * ** "Action End Removal for States" under Major Updates is changed to:
 * *** If your Plugin Parameter settings for "Action End Update" are enabled,
 *     then "Action End" has been updated so that it actually applies per
 *     action used instead of just being at the start of a battler's action
 *     set.
 * *** However, there are side effects to this: if a state has the "Cannot
 *     Move" restriction along with the "Action End" removal timing, then
 *     unsurprisingly, the state will never wear off because it's now based on
 *     actual actions ending. To offset this and remove confusion, "Action End"
 *     auto-removal timings for states with "Cannot Move" restrictions will be
 *     turned into "Turn End" auto-removal timings while the "Action End
 *     Update" is enabled.
 * *** This automatic change won't make it behave like an "Action End" removal
 *     timing would, but it's better than completely softlocking a battler.
 * * Feature Update!
 * ** Those using "Cannot Move" states with "Action End" auto-removal will now
 *    have be automatically converted into "Turn End" auto-removal if the
 *    plugin parameter "Action End Update" is set to true. Update by Irina.
 * 
 * Version 1.21: July 30, 2021
 * * Documentation Update!
 * ** Expanded "Action End Removal for States" section in Major Changes.
 * *** These changes have been in effect since Version 1.07 but have not been
 *     explained in excess detail in the documentation since.
 * **** Action End has been updated so that it actually applies per action used
 *      instead of just being at the start of a battler's action set. However,
 *      there are side effects to this: if a state has the "Cannot Move"
 *      restriction along with the "Action End" removal timing, then
 *      unsurprisingly, the state will never wear off because it's now based on
 *      actual actions ending. There are two solutions to this:
 * **** Don't make "Cannot Move" restriction states with "Action End". This is
 *      not a workaround. This is how the state removal is intended to work
 *      under the new change.
 * **** Go to the Skills & States Core Plugin Parameters, go to State
 *      Setttings, look for "Action End Update", and set it to false. You now
 *      reverted the removal timing system back to how it originally was in RPG
 *      Maker MZ's default battle system where it only updates based on an
 *      action set rather than per actual action ending.
 * 
 * Version 1.20: June 18, 2021
 * * Feature Update!
 * ** Updated automatic caching for conditional passive states to update more
 *    efficiently. Update made by Arisu.
 * 
 * Version 1.19: June 4, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.18: May 21, 2021
 * * Documentation Update
 * ** Added "Passive State Clarification" section.
 * *** As there is a lot of confusion regarding how passive states work and how
 *     people still miss the explanations found in the "Passive State Notetags"
 *     section AND the "Plugin Parameters: Passive State Settings", we are
 *     adding a third section to explain how they work.
 * *** All three sections will contain the full detailed explanation of how
 *     passive states work to clear common misconceptions about them.
 * 
 * Version 1.17: May 7, 2021
 * * Bug Fixes
 * ** State category removal is now usable outside of battle. Fix by Irina.
 * 
 * Version 1.16: April 30, 2021
 * * Bug Fixes!
 * ** When states with step removal have the <No Recover All Clear> or
 *    <No Death Clear> notetags, their step counter is no longer reset either.
 *    Fix made by Irina.
 * * New Features!
 * ** New notetag added by Arisu!
 * *** <List Name: name>
 * **** Makes the name of the skill appear different when show in the skill
 *      list. Using \V[x] as a part of the name will display that variable.
 * 
 * Version 1.15: March 19, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.14: March 12, 2021
 * * Bug Fixes!
 * ** Max HP Buff/Debuff should now display its turn counter. Fix by Yanfly.
 * * Documentation Update!
 * ** For the <JS Passive Condition>, we've added documentation on the
 *    limitations of passive conditions since they have been reported as bug
 *    reports, when in reality, they are failsafes to prevent infinite loops.
 *    Such limitations include the following:
 * *** A passive state that requires another passive state
 * *** A passive state that requires a trait effect from another state
 * *** A passive state that requires a parameter value altered by another state
 * *** A passive state that requires equipment to be worn but its equipment
 *     type access is provided by another state.
 * *** Anything else that is similar in style.
 * 
 * Version 1.13: February 26, 2021
 * * Documentation Update!
 * ** For <JS type Slip Damage> and <JS type Slip Heal> notetags, added the
 *    following notes:
 * *** When these states are applied via action effects, the slip calculations
 *     are one time calculations made upon applying and the damage is cached to
 *     be used for future on regeneration calculations.
 * *** For that reason, do not include game mechanics here such as adding
 *     states, buffs, debuffs, etc. as this notetag is meant for calculations
 *     only. Use the VisuStella Battle Core's <JS Pre-Regenerate> and
 *     <JS Post-Regenerate> notetags for game mechanics instead.
 * *** Passive states and states with the <JS Slip Refresh> notetag are exempt
 *     from the one time calculation and recalculated each regeneration phase.
 * * Feature Update!
 * ** Changed slip refresh requirements to entail <JS Slip Refresh> notetag for
 *    extra clarity. Update made by Olivia.
 * 
 * Version 1.12: February 19, 2021
 * * Feature Update
 * ** Changed the way passive state infinite stacking as a blanket coverage.
 *    Update made by Olivia.
 * 
 * Version 1.11: February 12, 2021
 * * Bug Fixes!
 * ** Added a check to prevent passive states from infinitely stacking. Fix
 *    made by Olivia.
 * 
 * Version 1.10: January 15, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameters added
 * *** Plugin Parameters > Skill Settings > Background Type
 * 
 * Version 1.09: January 1, 2021
 * * Bug Fixes!
 * ** Custom JS TP slip damage and healing should now work properly.
 *    Fix made by Yanfly.
 * 
 * Version 1.08: December 25, 2020
 * * Bug Fixes!
 * ** <JS On Add State> should no longer trigger multiple times for the death
 *    state. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** <No Death Clear> can now allow the affected state to be added to an
 *    already dead battler. Update made by Yanfly.
 * 
 * Version 1.07: December 18, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Passive Condition Multiclass: id>
 * *** <Passive Condition Multiclass: id, id, id>
 * *** <Passive Condition Multiclass: name>
 * *** <Passive Condition Multiclass: name, name, name>
 * ** New Plugin Parameter added by Yanfly.
 * *** Plugin Parameters > States > General > Action End Update
 * **** States with "Action End" auto-removal will also update turns at the end
 *      of each action instead of all actions.
 * ***** Turn this off if you wish for state turn updates to function like they
 *       do by default for "Action End".
 * 
 * Version 1.06: December 4, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.05: November 15, 2020
 * * Bug Fixes!
 * ** The alignment of the Skill Type Window is now fixed and will reflect upon
 *    the default settings. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** <State x Category Remove: All> notetag added by Yanfly.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.04: September 27, 2020
 * * Documentation Update
 * ** "Use Updated Layout" plugin parameters now have the added clause:
 *    "This will override the Core Engine windows settings." to reduce
 *    confusion. Added by Irina.
 * 
 * Version 1.03: September 13, 2020
 * * Bug Fixes!
 * ** <JS type Slip Damage> custom notetags now work for passive states. Fix
 *    made by Olivia.
 * ** Setting the Command Window style to "Text Only" will no longer add in
 *    the icon text codes. Bug fixed by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** The JS Notetags for Add, Erase, and Expire states are now fixed. Fix made
 *    by Yanfly.
 * * Documentation Update!
 * ** <Show if learned Skill: x> and <Hide if learned Skill: x> notetags have
 *    the following added to their descriptions:
 * *** This does not apply to skills added by traits on actors, classes, any
 *     equipment, or states. These are not considered learned skills. They are
 *     considered temporary skills.
 * * New Features!
 * ** Notetags added by Yanfly:
 * *** <Show if has Skill: x>
 * *** <Show if have All Skills: x,x,x>
 * *** <Show if have Any Skills: x,x,x>
 * *** <Show if has Skill: name>
 * *** <Show if have All Skills: name, name, name>
 * *** <Show if have Any Skills: name, name, name>
 * *** <Hide if has Skill: x>
 * *** <Hide if have All Skills: x,x,x>
 * *** <Hide if have Any Skills: x,x,x>
 * *** <Hide if has Skill: name>
 * *** <Hide if have All Skills: name, name, name>
 * *** <Hide if have Any Skills: name, name, name>
 * *** These have been added to remove the confusion regarding learned skills
 *     as skills added through trait effects are not considered learned skills
 *     by RPG Maker MZ.
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Passive states from Elements & Status Menu Core are now functional.
 *    Fix made by Olivia.
 * * Compatibility Update
 * ** Extended functions to allow for better compatibility.
 * * Updated documentation
 * ** Explains that passive states are not directly applied and are therefore
 *    not affected by code such as "a.isStateAffected(10)".
 * ** Instead, use "a.states().includes($dataStates[10])"
 * ** "Use #rrggbb for a hex color." lines now replaced with
 *    "For a hex color, use #rrggbb with VisuMZ_1_MessageCore"
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SkillActorPaySkillCost
 * @text Skill Cost: Emulate Actor Pay
 * @desc Target actor(s) emulates paying for skill cost.
 *
 * @arg ActorIDs:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) will pay skill cost.
 * @default ["1"]
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc What is the ID of the skill to emulate paying the skill cost for?
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SkillEnemyPaySkillCost
 * @text Skill Cost: Emulate Enemy Pay
 * @desc Target enemy(s) emulates paying for skill cost.
 *
 * @arg EnemyIndex:arraynum
 * @text Enemy Index(es)
 * @type actr[]
 * @desc Select which enemy index(es) will pay skill cost.
 * @default ["1"]
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc What is the ID of the skill to emulate paying the skill cost for?
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_StateTurns
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command StateTurnsActorChangeBy
 * @text State Turns: Actor State Turns Change By
 * @desc Changes actor(s) state turns by an amount.
 * Only works on states that can have turns.
 *
 * @arg ActorIDs:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command StateTurnsActorChangeTo
 * @text State Turns: Actor State Turns Change To
 * @desc Changes actor(s) state turns to a specific value.
 * Only works on states that can have turns.
 *
 * @arg ActorIDs:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command StateTurnsEnemyChangeBy
 * @text State Turns: Enemy State Turns Change By
 * @desc Changes enemy(s) state turns by an amount.
 * Only works on states that can have turns.
 *
 * @arg EnemyIndex:arraynum
 * @text Enemy Index(es)
 * @type actr[]
 * @desc Select which enemy index(es) to affect.
 * @default ["1"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if enemy(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command StateTurnsEnemyChangeTo
 * @text State Turns: Enemy State Turns Change To
 * @desc Changes enemy(s) state turns to a specific value.
 * Only works on states that can have turns.
 *
 * @arg EnemyIndex:arraynum
 * @text Enemy Index(es)
 * @type actr[]
 * @desc Select which enemy index(es) to affect.
 * @default ["1"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if enemy(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param SkillsStatesCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Skills:struct
 * @text Skill Settings
 * @type struct<Skills>
 * @desc Adjust general skill settings here.
 * @default {"General":"","EnableLayout:eval":"true","LayoutStyle:str":"upper/left","SkillTypeWindow":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","ListWindow":"","ListWindowCols:num":"1","ShopStatusWindow":"","ShowShopStatus:eval":"true","SkillSceneAdjustSkillList:eval":"true","SkillMenuStatusRect:func":"\"const ww = this.shopStatusWidth();\\nconst wh = this._itemWindow.height;\\nconst wx = Graphics.boxWidth - this.shopStatusWidth();\\nconst wy = this._itemWindow.y;\\nreturn new Rectangle(wx, wy, ww, wh);\"","SkillTypes":"","HiddenSkillTypes:arraynum":"[]","BattleHiddenSkillTypes:arraynum":"[]","IconStypeNorm:num":"78","IconStypeMagic:num":"79","CustomJS":"","SkillConditionJS:func":"\"// Declare Variables\\nconst skill = arguments[0];\\nconst user = this;\\nconst target = this;\\nconst a = this;\\nconst b = this;\\nlet enabled = true;\\n\\n// Perform Checks\\n\\n\\n// Return boolean\\nreturn enabled;\""}
 *
 * @param Costs:arraystruct
 * @text Skill Cost Types
 * @parent Skills:struct
 * @type struct<Cost>[]
 * @desc A list of all the skill cost types added by this plugin
 * and the code that controls them in-game.
 * @default ["{\"Name:str\":\"HP\",\"Settings\":\"\",\"Icon:num\":\"0\",\"FontColor:str\":\"20\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\nif (note.match(/<HP COST:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost += Number(RegExp.$1);\\\\n}\\\\nif (note.match(/<HP COST:[ ](\\\\\\\\d+)([%％])>/i)) {\\\\n    cost += Math.ceil(Number(RegExp.$1) * user.mhp / 100);\\\\n}\\\\nif (note.match(/<JS HP COST>\\\\\\\\s*([\\\\\\\\s\\\\\\\\S]*)\\\\\\\\s*<\\\\\\\\/JS HP COST>/i)) {\\\\n    const code = String(RegExp.$1);\\\\n    eval(code);\\\\n}\\\\n\\\\n// Apply Trait Cost Alterations\\\\nif (cost > 0) {\\\\n    const rateNote = /<HP COST:[ ](\\\\\\\\d+\\\\\\\\.?\\\\\\\\d*)([%％])>/i;\\\\n    const rates = user.traitObjects().map((obj) => (obj && obj.note.match(rateNote) ? Number(RegExp.$1) / 100 : 1));\\\\n    const flatNote = /<HP COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)>/i;\\\\n    const flats = user.traitObjects().map((obj) => (obj && obj.note.match(flatNote) ? Number(RegExp.$1) : 0));\\\\n    cost = rates.reduce((r, rate) => r * rate, cost);\\\\n    cost = flats.reduce((r, flat) => r + flat, cost);\\\\n    cost = Math.max(1, cost);\\\\n}\\\\n\\\\n// Set Cost Limits\\\\nif (note.match(/<HP COST MAX:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.min(cost, Number(RegExp.$1));\\\\n}\\\\nif (note.match(/<HP COST MIN:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.max(cost, Number(RegExp.$1));\\\\n}\\\\n\\\\n// Return cost value\\\\nreturn Math.round(Math.max(0, cost));\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nif (cost <= 0) {\\\\n    return true;\\\\n} else {\\\\n    return user._hp > cost;\\\\n}\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Process Payment\\\\nuser._hp -= cost;\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn cost > 0;\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = TextManager.hp;\\\\nconst icon = settings.Icon;\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\ntext += '%1 %2'.format(cost, name);\\\\n\\\\n// Text: Add Icon\\\\nif (icon  > 0) {\\\\n    text += '\\\\\\\\\\\\\\\\I[%1]'.format(icon);\\\\n}\\\\n\\\\n// Return text\\\\nreturn text;\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.mhp;\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.hp;\\\"\",\"GaugeDrawJS:func\":\"\\\"// Declare Settings\\\\nconst color1 = ColorManager.hpGaugeColor1();\\\\nconst color2 = ColorManager.hpGaugeColor2();\\\\nconst label = TextManager.hpA;\\\\n\\\\n// Declare Variables\\\\nconst sprite = this;\\\\nconst settings = sprite._costSettings;\\\\nconst bitmap = sprite.bitmap;\\\\nconst user = sprite._battler;\\\\nconst currentValue = sprite.currentDisplayedValue();\\\\nconst bitmapWidth = sprite.bitmapWidth();\\\\nconst bitmapHeight = sprite.textHeight ? sprite.textHeight() : sprite.bitmapHeight();\\\\nconst gaugeHeight = sprite.gaugeHeight();\\\\n\\\\n// Draw Gauge\\\\nconst gx = 0;\\\\nconst gy = bitmapHeight - gaugeHeight;\\\\nconst gw = bitmapWidth - gx;\\\\nconst gh = gaugeHeight;\\\\nthis.drawFullGauge(color1, color2, gx, gy, gw, gh);\\\\n\\\\n// Draw Label\\\\nconst lx = 4;\\\\nconst ly = 0;\\\\nconst lw = bitmapWidth;\\\\nconst lh = bitmapHeight;\\\\nsprite.setupLabelFont();\\\\nbitmap.paintOpacity = 255;\\\\nbitmap.drawText(label, lx, ly, lw, lh, \\\\\\\"left\\\\\\\");\\\\n\\\\n// Draw Value\\\\nconst vw = bitmapWidth - 2;\\\\nconst vh = bitmapHeight;\\\\nsprite.setupValueFont();\\\\nbitmap.textColor = ColorManager.hpColor(user);\\\\nbitmap.drawText(currentValue, 0, 0, vw, vh, \\\\\\\"right\\\\\\\");\\\"\"}","{\"Name:str\":\"MP\",\"Settings\":\"\",\"Icon:num\":\"0\",\"FontColor:str\":\"23\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\ncost = Math.floor(skill.mpCost * user.mcr);\\\\nif (note.match(/<MP COST:[ ](\\\\\\\\d+)([%％])>/i)) {\\\\n    cost += Math.ceil(Number(RegExp.$1) * user.mmp / 100);\\\\n}\\\\nif (note.match(/<JS MP COST>\\\\\\\\s*([\\\\\\\\s\\\\\\\\S]*)\\\\\\\\s*<\\\\\\\\/JS MP COST>/i)) {\\\\n    const code = String(RegExp.$1);\\\\n    eval(code);\\\\n}\\\\n\\\\n// Apply Trait Cost Alterations\\\\nif (cost > 0) {\\\\n    const rateNote = /<MP COST:[ ](\\\\\\\\d+\\\\\\\\.?\\\\\\\\d*)([%％])>/i;\\\\n    const rates = user.traitObjects().map((obj) => (obj && obj.note.match(rateNote) ? Number(RegExp.$1) / 100 : 1));\\\\n    const flatNote = /<MP COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)>/i;\\\\n    const flats = user.traitObjects().map((obj) => (obj && obj.note.match(flatNote) ? Number(RegExp.$1) : 0));\\\\n    cost = rates.reduce((r, rate) => r * rate, cost);\\\\n    cost = flats.reduce((r, flat) => r + flat, cost);\\\\n    cost = Math.max(1, cost);\\\\n}\\\\n\\\\n// Set Cost Limits\\\\nif (note.match(/<MP COST MAX:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.min(cost, Number(RegExp.$1));\\\\n}\\\\nif (note.match(/<MP COST MIN:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.max(cost, Number(RegExp.$1));\\\\n}\\\\n\\\\n// Return cost value\\\\nreturn Math.round(Math.max(0, cost));\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn user._mp >= cost;\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Process Payment\\\\nuser._mp -= cost;\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn cost > 0;\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = TextManager.mp;\\\\nconst icon = settings.Icon;\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<#%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\ntext += '%1 %2'.format(cost, name);\\\\n\\\\n// Text: Add Icon\\\\nif (icon  > 0) {\\\\n    text += '\\\\\\\\\\\\\\\\I[%1]'.format(icon);\\\\n}\\\\n\\\\n// Return text\\\\nreturn text;\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.mmp;\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.mp;\\\"\",\"GaugeDrawJS:func\":\"\\\"// Declare Settings\\\\nconst color1 = ColorManager.mpGaugeColor1();\\\\nconst color2 = ColorManager.mpGaugeColor2();\\\\nconst label = TextManager.mpA;\\\\n\\\\n// Declare Variables\\\\nconst sprite = this;\\\\nconst settings = sprite._costSettings;\\\\nconst bitmap = sprite.bitmap;\\\\nconst user = sprite._battler;\\\\nconst currentValue = sprite.currentDisplayedValue();\\\\nconst bitmapWidth = sprite.bitmapWidth();\\\\nconst bitmapHeight = sprite.textHeight ? sprite.textHeight() : sprite.bitmapHeight();\\\\nconst gaugeHeight = sprite.gaugeHeight();\\\\n\\\\n// Draw Gauge\\\\nconst gx = 0;\\\\nconst gy = bitmapHeight - gaugeHeight;\\\\nconst gw = bitmapWidth - gx;\\\\nconst gh = gaugeHeight;\\\\nthis.drawFullGauge(color1, color2, gx, gy, gw, gh);\\\\n\\\\n// Draw Label\\\\nconst lx = 4;\\\\nconst ly = 0;\\\\nconst lw = bitmapWidth;\\\\nconst lh = bitmapHeight;\\\\nsprite.setupLabelFont();\\\\nbitmap.paintOpacity = 255;\\\\nbitmap.drawText(label, lx, ly, lw, lh, \\\\\\\"left\\\\\\\");\\\\n\\\\n// Draw Value\\\\nconst vw = bitmapWidth - 2;\\\\nconst vh = bitmapHeight;\\\\nsprite.setupValueFont();\\\\nbitmap.textColor = ColorManager.mpColor(user);\\\\nbitmap.drawText(currentValue, 0, 0, vw, vh, \\\\\\\"right\\\\\\\");\\\"\"}","{\"Name:str\":\"TP\",\"Settings\":\"\",\"Icon:num\":\"0\",\"FontColor:str\":\"29\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\ncost = skill.tpCost;\\\\nif (note.match(/<TP COST:[ ](\\\\\\\\d+)([%％])>/i)) {\\\\n    cost += Math.ceil(Number(RegExp.$1) * user.maxTp() / 100);\\\\n}\\\\nif (note.match(/<JS TP COST>\\\\\\\\s*([\\\\\\\\s\\\\\\\\S]*)\\\\\\\\s*<\\\\\\\\/JS TP COST>/i)) {\\\\n    const code = String(RegExp.$1);\\\\n    eval(code);\\\\n}\\\\n\\\\n// Apply Trait Cost Alterations\\\\nif (cost > 0) {\\\\n    const rateNote = /<TP COST:[ ](\\\\\\\\d+\\\\\\\\.?\\\\\\\\d*)([%％])>/i;\\\\n    const rates = user.traitObjects().map((obj) => (obj && obj.note.match(rateNote) ? Number(RegExp.$1) / 100 : 1));\\\\n    const flatNote = /<TP COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)>/i;\\\\n    const flats = user.traitObjects().map((obj) => (obj && obj.note.match(flatNote) ? Number(RegExp.$1) : 0));\\\\n    cost = rates.reduce((r, rate) => r * rate, cost);\\\\n    cost = flats.reduce((r, flat) => r + flat, cost);\\\\n    cost = Math.max(1, cost);\\\\n}\\\\n\\\\n// Set Cost Limits\\\\nif (note.match(/<TP COST MAX:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.min(cost, Number(RegExp.$1));\\\\n}\\\\nif (note.match(/<TP COST MIN:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.max(cost, Number(RegExp.$1));\\\\n}\\\\n\\\\n// Return cost value\\\\nreturn Math.round(Math.max(0, cost));\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn user._tp >= cost;\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Process Payment\\\\nuser._tp -= cost;\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn cost > 0;\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = TextManager.tp;\\\\nconst icon = settings.Icon;\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<#%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\ntext += '%1 %2'.format(cost, name);\\\\n\\\\n// Text: Add Icon\\\\nif (icon  > 0) {\\\\n    text += '\\\\\\\\\\\\\\\\I[%1]'.format(icon);\\\\n}\\\\n\\\\n// Return text\\\\nreturn text;\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.maxTp();\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn user.tp;\\\"\",\"GaugeDrawJS:func\":\"\\\"// Declare Settings\\\\nconst color1 = ColorManager.tpGaugeColor1();\\\\nconst color2 = ColorManager.tpGaugeColor2();\\\\nconst label = TextManager.tpA;\\\\n\\\\n// Declare Variables\\\\nconst sprite = this;\\\\nconst settings = sprite._costSettings;\\\\nconst bitmap = sprite.bitmap;\\\\nconst user = sprite._battler;\\\\nconst currentValue = sprite.currentDisplayedValue();\\\\nconst bitmapWidth = sprite.bitmapWidth();\\\\nconst bitmapHeight = sprite.textHeight ? sprite.textHeight() : sprite.bitmapHeight();\\\\nconst gaugeHeight = sprite.gaugeHeight();\\\\n\\\\n// Draw Gauge\\\\nconst gx = 0;\\\\nconst gy = bitmapHeight - gaugeHeight;\\\\nconst gw = bitmapWidth - gx;\\\\nconst gh = gaugeHeight;\\\\nthis.drawFullGauge(color1, color2, gx, gy, gw, gh);\\\\n\\\\n// Draw Label\\\\nconst lx = 4;\\\\nconst ly = 0;\\\\nconst lw = bitmapWidth;\\\\nconst lh = bitmapHeight;\\\\nsprite.setupLabelFont();\\\\nbitmap.paintOpacity = 255;\\\\nbitmap.drawText(label, lx, ly, lw, lh, \\\\\\\"left\\\\\\\");\\\\n\\\\n// Draw Value\\\\nconst vw = bitmapWidth - 2;\\\\nconst vh = bitmapHeight;\\\\nsprite.setupValueFont();\\\\nbitmap.textColor = ColorManager.tpColor(user);\\\\nbitmap.drawText(currentValue, 0, 0, vw, vh, \\\\\\\"right\\\\\\\");\\\"\"}","{\"Name:str\":\"Gold\",\"Settings\":\"\",\"Icon:num\":\"0\",\"FontColor:str\":\"17\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\nif (note.match(/<GOLD COST:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost += Number(RegExp.$1);\\\\n}\\\\nif (note.match(/<GOLD COST:[ ](\\\\\\\\d+)([%％])>/i)) {\\\\n    cost += Math.ceil(Number(RegExp.$1) * $gameParty.gold() / 100);\\\\n}\\\\nif (note.match(/<JS GOLD COST>\\\\\\\\s*([\\\\\\\\s\\\\\\\\S]*)\\\\\\\\s*<\\\\\\\\/JS GOLD COST>/i)) {\\\\n    const code = String(RegExp.$1);\\\\n    eval(code);\\\\n}\\\\n\\\\n// Apply Trait Cost Alterations\\\\nif (cost > 0) {\\\\n    const rateNote = /<GOLD COST:[ ](\\\\\\\\d+\\\\\\\\.?\\\\\\\\d*)([%％])>/i;\\\\n    const rates = user.traitObjects().map((obj) => (obj && obj.note.match(rateNote) ? Number(RegExp.$1) / 100 : 1));\\\\n    const flatNote = /<GOLD COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)>/i;\\\\n    const flats = user.traitObjects().map((obj) => (obj && obj.note.match(flatNote) ? Number(RegExp.$1) : 0));\\\\n    cost = rates.reduce((r, rate) => r * rate, cost);\\\\n    cost = flats.reduce((r, flat) => r + flat, cost);\\\\n    cost = Math.max(1, cost);\\\\n}\\\\n\\\\n// Set Cost Limits\\\\nif (note.match(/<GOLD COST MAX:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.min(cost, Number(RegExp.$1));\\\\n}\\\\nif (note.match(/<GOLD COST MIN:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.max(cost, Number(RegExp.$1));\\\\n}\\\\n\\\\n// Return cost value\\\\nreturn Math.round(Math.max(0, cost));\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn $gameParty.gold() >= cost;\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Process Payment\\\\n$gameParty.loseGold(cost);\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn cost > 0;\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = TextManager.currencyUnit;\\\\nconst icon = settings.Icon;\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<#%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\ntext += '%1 %2'.format(cost, name);\\\\n\\\\n// Text: Add Icon\\\\nif (icon  > 0) {\\\\n    text += '\\\\\\\\\\\\\\\\I[%1]'.format(icon);\\\\n}\\\\n\\\\n// Return text\\\\nreturn text;\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn $gameParty.maxGold();\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn $gameParty.gold();\\\"\",\"GaugeDrawJS:func\":\"\\\"// Declare Variables\\\\nconst sprite = this;\\\\nconst settings = sprite._costSettings;\\\\nconst bitmap = sprite.bitmap;\\\\nconst user = sprite._battler;\\\\nconst currentValue = sprite.currentDisplayedValue();\\\\n\\\\n// Draw Label\\\\nconst label = TextManager.currencyUnit;\\\\nconst lx = 4;\\\\nconst ly = 0;\\\\nconst lw = sprite.bitmapWidth();\\\\nconst lh = sprite.bitmapHeight();\\\\nsprite.setupLabelFont();\\\\nbitmap.paintOpacity = 255;\\\\nbitmap.drawText(label, lx, ly, lw, lh, \\\\\\\"left\\\\\\\");\\\\n\\\\n// Draw Value\\\\nconst vw = sprite.bitmapWidth() - 2;\\\\nconst vh = sprite.bitmapHeight();\\\\nsprite.setupValueFont();\\\\nbitmap.textColor = ColorManager.normalColor();\\\\nbitmap.drawText(currentValue, 0, 0, vw, vh, \\\\\\\"right\\\\\\\");\\\"\"}","{\"Name:str\":\"Potion\",\"Settings\":\"\",\"Icon:num\":\"176\",\"FontColor:str\":\"0\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\nif (note.match(/<POTION COST:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost += Number(RegExp.$1);\\\\n}\\\\nif (note.match(/<JS POTION COST>\\\\\\\\s*([\\\\\\\\s\\\\\\\\S]*)\\\\\\\\s*<\\\\\\\\/JS POTION COST>/i)) {\\\\n    const code = String(RegExp.$1);\\\\n    eval(code);\\\\n}\\\\n\\\\n// Apply Trait Cost Alterations\\\\nif (cost > 0) {\\\\n    const rateNote = /<POTION COST:[ ](\\\\\\\\d+\\\\\\\\.?\\\\\\\\d*)([%％])>/i;\\\\n    const rates = user.traitObjects().map((obj) => (obj && obj.note.match(rateNote) ? Number(RegExp.$1) / 100 : 1));\\\\n    const flatNote = /<POTION COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)>/i;\\\\n    const flats = user.traitObjects().map((obj) => (obj && obj.note.match(flatNote) ? Number(RegExp.$1) : 0));\\\\n    cost = rates.reduce((r, rate) => r * rate, cost);\\\\n    cost = flats.reduce((r, flat) => r + flat, cost);\\\\n    cost = Math.max(1, cost);\\\\n}\\\\n\\\\n// Set Cost Limits\\\\nif (note.match(/<POTION COST MAX:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.min(cost, Number(RegExp.$1));\\\\n}\\\\nif (note.match(/<POTION COST MIN:[ ](\\\\\\\\d+)>/i)) {\\\\n    cost = Math.max(cost, Number(RegExp.$1));\\\\n}\\\\n\\\\n// Return cost value\\\\nreturn Math.round(Math.max(0, cost));\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst item = $dataItems[7];\\\\n\\\\n// Return Boolean\\\\nif (user.isActor() && cost > 0) {\\\\n    return $gameParty.numItems(item) >= cost;\\\\n} else {\\\\n    return true;\\\\n}\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst item = $dataItems[7];\\\\n\\\\n// Process Payment\\\\nif (user.isActor()) {\\\\n    $gameParty.loseItem(item, cost);\\\\n}\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Return Boolean\\\\nreturn cost > 0;\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst item = $dataItems[7];\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = settings.Name;\\\\nconst icon = settings.Icon;\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<#%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\ntext += '×%1'.format(cost);\\\\n\\\\n// Text: Add Icon\\\\ntext += '\\\\\\\\\\\\\\\\I[%1]'.format(item.iconIndex);\\\\n\\\\n// Return text\\\\nreturn text;\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst item = $dataItems[7];\\\\n\\\\n// Return value\\\\nreturn $gameParty.maxItems(item);\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst item = $dataItems[7];\\\\n\\\\n// Return value\\\\nreturn $gameParty.numItems(item);\\\"\",\"GaugeDrawJS:func\":\"\\\"// Declare Settings\\\\nconst color1 = ColorManager.textColor(30);\\\\nconst color2 = ColorManager.textColor(31);\\\\n\\\\n// Declare Variables\\\\nconst sprite = this;\\\\nconst settings = sprite._costSettings;\\\\nconst bitmap = sprite.bitmap;\\\\nconst user = sprite._battler;\\\\nconst item = $dataItems[7];\\\\nconst currentValue = sprite.currentDisplayedValue();\\\\nconst bitmapWidth = sprite.bitmapWidth();\\\\nconst bitmapHeight = sprite.textHeight ? sprite.textHeight() : sprite.bitmapHeight();\\\\nconst gaugeHeight = sprite.gaugeHeight();\\\\n\\\\n// Draw Gauge\\\\nconst gx = 0;\\\\nconst gy = bitmapHeight - gaugeHeight;\\\\nconst gw = bitmapWidth - gx;\\\\nconst gh = gaugeHeight;\\\\nthis.drawFullGauge(color1, color2, gx, gy, gw, gh);\\\\n\\\\n// Draw Icon\\\\nconst iconIndex = item.iconIndex;\\\\nconst iconBitmap = ImageManager.loadSystem(\\\\\\\"IconSet\\\\\\\");\\\\nconst pw = ImageManager.iconWidth;\\\\nconst ph = ImageManager.iconHeight;\\\\nconst sx = (iconIndex % 16) * pw;\\\\nconst sy = Math.floor(iconIndex / 16) * ph;\\\\nbitmap.blt(iconBitmap, sx, sy, pw, ph, 0, 0, 24, 24);\\\\n\\\\n// Draw Value\\\\nconst vw = bitmapWidth - 2;\\\\nconst vh = bitmapHeight;\\\\nsprite.setupValueFont();\\\\nbitmap.textColor = ColorManager.normalColor();\\\\nbitmap.drawText(currentValue, 0, 0, vw, vh, \\\\\\\"right\\\\\\\");\\\"\"}","{\"Name:str\":\"Item Cost\",\"Settings\":\"\",\"Icon:num\":\"0\",\"FontColor:str\":\"0\",\"FontSize:num\":\"22\",\"Cost\":\"\",\"CalcJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nlet cost = 0;\\\\n\\\\n// Calculations\\\\nconst note = skill.note;\\\\ncost = {\\\\n    items: {},\\\\n    weapons: {},\\\\n    armors: {},\\\\n};\\\\n\\\\n// Gather Cost Notetags\\\\n{ // Item Costs\\\\n    const notetag = /<ITEM COST:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n    const matches = note.match(notetag);\\\\n    if (matches) {\\\\n        for (const currentMatch of matches) {\\\\n            currentMatch.match(notetag);\\\\n            const amount = Number(RegExp.$1);\\\\n            const name = String(RegExp.$2).toUpperCase().trim();\\\\n            const entry = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n            if (entry) {\\\\n                cost.items[entry.id] = amount;\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n{ // Weapon Costs\\\\n    const notetag = /<WEAPON COST:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n    const matches = note.match(notetag);\\\\n    if (matches) {\\\\n        for (const currentMatch of matches) {\\\\n            currentMatch.match(notetag);\\\\n            const amount = Number(RegExp.$1);\\\\n            const name = String(RegExp.$2).toUpperCase().trim();\\\\n            const entry = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n            if (entry) {\\\\n                cost.weapons[entry.id] = amount;\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n{ // Armor Costs\\\\n    const notetag = /<ARMOR COST:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n    const matches = note.match(notetag);\\\\n    if (matches) {\\\\n        for (const currentMatch of matches) {\\\\n            currentMatch.match(notetag);\\\\n            const amount = Number(RegExp.$1);\\\\n            const name = String(RegExp.$2).toUpperCase().trim();\\\\n            const entry = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n            if (entry) {\\\\n                cost.armors[entry.id] = amount;\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Declare Trait Objects\\\\nconst traitObjects = user.traitObjects();\\\\n\\\\n// Apply Cost Rate Modifiers\\\\nfor (const traitObject of traitObjects) {\\\\n    if (!traitObject) continue;\\\\n    const objNote = traitObject.note || '';\\\\n    { // Item Cost Rate Modifiers\\\\n        const notetag = /<ITEM COST:[ ](\\\\\\\\d+)([%％])[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const rate = Number(RegExp.$1) * 0.01;\\\\n                const name = String(RegExp.$3).toUpperCase().trim();\\\\n                const entry = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.items[entry.id]) {\\\\n                    cost.items[entry.id] = Math.ceil(cost.items[entry.id] * rate);\\\\n                    if (cost.items[entry.id] <= 0) cost.items[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Weapon Cost Rate Modifiers\\\\n        const notetag = /<WEAPON COST:[ ](\\\\\\\\d+)([%％])[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const rate = Number(RegExp.$1) * 0.01;\\\\n                const name = String(RegExp.$3).toUpperCase().trim();\\\\n                const entry = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.weapons[entry.id]) {\\\\n                    cost.weapons[entry.id] = Math.ceil(cost.weapons[entry.id] * rate);\\\\n                    if (cost.weapons[entry.id] <= 0) cost.weapons[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Armor Cost Rate Modifiers\\\\n        const notetag = /<ARMOR COST:[ ](\\\\\\\\d+)([%％])[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const rate = Number(RegExp.$1) * 0.01;\\\\n                const name = String(RegExp.$3).toUpperCase().trim();\\\\n                const entry = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.armors[entry.id]) {\\\\n                    cost.armors[entry.id] = Math.ceil(cost.armors[entry.id] * rate);\\\\n                    if (cost.armors[entry.id] <= 0) cost.armors[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Apply Flat Cost Modifiers\\\\nfor (const traitObject of traitObjects) {\\\\n    if (!traitObject) continue;\\\\n    const objNote = traitObject.note || '';\\\\n    { // Item Flat Cost Modifiers\\\\n        const notetag = /<ITEM COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const flat = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.items[entry.id]) {\\\\n                    cost.items[entry.id] += flat;\\\\n                    if (cost.items[entry.id] <= 0) cost.items[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Weapon Flat Cost Modifiers\\\\n        const notetag = /<WEAPON COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const flat = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.weapons[entry.id]) {\\\\n                    cost.weapons[entry.id] += flat;\\\\n                    if (cost.weapons[entry.id] <= 0) cost.weapons[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Armor Flat Cost Modifiers\\\\n        const notetag = /<ARMOR COST:[ ]([\\\\\\\\+\\\\\\\\-]\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const flat = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.armors[entry.id]) {\\\\n                    cost.armors[entry.id] += flat;\\\\n                    if (cost.armors[entry.id] <= 0) cost.armors[entry.id] = 0;\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Set Cost Limits\\\\n{ // Item Cost Limits\\\\n    { // Maximum Cost\\\\n        const notetag = /<ITEM COST MAX:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const max = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.items[entry.id] !== undefined) {\\\\n                    cost.items[entry.id] = Math.min(max, cost.items[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Minimum Cost\\\\n        const notetag = /<ITEM COST MIN:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const min = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.items[entry.id] !== undefined) {\\\\n                    cost.items[entry.id] = Math.max(min, cost.items[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n{ // Weapon Cost Limits\\\\n    { // Maximum Cost\\\\n        const notetag = /<WEAPON COST MAX:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const max = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.weapons[entry.id] !== undefined) {\\\\n                    cost.weapons[entry.id] = Math.min(max, cost.weapons[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Minimum Cost\\\\n        const notetag = /<WEAPON COST MIN:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const min = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.weapons[entry.id] !== undefined) {\\\\n                    cost.weapons[entry.id] = Math.max(min, cost.weapons[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n{ // Armor Cost Limits\\\\n    { // Maximum Cost\\\\n        const notetag = /<ARMOR COST MAX:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const max = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.armors[entry.id] !== undefined) {\\\\n                    cost.armors[entry.id] = Math.min(max, cost.armors[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Minimum Cost\\\\n        const notetag = /<ARMOR COST MIN:[ ](\\\\\\\\d+)[ ](.*)>/gi;\\\\n        const matches = note.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const min = Number(RegExp.$1);\\\\n                const name = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name);\\\\n                if (entry && cost.armors[entry.id] !== undefined) {\\\\n                    cost.armors[entry.id] = Math.max(min, cost.armors[entry.id]);\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Apply Replacement Costs\\\\nfor (const traitObject of traitObjects) {\\\\n    if (!traitObject) continue;\\\\n    const objNote = traitObject.note || '';\\\\n    { // Item Replacement Costs\\\\n        const notetag = /<REPLACE ITEM (.*) COST:[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const name1 = String(RegExp.$1).toUpperCase().trim();\\\\n                const name2 = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry1 = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name1);\\\\n                const entry2 = $dataItems.find(obj => obj && obj.name.toUpperCase().trim() === name2);\\\\n                if (entry1 && entry2 && cost.items[entry1.id]) {\\\\n                    cost.items[entry2.id] = cost.items[entry1.id];\\\\n                    delete cost.items[entry1.id];\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Weapon Replacement Costs\\\\n        const notetag = /<REPLACE WEAPON (.*) COST:[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const name1 = String(RegExp.$1).toUpperCase().trim();\\\\n                const name2 = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry1 = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name1);\\\\n                const entry2 = $dataWeapons.find(obj => obj && obj.name.toUpperCase().trim() === name2);\\\\n                if (entry1 && entry2 && cost.weapons[entry1.id]) {\\\\n                    cost.weapons[entry2.id] = cost.weapons[entry1.id];\\\\n                    delete cost.items[entry1.id];\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n    { // Armor Replacement Costs\\\\n        const notetag = /<REPLACE ARMOR (.*) COST:[ ](.*)>/gi;\\\\n        const matches = objNote.match(notetag);\\\\n        if (matches) {\\\\n            for (const currentMatch of matches) {\\\\n                currentMatch.match(notetag);\\\\n                const name1 = String(RegExp.$1).toUpperCase().trim();\\\\n                const name2 = String(RegExp.$2).toUpperCase().trim();\\\\n                const entry1 = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name1);\\\\n                const entry2 = $dataArmors.find(obj => obj && obj.name.toUpperCase().trim() === name2);\\\\n                if (entry1 && entry2 && cost.armors[entry1.id]) {\\\\n                    cost.armors[entry2.id] = cost.armors[entry1.id];\\\\n                    delete cost.items[entry1.id];\\\\n                }\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Return cost data\\\\nreturn cost;\\\"\",\"CanPayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Check Individual Costs\\\\n{ // Check Item Costs\\\\n    for (let id in cost.items) {\\\\n        const obj = $dataItems[id];\\\\n        if (obj) {\\\\n            const costAmount = cost.items[id];\\\\n            const ownedAmount = $gameParty.numItems(obj);\\\\n            if (costAmount > ownedAmount) return false;\\\\n        }\\\\n    }\\\\n}\\\\n{ // Check Weapon Costs\\\\n    for (let id in cost.weapons) {\\\\n        const obj = $dataWeapons[id];\\\\n        if (obj) {\\\\n            const costAmount = cost.weapons[id];\\\\n            const ownedAmount = $gameParty.numItems(obj);\\\\n            if (costAmount > ownedAmount) return false;\\\\n        }\\\\n    }\\\\n}\\\\n{ // Check Armor Costs\\\\n    for (let id in cost.armors) {\\\\n        const obj = $dataArmors[id];\\\\n        if (obj) {\\\\n            const costAmount = cost.armors[id];\\\\n            const ownedAmount = $gameParty.numItems(obj);\\\\n            if (costAmount > ownedAmount) return false;\\\\n        }\\\\n    }\\\\n}\\\\n\\\\n// Return True\\\\nreturn true;\\\"\",\"PayJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Process Payment\\\\n{ // Check Item Costs\\\\n    for (let id in cost.items) {\\\\n        const obj = $dataItems[id];\\\\n        if (obj && obj.consumable) {\\\\n            if (obj.itypeId !== 2) {\\\\n                const costAmount = cost.items[id];\\\\n                $gameParty.loseItem(obj, costAmount);\\\\n            }\\\\n        }\\\\n    }\\\\n}\\\\n{ // Check Weapon Costs\\\\n    for (let id in cost.weapons) {\\\\n        const obj = $dataWeapons[id];\\\\n        if (obj) {\\\\n            const costAmount = cost.weapons[id];\\\\n            $gameParty.loseItem(obj, costAmount);\\\\n        }\\\\n    }\\\\n}\\\\n{ // Check Armor Costs\\\\n    for (let id in cost.armors) {\\\\n        const obj = $dataArmors[id];\\\\n        if (obj) {\\\\n            const costAmount = cost.armors[id];\\\\n            $gameParty.loseItem(obj, costAmount);\\\\n        }\\\\n    }\\\\n}\\\"\",\"Windows\":\"\",\"ShowJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\n\\\\n// Check Keys\\\\nconst keys = ['items', 'weapons', 'armors'];\\\\n\\\\n// Return False\\\\nreturn keys.some(key => Object.keys(cost[key]).length > 0);\\\"\",\"TextJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\nconst skill = arguments[0];\\\\nconst cost = arguments[1];\\\\nconst settings = arguments[2];\\\\nconst fontSize = settings.FontSize;\\\\nconst color = settings.FontColor;\\\\nconst name = settings.Name;\\\\nconst icon = settings.Icon;\\\\nconst keys = ['items', 'weapons', 'armors'];\\\\nlet text = '';\\\\n\\\\n// Text: Change Font Size\\\\ntext += '\\\\\\\\\\\\\\\\FS[%1]'.format(fontSize);\\\\n\\\\n// Text: Add Color\\\\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\\\\n    text += '\\\\\\\\\\\\\\\\HexColor<#%1>'.format(String(RegExp.$1));\\\\n} else {\\\\n    text += '\\\\\\\\\\\\\\\\C[%1]'.format(color);\\\\n}\\\\n\\\\n// Text: Add Cost\\\\nfor (const key of keys) {\\\\n    const database = [$dataItems, $dataWeapons, $dataArmors][keys.indexOf(key)];\\\\n    const costData = cost[key];\\\\n    const idList = Object.keys(costData).sort((a, b) => a - b);\\\\n    for (const id of idList) {\\\\n        const obj = database[id];\\\\n        const iconIndex = obj.iconIndex;\\\\n        const costAmount = costData[id];\\\\n        text += '\\\\\\\\\\\\\\\\I[%1]×%2 '.format(iconIndex, costAmount);\\\\n    }\\\\n}\\\\n\\\\n// Return text\\\\nreturn text.trim();\\\"\",\"Gauges\":\"\",\"GaugeMaxJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn 0;\\\"\",\"GaugeCurrentJS:func\":\"\\\"// Declare Variables\\\\nconst user = this;\\\\n\\\\n// Return value\\\\nreturn 0;\\\"\",\"GaugeDrawJS:func\":\"\\\"// Don't Draw Anything\\\\n// This does not work as a gauge.\\\"\"}"]
 *
 * @param Gauge:struct
 * @text Gauge Settings
 * @parent Skills:struct
 * @type struct<Gauge>
 * @desc Settings in regards to how skill cost gauges function and appear.
 * @default {"Labels":"","LabelFontMainType:str":"main","MatchLabelColor:eval":"true","MatchLabelGaugeColor:num":"2","PresetLabelGaugeColor:num":"16","LabelOutlineSolid:eval":"true","LabelOutlineWidth:num":"3","Values":"","ValueFontMainType:str":"number","ValueOutlineSolid:eval":"true","ValueOutlineWidth:num":"3"}
 *
 * @param BreakSkills
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param States:struct
 * @text State Settings
 * @type struct<States>
 * @desc Adjust general state settings here.
 * @default {"General":"","ReapplyRules:str":"greater","MaxTurns:num":"99","ActionEndUpdate:eval":"true","Turns":"","ShowTurns:eval":"true","TurnFontSize:num":"16","TurnOffsetX:num":"-4","TurnOffsetY:num":"-6","ColorNeutral:str":"0","ColorPositive:str":"24","ColorNegative:str":"27","Data":"","ShowData:eval":"true","DataFontSize:num":"12","DataOffsetX:num":"0","DataOffsetY:num":"8","CustomJS":"","onAddStateJS:func":"\"// Declare Variables\\nconst stateId = arguments[0];\\nconst origin = this.getStateOrigin(stateId);\\nconst state = $dataStates[stateId];\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\"","onEraseStateJS:func":"\"// Declare Variables\\nconst stateId = arguments[0];\\nconst origin = this.getStateOrigin(stateId);\\nconst state = $dataStates[stateId];\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onExpireStateJS:func":"\"// Declare Variables\\nconst stateId = arguments[0];\\nconst origin = this.getStateOrigin(stateId);\\nconst state = $dataStates[stateId];\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\""}
 *
 * @param Buffs:struct
 * @text Buff/Debuff Settings
 * @parent States:struct
 * @type struct<Buffs>
 * @desc Adjust general buff/debuff settings here.
 * @default {"General":"","ReapplyRules:str":"greater","MaxTurns:num":"99","Stacking":"","StackBuffMax:num":"2","StackDebuffMax:num":"2","MultiplierJS:func":"\"// Declare Variables\\nconst user = this;\\nconst paramId = arguments[0];\\nconst buffLevel = arguments[1];\\nlet rate = 1;\\n\\n// Perform Calculations\\nrate += buffLevel * 0.25;\\n\\n// Return Rate\\nreturn Math.max(0, rate);\"","Turns":"","ShowTurns:eval":"true","TurnFontSize:num":"16","TurnOffsetX:num":"-4","TurnOffsetY:num":"-6","ColorBuff:str":"24","ColorDebuff:str":"27","Data":"","ShowData:eval":"false","DataFontSize:num":"12","DataOffsetX:num":"0","DataOffsetY:num":"8","CustomJS":"","onAddBuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onAddDebuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onEraseBuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onEraseDebuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onExpireBuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\"","onExpireDebuffJS:func":"\"// Declare Variables\\nconst paramId = arguments[0];\\nconst modifier = this._buffs[paramId];\\nconst origin = this.getCurrentStateActiveUser();\\nconst user = this.getCurrentStateActiveUser();\\nconst target = this;\\nconst a = origin;\\nconst b = this;\\n\\n// Perform Actions\\n\""}
 *
 * @param PassiveStates:struct
 * @text Passive States
 * @parent States:struct
 * @type struct<PassiveStates>
 * @desc Adjust passive state settings here.
 * @default {"List":"","Global:arraynum":"[]","Actor:arraynum":"[]","Enemy:arraynum":"[]","CustomJS":"","PassiveConditionJS:func":"\"// Declare Variables\\nconst state = arguments[0];\\nconst stateId = state.id;\\nconst user = this;\\nconst target = this;\\nconst a = this;\\nconst b = this;\\nlet condition = true;\\n\\n// Perform Checks\\n\\n\\n// Return boolean\\nreturn condition;\""}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * General Skill Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Skills:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Skill Menu Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/left
 *
 * @param SkillTypeWindow
 * @text Skill Type Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent SkillTypeWindow
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Skill Type Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent SkillTypeWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Skill Type Window.
 * @default left
 * 
 * @param CmdWidth:num
 * @text Window Width
 * @parent SkillTypeWindow
 * @type number
 * @min 1
 * @desc What is the desired pixel width of this window?
 * Default: 240
 * @default 240
 *
 * @param ListWindow
 * @text List Window
 *
 * @param ListWindowCols:num
 * @text Columns
 * @parent ListWindow
 * @type number
 * @min 1
 * @desc Number of maximum columns.
 * @default 1
 *
 * @param ShopStatusWindow
 * @text Shop Status Window
 *
 * @param ShowShopStatus:eval
 * @text Show in Skill Menu?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Show the Shop Status Window in the Skill Menu?
 * This is enabled if the Updated Layout is on.
 * @default true
 *
 * @param SkillSceneAdjustSkillList:eval
 * @text Adjust List Window?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the Skill List Window in the Skill Menu if using the Shop Status Window?
 * @default true
 *
 * @param SkillSceneStatusBgType:num
 * @text Background Type
 * @parent ShopStatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SkillMenuStatusRect:func
 * @text JS: X, Y, W, H
 * @parent ShopStatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this Shop Status Window in the Skill Menu.
 * @default "const ww = this.shopStatusWidth();\nconst wh = this._itemWindow.height;\nconst wx = Graphics.boxWidth - this.shopStatusWidth();\nconst wy = this._itemWindow.y;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param SkillTypes
 * @text Skill Types
 *
 * @param HiddenSkillTypes:arraynum
 * @text Hidden Skill Types
 * @parent SkillTypes
 * @type number[]
 * @min 1
 * @max 99
 * @desc Insert the ID's of the Skill Types you want hidden from view ingame.
 * @default []
 *
 * @param BattleHiddenSkillTypes:arraynum
 * @text Hidden During Battle
 * @parent SkillTypes
 * @type number[]
 * @min 1
 * @max 99
 * @desc Insert the ID's of the Skill Types you want hidden during battle only.
 * @default []
 *
 * @param IconStypeNorm:num
 * @text Icon: Normal Type
 * @parent SkillTypes
 * @desc Icon used for normal skill types that aren't assigned any icons.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Icon: Magic Type
 * @parent SkillTypes
 * @desc Icon used for magic skill types that aren't assigned any icons.
 * @default 79
 *
 * @param CustomJS
 * @text Global JS Effects
 *
 * @param SkillConditionJS:func
 * @text JS: Skill Conditions
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide skill condition check.
 * @default "// Declare Variables\nconst skill = arguments[0];\nconst user = this;\nconst target = this;\nconst a = this;\nconst b = this;\nlet enabled = true;\n\n// Perform Checks\n\n\n// Return boolean\nreturn enabled;"
 *
 */
/* ----------------------------------------------------------------------------
 * Skill Cost Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Cost:
 *
 * @param Name:str
 * @text Name
 * @desc A name for this Skill Cost Type.
 * @default Untitled
 *
 * @param Settings
 *
 * @param Icon:num
 * @text Icon
 * @parent Settings
 * @desc Icon used for this Skill Cost Type.
 * Use 0 for no icon.
 * @default 0
 *
 * @param FontColor:str
 * @text Font Color
 * @parent Settings
 * @desc Text Color used to display this cost.
 * For a hex color, use #rrggbb with VisuMZ_1_MessageCore
 * @default 0
 *
 * @param FontSize:num
 * @text Font Size
 * @parent Settings
 * @type number
 * @min 1
 * @desc Font size used to display this cost.
 * @default 22
 *
 * @param Cost
 * @text Cost Processing
 *
 * @param CalcJS:func
 * @text JS: Cost Calculation
 * @parent Cost
 * @type note
 * @desc Code on how to calculate this resource cost for the skill.
 * @default "// Declare Variables\nconst user = this;\nconst skill = arguments[0];\nlet cost = 0;\n\n// Return cost value\nreturn Math.round(Math.max(0, cost));"
 *
 * @param CanPayJS:func
 * @text JS: Can Pay Cost?
 * @parent Cost
 * @type note
 * @desc Code on calculating whether or not the user is able to pay the cost.
 * @default "// Declare Variables\nconst user = this;\nconst skill = arguments[0];\nconst cost = arguments[1];\n\n// Return Boolean\nreturn true;"
 *
 * @param PayJS:func
 * @text JS: Paying Cost
 * @parent Cost
 * @type note
 * @desc Code for if met, this is the actual process of paying of the cost.
 * @default "// Declare Variables\nconst user = this;\nconst skill = arguments[0];\nconst cost = arguments[1];\n\n// Process Payment\n"
 *
 * @param Windows
 * @text Window Display
 *
 * @param ShowJS:func
 * @text JS: Show Cost?
 * @parent  Windows
 * @type note
 * @desc Code for determining if the cost is shown or not.
 * @default "// Declare Variables\nconst user = this;\nconst skill = arguments[0];\nconst cost = arguments[1];\n\n// Return Boolean\nreturn cost > 0;"
 *
 * @param TextJS:func
 * @text JS: Cost Text
 * @parent  Windows
 * @type note
 * @desc Code to determine the text (with Text Code support) used for the displayed cost.
 * @default "// Declare Variables\nconst user = this;\nconst skill = arguments[0];\nconst cost = arguments[1];\nconst settings = arguments[2];\nconst fontSize = settings.FontSize;\nconst color = settings.FontColor;\nconst name = settings.Name;\nconst icon = settings.Icon;\nlet text = '';\n\n// Text: Change Font Size\ntext += '\\\\FS[%1]'.format(fontSize);\n\n// Text: Add Color\nif (color.match(/#(.*)/i) && Imported.VisuMZ_1_MessageCore) {\n    text += '\\\\HexColor<#%1>'.format(String(RegExp.$1));\n} else {\n    text += '\\\\C[%1]'.format(color);\n}\n\n// Text: Add Cost\ntext += '%1 %2'.format(cost, name);\n\n// Text: Add Icon\nif (icon  > 0) {\n    text += '\\\\I[%1]'.format(icon);\n}\n\n// Return text\nreturn text;"
 *
 * @param Gauges
 * @text Gauge Display
 *
 * @param GaugeMaxJS:func
 * @text JS: Maximum Value
 * @parent  Gauges
 * @type note
 * @desc Code to determine the maximum value used for this Skill Cost resource for gauges.
 * @default "// Declare Variables\nconst user = this;\n\n// Return value\nreturn 0;"
 *
 * @param GaugeCurrentJS:func
 * @text JS: Current Value
 * @parent  Gauges
 * @type note
 * @desc Code to determine the current value used for this Skill Cost resource for gauges.
 * @default "// Declare Variables\nconst user = this;\n\n// Return value\nreturn 0;"
 *
 * @param GaugeDrawJS:func
 * @text JS: Draw Gauge
 * @parent  Gauges
 * @type note
 * @desc Code to determine how to draw the Skill Cost resource for this gauge type.
 * @default "// Declare Variables\nconst sprite = this;\nconst settings = sprite._costSettings;\nconst bitmap = sprite.bitmap;\nconst user = sprite._battler;\nconst currentValue = sprite.currentDisplayedValue();\n\n// Draw Gauge\nconst color1 = ColorManager.textColor(30);\nconst color2 = ColorManager.textColor(31);\nconst gx = 0;\nconst gy = sprite.bitmapHeight() - sprite.gaugeHeight();\nconst gw = sprite.bitmapWidth() - gx;\nconst gh = sprite.gaugeHeight();\nthis.drawFullGauge(color1, color2, gx, gy, gw, gh);\n\n// Draw Label\nconst label = settings.Name;\nconst lx = 4;\nconst ly = 0;\nconst lw = sprite.bitmapWidth();\nconst lh = sprite.bitmapHeight();\nsprite.setupLabelFont();\nbitmap.paintOpacity = 255;\nbitmap.drawText(label, lx, ly, lw, lh, \"left\");\n\n// Draw Value\nconst vw = sprite.bitmapWidth() - 2;\nconst vh = sprite.bitmapHeight();\nsprite.setupValueFont();\nbitmap.textColor = ColorManager.normalColor();\nbitmap.drawText(currentValue, 0, 0, vw, vh, \"right\");"
 *
 */
/* ----------------------------------------------------------------------------
 * Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Gauge:
 *
 * @param Labels
 *
 * @param LabelFontMainType:str
 * @text Font Type
 * @parent Labels
 * @type select
 * @option main
 * @option number
 * @desc Which font type should be used for labels?
 * @default main
 *
 * @param MatchLabelColor:eval
 * @text Match Label Color
 * @parent Labels
 * @type boolean
 * @on Match
 * @off Preset
 * @desc Match the label color to the Gauge Color being used?
 * @default true
 *
 * @param MatchLabelGaugeColor:num
 * @text Match: Gauge # ?
 * @parent MatchLabelColor:eval
 * @type number
 * @min 1
 * @max 2
 * @desc Which Gauge Color should be matched?
 * @default 2
 *
 * @param PresetLabelGaugeColor:num
 * @text Preset: Gauge Color
 * @parent MatchLabelColor:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 16
 *
 * @param LabelOutlineSolid:eval
 * @text Solid Outline
 * @parent Labels
 * @type boolean
 * @on Solid
 * @off Semi-Transparent
 * @desc Make the label outline a solid black color?
 * @default true
 *
 * @param LabelOutlineWidth:num
 * @text Outline Width
 * @parent Labels
 * @type number
 * @min 0
 * @desc What width do you wish to use for your outline?
 * Use 0 to not use an outline.
 * @default 3
 *
 * @param Values
 *
 * @param ValueFontMainType:str
 * @text Font Type
 * @parent Values
 * @type select
 * @option main
 * @option number
 * @desc Which font type should be used for values?
 * @default number
 *
 * @param ValueOutlineSolid:eval
 * @text Solid Outline
 * @parent Values
 * @type boolean
 * @on Solid
 * @off Semi-Transparent
 * @desc Make the value outline a solid black color?
 * @default true
 *
 * @param ValueOutlineWidth:num
 * @text Outline Width
 * @parent Values
 * @type number
 * @min 0
 * @desc What width do you wish to use for your outline?
 * Use 0 to not use an outline.
 * @default 3
 *
 */
/* ----------------------------------------------------------------------------
 * General State Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~States:
 *
 * @param General
 *
 * @param ReapplyRules:str
 * @text Reapply Rules
 * @parent General
 * @type select
 * @option Ignore: State doesn't get added.
 * @value ignore
 * @option Reset: Turns get reset.
 * @value reset
 * @option Greater: Turns take greater value (current vs reset).
 * @value greater
 * @option Add: Turns add upon existing turns.
 * @value add
 * @desc These are the rules when reapplying states.
 * @default greater
 *
 * @param MaxTurns:num
 * @text Maximum Turns
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of turns to let states go up to.
 * This can be changed with the <Max Turns: x> notetag.
 * @default 9999
 *
 * @param ActionEndUpdate:eval
 * @text Action End Update
 * @parent General
 * @type boolean
 * @on Update Each Action
 * @off Don't Change
 * @desc States with "Action End" auto-removal will also update
 * turns at the end of each action instead of all actions.
 * @default true
 *
 * @param TurnEndOnMap:num
 * @text Turn End on Map
 * @parent General
 * @type number
 * @desc Update any state and buff turns on the map after
 * this many steps. Use 0 to disable.
 * @default 20
 *
 * @param Turns
 * @text Turn Display
 *
 * @param ShowTurns:eval
 * @text Show Turns?
 * @parent Turns
 * @type boolean
 * @on Display
 * @off Hide
 * @desc Display state turns on top of window icons and sprites?
 * @default true
 *
 * @param TurnFontSize:num
 * @text Turn Font Size
 * @parent Turns
 * @type number
 * @min 1
 * @desc Font size used for displaying turns.
 * @default 16
 *
 * @param TurnOffsetX:num
 * @text Offset X
 * @parent Turns
 * @desc Offset the X position of the turn display.
 * @default -4
 *
 * @param TurnOffsetY:num
 * @text Offset Y
 * @parent Turns
 * @desc Offset the Y position of the turn display.
 * @default -6
 *
 * @param TurnFontSize:num
 * @text Turn Font Size
 * @parent Turns
 * @desc Font size used for displaying turns.
 * @default 16
 *
 * @param ColorNeutral:str
 * @text Turn Color: Neutral
 * @parent Turns
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param ColorPositive:str
 * @text Turn Color: Positive
 * @parent Turns
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param ColorNegative:str
 * @text Turn Color: Negative
 * @parent Turns
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 27
 *
 * @param Data
 * @text Data Display
 *
 * @param ShowData:eval
 * @text Show Data?
 * @parent Data
 * @type boolean
 * @on Display
 * @off Hide
 * @desc Display state data on top of window icons and sprites?
 * @default true
 *
 * @param DataFontSize:num
 * @text Data Font Size
 * @parent Data
 * @type number
 * @min 1
 * @desc Font size used for displaying state data.
 * @default 12
 *
 * @param DataOffsetX:num
 * @text Offset X
 * @parent Data
 * @desc Offset the X position of the state data display.
 * @default 0
 *
 * @param DataOffsetY:num
 * @text Offset Y
 * @parent Data
 * @desc Offset the Y position of the state data display.
 * @default 8
 *
 * @param CustomJS
 * @text Global JS Effects
 *
 * @param onAddStateJS:func
 * @text JS: On Add State
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * state is added.
 * @default "// Declare Variables\nconst stateId = arguments[0];\nconst origin = this.getStateOrigin(stateId);\nconst state = $dataStates[stateId];\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onEraseStateJS:func
 * @text JS: On Erase State
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * state is erased.
 * @default "// Declare Variables\nconst stateId = arguments[0];\nconst origin = this.getStateOrigin(stateId);\nconst state = $dataStates[stateId];\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onExpireStateJS:func
 * @text JS: On Expire State
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * state has expired.
 * @default "// Declare Variables\nconst stateId = arguments[0];\nconst origin = this.getStateOrigin(stateId);\nconst state = $dataStates[stateId];\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * General Buff/Debuff Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Buffs:
 *
 * @param General
 *
 * @param ReapplyRules:str
 * @text Reapply Rules
 * @parent General
 * @type select
 * @option Ignore: Buff/Debuff doesn't get added.
 * @value ignore
 * @option Reset: Turns get reset.
 * @value reset
 * @option Greater: Turns take greater value (current vs reset).
 * @value greater
 * @option Add: Turns add upon existing turns.
 * @value add
 * @desc These are the rules when reapplying buffs/debuffs.
 * @default greater
 *
 * @param MaxTurns:num
 * @text Maximum Turns
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of turns to let buffs and debuffs go up to.
 * @default 9999
 *
 * @param Stacking
 *
 * @param StackBuffMax:num
 * @text Max Stacks: Buff
 * @parent Stacking
 * @type number
 * @min 1
 * @desc Maximum number of stacks for buffs.
 * @default 2
 *
 * @param StackDebuffMax:num
 * @text Max Stacks: Debuff
 * @parent Stacking
 * @type number
 * @min 1
 * @desc Maximum number of stacks for debuffs.
 * @default 2
 *
 * @param MultiplierJS:func
 * @text JS: Buff/Debuff Rate
 * @parent Stacking
 * @type note
 * @desc Code to determine how much buffs and debuffs affect parameters.
 * @default "// Declare Variables\nconst user = this;\nconst paramId = arguments[0];\nconst buffLevel = arguments[1];\nlet rate = 1;\n\n// Perform Calculations\nrate += buffLevel * 0.25;\n\n// Return Rate\nreturn Math.max(0, rate);"
 *
 * @param Turns
 * @text Turns Display
 *
 * @param ShowTurns:eval
 * @text Show Turns?
 * @parent Turns
 * @type boolean
 * @on Display
 * @off Hide
 * @desc Display buff and debuff turns on top of window icons and sprites?
 * @default true
 *
 * @param TurnFontSize:num
 * @text Turn Font Size
 * @parent Turns
 * @type number
 * @min 1
 * @desc Font size used for displaying turns.
 * @default 16
 *
 * @param TurnOffsetX:num
 * @text Offset X
 * @parent Turns
 * @desc Offset the X position of the turn display.
 * @default -4
 *
 * @param TurnOffsetY:num
 * @text Offset Y
 * @parent Turns
 * @desc Offset the Y position of the turn display.
 * @default -6
 *
 * @param ColorBuff:str
 * @text Turn Color: Buffs
 * @parent Turns
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param ColorDebuff:str
 * @text Turn Color: Debuffs
 * @parent Turns
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 27
 *
 * @param Data
 * @text Rate Display
 *
 * @param ShowData:eval
 * @text Show Rate?
 * @parent Data
 * @type boolean
 * @on Display
 * @off Hide
 * @desc Display buff and debuff rate on top of window icons and sprites?
 * @default false
 *
 * @param DataFontSize:num
 * @text Rate Font Size
 * @parent Data
 * @type number
 * @min 1
 * @desc Font size used for displaying rate.
 * @default 12
 *
 * @param DataOffsetX:num
 * @text Offset X
 * @parent Data
 * @desc Offset the X position of the rate display.
 * @default 0
 *
 * @param DataOffsetY:num
 * @text Offset Y
 * @parent Data
 * @desc Offset the Y position of the rate display.
 * @default 8
 *
 * @param CustomJS
 * @text Global JS Effects
 *
 * @param onAddBuffJS:func
 * @text JS: On Add Buff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * buff is added.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onAddDebuffJS:func
 * @text JS: On Add Debuff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * debuff is added.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onEraseBuffJS:func
 * @text JS: On Erase Buff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * buff is erased.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onEraseDebuffJS:func
 * @text JS: On Erase Debuff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * debuff is erased.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onExpireBuffJS:func
 * @text JS: On Expire Buff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * buff has expired.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 * @param onExpireDebuffJS:func
 * @text JS: On Expire Debuff
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide custom effect whenever a
 * debuff has expired.
 * @default "// Declare Variables\nconst paramId = arguments[0];\nconst modifier = this._buffs[paramId];\nconst origin = this.getCurrentStateActiveUser();\nconst user = this.getCurrentStateActiveUser();\nconst target = this;\nconst a = origin;\nconst b = this;\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Passive State Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PassiveStates:
 *
 * @param List
 *
 * @param Global:arraynum
 * @text Global Passives
 * @parent List
 * @type state[]
 * @desc A list of passive states to affect actors and enemies.
 * @default []
 *
 * @param Actor:arraynum
 * @text Actor-Only Passives
 * @parent List
 * @type state[]
 * @desc A list of passive states to affect actors only.
 * @default []
 *
 * @param Enemy:arraynum
 * @text Enemy Passives
 * @parent List
 * @type state[]
 * @desc A list of passive states to affect enemies only.
 * @default []
 *
 * @param Cache
 *
 * @param RefreshCacheSwitch:eval
 * @text Switch Refresh?
 * @parent Cache
 * @type boolean
 * @on Refresh
 * @off No Changes
 * @desc Refresh all battle members when switches are changed in battle?
 * @default false
 *
 * @param RefreshCacheVar:eval
 * @text Variable Refresh?
 * @parent Cache
 * @type boolean
 * @on Refresh
 * @off No Changes
 * @desc Refresh all battle members when variables are changed in battle?
 * @default false
 *
 * @param CustomJS
 * @text Global JS Effects
 *
 * @param PassiveConditionJS:func
 * @text JS: Condition Check
 * @parent CustomJS
 * @type note
 * @desc JavaScript code for a global-wide passive condition check.
 * @default "// Declare Variables\nconst state = arguments[0];\nconst stateId = state.id;\nconst user = this;\nconst target = this;\nconst a = this;\nconst b = this;\nlet condition = true;\n\n// Perform Checks\n\n\n// Return boolean\nreturn condition;"
 *
 */
//=============================================================================

const _0x19f7cd=_0xb38a;(function(_0x5afecd,_0x258b41){const _0x3b9f4a=_0xb38a,_0x3ac66a=_0x5afecd();while(!![]){try{const _0x4867af=-parseInt(_0x3b9f4a(0x1ab))/0x1+-parseInt(_0x3b9f4a(0x2ad))/0x2*(parseInt(_0x3b9f4a(0x298))/0x3)+-parseInt(_0x3b9f4a(0x325))/0x4*(parseInt(_0x3b9f4a(0x2a1))/0x5)+-parseInt(_0x3b9f4a(0x366))/0x6*(parseInt(_0x3b9f4a(0x1aa))/0x7)+-parseInt(_0x3b9f4a(0x336))/0x8*(-parseInt(_0x3b9f4a(0x489))/0x9)+parseInt(_0x3b9f4a(0x25e))/0xa+parseInt(_0x3b9f4a(0x212))/0xb*(parseInt(_0x3b9f4a(0x3ca))/0xc);if(_0x4867af===_0x258b41)break;else _0x3ac66a['push'](_0x3ac66a['shift']());}catch(_0x4156ed){_0x3ac66a['push'](_0x3ac66a['shift']());}}}(_0x24f9,0xef6d4));function _0xb38a(_0x3815ef,_0x43a9a5){const _0x24f992=_0x24f9();return _0xb38a=function(_0xb38a9b,_0x1b26b0){_0xb38a9b=_0xb38a9b-0x130;let _0x550c00=_0x24f992[_0xb38a9b];return _0x550c00;},_0xb38a(_0x3815ef,_0x43a9a5);}var label=_0x19f7cd(0x21a),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x19f7cd(0x3ab)](function(_0x430033){const _0x1ae2ae=_0x19f7cd;return _0x430033[_0x1ae2ae(0x1e0)]&&_0x430033['description']['includes']('['+label+']');})[0x0];VisuMZ[label][_0x19f7cd(0x417)]=VisuMZ[label][_0x19f7cd(0x417)]||{},VisuMZ[_0x19f7cd(0x221)]=function(_0x535bc0,_0x2dfcbb){const _0x1251f8=_0x19f7cd;for(const _0x3adb82 in _0x2dfcbb){if(_0x3adb82['match'](/(.*):(.*)/i)){if('EwTLv'===_0x1251f8(0x3e8)){const _0x3854e2=String(RegExp['$1']),_0x158cd1=String(RegExp['$2'])[_0x1251f8(0x3cd)]()['trim']();let _0xfc6531,_0x2aa518,_0x36d7ed;switch(_0x158cd1){case _0x1251f8(0x38f):_0xfc6531=_0x2dfcbb[_0x3adb82]!==''?Number(_0x2dfcbb[_0x3adb82]):0x0;break;case _0x1251f8(0x452):_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON['parse'](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0x3c271b=>Number(_0x3c271b));break;case _0x1251f8(0x1ea):_0xfc6531=_0x2dfcbb[_0x3adb82]!==''?eval(_0x2dfcbb[_0x3adb82]):null;break;case _0x1251f8(0x2e0):_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0x228843=>eval(_0x228843));break;case _0x1251f8(0x404):_0xfc6531=_0x2dfcbb[_0x3adb82]!==''?JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82]):'';break;case'ARRAYJSON':_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0x3c27c9=>JSON[_0x1251f8(0x256)](_0x3c27c9));break;case _0x1251f8(0x18b):_0xfc6531=_0x2dfcbb[_0x3adb82]!==''?new Function(JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82])):new Function(_0x1251f8(0x2b4));break;case'ARRAYFUNC':_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0xecfe6=>new Function(JSON[_0x1251f8(0x256)](_0xecfe6)));break;case _0x1251f8(0x381):_0xfc6531=_0x2dfcbb[_0x3adb82]!==''?String(_0x2dfcbb[_0x3adb82]):'';break;case _0x1251f8(0x142):_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON['parse'](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0x42fe36=>String(_0x42fe36));break;case'STRUCT':_0x36d7ed=_0x2dfcbb[_0x3adb82]!==''?JSON[_0x1251f8(0x256)](_0x2dfcbb[_0x3adb82]):{},_0x535bc0[_0x3854e2]={},VisuMZ['ConvertParams'](_0x535bc0[_0x3854e2],_0x36d7ed);continue;case'ARRAYSTRUCT':_0x2aa518=_0x2dfcbb[_0x3adb82]!==''?JSON['parse'](_0x2dfcbb[_0x3adb82]):[],_0xfc6531=_0x2aa518[_0x1251f8(0x466)](_0x3ca94f=>VisuMZ[_0x1251f8(0x221)]({},JSON[_0x1251f8(0x256)](_0x3ca94f)));break;default:continue;}_0x535bc0[_0x3854e2]=_0xfc6531;}else return _0x42e290['mainFontSize']()-0x6;}}return _0x535bc0;},(_0x465324=>{const _0x7209fb=_0x19f7cd,_0x331d63=_0x465324[_0x7209fb(0x44c)];for(const _0x258e99 of dependencies){if(!Imported[_0x258e99]){if(_0x7209fb(0x1c9)!==_0x7209fb(0x43e)){alert(_0x7209fb(0x330)['format'](_0x331d63,_0x258e99)),SceneManager[_0x7209fb(0x136)]();break;}else _0x2362ab[_0x7209fb(0x498)]((_0x23eb27,_0x33243e)=>{const _0x561944=_0x7209fb,_0x59b9a7=_0x23eb27['priority'],_0x1f76ad=_0x33243e[_0x561944(0x182)];if(_0x59b9a7!==_0x1f76ad)return _0x1f76ad-_0x59b9a7;return _0x23eb27-_0x33243e;});}}const _0x3ab1cd=_0x465324[_0x7209fb(0x3b8)];if(_0x3ab1cd[_0x7209fb(0x138)](/\[Version[ ](.*?)\]/i)){const _0x4f7124=Number(RegExp['$1']);if(_0x4f7124!==VisuMZ[label][_0x7209fb(0x36b)]){if(_0x7209fb(0x1f3)==='YgWYC'){const _0x10ad02=_0x164f2d[_0x7209fb(0x256)]('['+_0x1153d8['$1'][_0x7209fb(0x138)](/\d+/g)+']');for(const _0x4947e2 of _0x10ad02){if(!_0x2097cb[_0x7209fb(0x1f4)](_0x4947e2))return!![];}return![];}else alert(_0x7209fb(0x413)[_0x7209fb(0x29a)](_0x331d63,_0x4f7124)),SceneManager[_0x7209fb(0x136)]();}}if(_0x3ab1cd[_0x7209fb(0x138)](/\[Tier[ ](\d+)\]/i)){if(_0x7209fb(0x2ef)===_0x7209fb(0x2ef)){const _0x456494=Number(RegExp['$1']);_0x456494<tier?(alert(_0x7209fb(0x2e6)[_0x7209fb(0x29a)](_0x331d63,_0x456494,tier)),SceneManager[_0x7209fb(0x136)]()):tier=Math[_0x7209fb(0x1b7)](_0x456494,tier);}else{const _0x577384=_0x2f7e83['parse']('['+_0x2feb6d['$1'][_0x7209fb(0x138)](/\d+/g)+']');for(const _0x105ccc of _0x577384){if(_0x478e49[_0x7209fb(0x151)](_0x105ccc))return![];}return!![];}}VisuMZ['ConvertParams'](VisuMZ[label][_0x7209fb(0x417)],_0x465324[_0x7209fb(0x39a)]);})(pluginData),PluginManager['registerCommand'](pluginData[_0x19f7cd(0x44c)],'SkillActorPaySkillCost',_0x1ade05=>{const _0x172478=_0x19f7cd;VisuMZ[_0x172478(0x221)](_0x1ade05,_0x1ade05);const _0x1999b8=_0x1ade05[_0x172478(0x484)]||[],_0x2158b9=Number(_0x1ade05[_0x172478(0x2d0)]),_0x1553df=$dataSkills[_0x2158b9];if(!_0x1553df)return;for(const _0xc72b70 of _0x1999b8){const _0x2b5047=$gameActors['actor'](_0xc72b70);if(!_0x2b5047)continue;_0x2b5047[_0x172478(0x159)](_0x1553df);}}),PluginManager[_0x19f7cd(0x454)](pluginData[_0x19f7cd(0x44c)],'SkillEnemyPaySkillCost',_0x22cbb8=>{const _0x2a15b7=_0x19f7cd;VisuMZ['ConvertParams'](_0x22cbb8,_0x22cbb8);const _0xfc2a6e=_0x22cbb8['EnemyIndex']||[],_0x2dddea=Number(_0x22cbb8[_0x2a15b7(0x2d0)]),_0x322658=$dataSkills[_0x2dddea];if(!_0x322658)return;for(const _0x14fcc4 of _0xfc2a6e){const _0x3efff3=$gameTroop[_0x2a15b7(0x2b0)]()[_0x14fcc4];if(!_0x3efff3)continue;_0x3efff3['paySkillCost'](_0x322658);}}),PluginManager['registerCommand'](pluginData['name'],'StateTurnsActorChangeBy',_0x10fb30=>{const _0x5dc879=_0x19f7cd;VisuMZ[_0x5dc879(0x221)](_0x10fb30,_0x10fb30);const _0x127c78=_0x10fb30[_0x5dc879(0x484)]||[],_0x1033b3=Number(_0x10fb30[_0x5dc879(0x49a)]),_0x4060c6=Number(_0x10fb30[_0x5dc879(0x225)]),_0x17c500=_0x10fb30[_0x5dc879(0x20a)];for(const _0x14ddc8 of _0x127c78){const _0x130488=$gameActors[_0x5dc879(0x16c)](_0x14ddc8);if(!_0x130488)continue;if(_0x17c500&&!_0x130488['isStateAffected'](_0x1033b3))_0x130488[_0x5dc879(0x3b4)](_0x1033b3),_0x130488[_0x5dc879(0x3ed)](_0x1033b3,_0x4060c6);else{if(_0x5dc879(0x394)===_0x5dc879(0x44f))return this[_0x5dc879(0x3ea)]()[_0x5dc879(0x138)](/RIGHT/i);else _0x130488[_0x5dc879(0x15e)](_0x1033b3,_0x4060c6);}}}),PluginManager[_0x19f7cd(0x454)](pluginData[_0x19f7cd(0x44c)],_0x19f7cd(0x3d0),_0x4f4e46=>{const _0x19e716=_0x19f7cd;VisuMZ[_0x19e716(0x221)](_0x4f4e46,_0x4f4e46);const _0x24cb34=_0x4f4e46['ActorIDs']||[],_0xc03a73=Number(_0x4f4e46['StateID']),_0x15b3dc=Math[_0x19e716(0x1b7)](Number(_0x4f4e46[_0x19e716(0x225)]),0x0),_0x1b383b=_0x4f4e46[_0x19e716(0x20a)];for(const _0x1d1cfa of _0x24cb34){if(_0x19e716(0x2a0)===_0x19e716(0x2a0)){const _0x1ad725=$gameActors[_0x19e716(0x16c)](_0x1d1cfa);if(!_0x1ad725)continue;if(_0x1b383b&&!_0x1ad725[_0x19e716(0x3b6)](_0xc03a73)){if(_0x19e716(0x218)==='FnTyL'){if(this['_tempActor']||this[_0x19e716(0x236)])return;try{_0x2983d7[_0x19e716(0x21a)][_0x19e716(0x417)][_0x19e716(0x32e)][_0x19e716(0x46d)]['call'](this,_0x2fd296);}catch(_0x1ac947){if(_0x4f45ea[_0x19e716(0x405)]())_0x572e24[_0x19e716(0x258)](_0x1ac947);}}else _0x1ad725['addState'](_0xc03a73);}_0x1ad725[_0x19e716(0x3ed)](_0xc03a73,_0x15b3dc);}else return this['shopStatusWindowRectSkillsStatesCore']();}}),PluginManager['registerCommand'](pluginData[_0x19f7cd(0x44c)],_0x19f7cd(0x24b),_0x2e4405=>{const _0x2bce82=_0x19f7cd;if(!$gameParty[_0x2bce82(0x3d7)]())return;VisuMZ['ConvertParams'](_0x2e4405,_0x2e4405);const _0x592bb4=_0x2e4405[_0x2bce82(0x3c0)]||[],_0x32301a=Number(_0x2e4405['StateID']),_0x101fb8=Number(_0x2e4405[_0x2bce82(0x225)]),_0x224026=_0x2e4405[_0x2bce82(0x20a)];for(const _0x3afb3b of _0x592bb4){if('ZPlOU'!=='ZPlOU')_0x5f2162[_0x2bce82(0x21a)][_0x2bce82(0x347)][_0x2bce82(0x277)](this),this[_0x2bce82(0x40c)]=null;else{const _0x36d323=$gameTroop[_0x2bce82(0x2b0)]()[_0x3afb3b];if(!_0x36d323)continue;if(_0x224026&&!_0x36d323[_0x2bce82(0x3b6)](_0x32301a))_0x36d323[_0x2bce82(0x3b4)](_0x32301a),_0x36d323[_0x2bce82(0x3ed)](_0x32301a,_0x101fb8);else{if(_0x2bce82(0x495)===_0x2bce82(0x495))_0x36d323[_0x2bce82(0x15e)](_0x32301a,_0x101fb8);else{_0x49c286['SkillsStatesCore'][_0x2bce82(0x135)][_0x2bce82(0x277)](this);if(this[_0x2bce82(0x15a)])this[_0x2bce82(0x428)]();}}}}}),PluginManager[_0x19f7cd(0x454)](pluginData[_0x19f7cd(0x44c)],_0x19f7cd(0x476),_0x5c421a=>{const _0x40b250=_0x19f7cd;if(!$gameParty[_0x40b250(0x3d7)]())return;VisuMZ['ConvertParams'](_0x5c421a,_0x5c421a);const _0x1816e8=_0x5c421a[_0x40b250(0x3c0)]||[],_0x19def3=Number(_0x5c421a['StateID']),_0x5ef5c9=Math['max'](Number(_0x5c421a[_0x40b250(0x225)]),0x0),_0x58e2fc=_0x5c421a[_0x40b250(0x20a)];for(const _0x4986c0 of _0x1816e8){const _0x347fc7=$gameTroop[_0x40b250(0x2b0)]()[_0x4986c0];if(!_0x347fc7)continue;if(_0x58e2fc&&!_0x347fc7[_0x40b250(0x3b6)](_0x19def3)){if('EMsam'===_0x40b250(0x139)){const _0x50d069=_0x420f26(_0x2b4301['$1']),_0x447dab=_0x4f7dcf[_0x40b250(0x29a)](_0x50d069,'damage',-0x1,_0x40b250(0x300));_0x4eda6a[_0x40b250(0x21a)][_0x40b250(0x1cd)][_0x1540bc['id']]=new _0x4caa1c(_0x40b250(0x430),_0x447dab);}else _0x347fc7[_0x40b250(0x3b4)](_0x19def3);}_0x347fc7[_0x40b250(0x3ed)](_0x19def3,_0x5ef5c9);}}),VisuMZ['SkillsStatesCore']['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x19f7cd(0x296)][_0x19f7cd(0x449)],Scene_Boot[_0x19f7cd(0x296)][_0x19f7cd(0x449)]=function(){const _0x3320b4=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x3320b4(0x2e8)][_0x3320b4(0x277)](this),this[_0x3320b4(0x456)](),VisuMZ[_0x3320b4(0x21a)][_0x3320b4(0x3c9)]();},Scene_Boot[_0x19f7cd(0x296)][_0x19f7cd(0x456)]=function(){const _0x15a0a5=_0x19f7cd;if(VisuMZ[_0x15a0a5(0x3cb)])return;this[_0x15a0a5(0x1b6)](),this[_0x15a0a5(0x2f8)]();},Scene_Boot[_0x19f7cd(0x296)][_0x19f7cd(0x1b6)]=function(){const _0x4ee5db=_0x19f7cd;for(const _0x5afabc of $dataSkills){if(!_0x5afabc)continue;VisuMZ['SkillsStatesCore']['Parse_Notetags_Skill_Cost'](_0x5afabc),VisuMZ[_0x4ee5db(0x21a)][_0x4ee5db(0x24e)](_0x5afabc);}},Scene_Boot['prototype'][_0x19f7cd(0x2f8)]=function(){const _0x72e6d6=_0x19f7cd;for(const _0x206359 of $dataStates){if(_0x72e6d6(0x377)!==_0x72e6d6(0x289)){if(!_0x206359)continue;VisuMZ['SkillsStatesCore']['Parse_Notetags_State_Category'](_0x206359),VisuMZ[_0x72e6d6(0x21a)][_0x72e6d6(0x45b)](_0x206359),VisuMZ[_0x72e6d6(0x21a)][_0x72e6d6(0x327)](_0x206359),VisuMZ['SkillsStatesCore'][_0x72e6d6(0x251)](_0x206359);}else{_0x2a04c0[_0x72e6d6(0x138)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);const _0x35e668=_0x59b65b(_0x3f9734['$1'])[_0x72e6d6(0x3cd)]()['trim']()[_0x72e6d6(0x344)](',');for(const _0x35941a of _0x35e668){_0x495d1b[_0x72e6d6(0x3e7)][_0x72e6d6(0x272)](_0x35941a['trim']());}}}},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x37b)]=VisuMZ[_0x19f7cd(0x37b)],VisuMZ[_0x19f7cd(0x37b)]=function(_0x445c2e){const _0x5160f3=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x5160f3(0x37b)][_0x5160f3(0x277)](this,_0x445c2e),VisuMZ[_0x5160f3(0x21a)][_0x5160f3(0x265)](_0x445c2e),VisuMZ[_0x5160f3(0x21a)][_0x5160f3(0x24e)](_0x445c2e);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x19d)]=VisuMZ[_0x19f7cd(0x19d)],VisuMZ['ParseStateNotetags']=function(_0xed9424){const _0x163aa4=_0x19f7cd;VisuMZ[_0x163aa4(0x21a)][_0x163aa4(0x19d)][_0x163aa4(0x277)](this,_0xed9424),VisuMZ[_0x163aa4(0x21a)][_0x163aa4(0x386)](_0xed9424),VisuMZ[_0x163aa4(0x21a)]['Parse_Notetags_State_PassiveJS'](_0xed9424),VisuMZ[_0x163aa4(0x21a)][_0x163aa4(0x327)](_0xed9424),VisuMZ['SkillsStatesCore']['Parse_Notetags_State_ApplyRemoveLeaveJS'](_0xed9424);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x265)]=function(_0x554d54){const _0x464b6e=_0x19f7cd,_0x88d023=_0x554d54[_0x464b6e(0x1ce)];if(_0x88d023[_0x464b6e(0x138)](/<MP COST:[ ](\d+)>/i)){if(_0x464b6e(0x1d7)===_0x464b6e(0x37d)){let _0x17b755=0x0,_0x547641=0x0;if(_0x197ca8[_0x464b6e(0x138)](/<SET STATE[ ](\d+)[ ]TURNS:[ ](\d+)>/i))_0x17b755=_0x3c0efe(_0x5d8542['$1']),_0x547641=_0x54c41e(_0x3b3a3d['$2']);else _0xa23c68[_0x464b6e(0x138)](/<SET STATE[ ](.*)[ ]TURNS:[ ](\d+)>/i)&&(_0x17b755=_0x1eef1e[_0x464b6e(0x314)](_0x294e66['$1']),_0x547641=_0x33b9c3(_0x54b27e['$2']));_0x29bf96['setStateTurns'](_0x17b755,_0x547641),this[_0x464b6e(0x141)](_0x573c99);}else _0x554d54[_0x464b6e(0x299)]=Number(RegExp['$1']);}if(_0x88d023['match'](/<TP COST:[ ](\d+)>/i)){if(_0x464b6e(0x1fa)!==_0x464b6e(0x43a))_0x554d54['tpCost']=Number(RegExp['$1']);else{const _0x55f315=_0x3670d4[_0x464b6e(0x194)];if(!_0x55f315[_0x464b6e(0x3c5)](this['currentClass']()))return![];}}},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x45d)]={},VisuMZ[_0x19f7cd(0x21a)]['skillVisibleJS']={},VisuMZ[_0x19f7cd(0x21a)]['Parse_Notetags_Skill_JS']=function(_0x50a516){const _0x2daef4=_0x19f7cd,_0x82263a=_0x50a516['note'];if(_0x82263a[_0x2daef4(0x138)](/<JS SKILL ENABLE>\s*([\s\S]*)\s*<\/JS SKILL ENABLE>/i)){const _0x1ce33d=String(RegExp['$1']),_0x330e56='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20enabled\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20enabled;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'['format'](_0x1ce33d);VisuMZ[_0x2daef4(0x21a)]['skillEnableJS'][_0x50a516['id']]=new Function(_0x2daef4(0x1f1),_0x330e56);}if(_0x82263a['match'](/<JS SKILL VISIBLE>\s*([\s\S]*)\s*<\/JS SKILL VISIBLE>/i)){if(_0x2daef4(0x357)===_0x2daef4(0x144))this[_0x2daef4(0x40c)]=_0xfd884c[0x0];else{const _0xd65470=String(RegExp['$1']),_0x5d733e=_0x2daef4(0x39e)[_0x2daef4(0x29a)](_0xd65470);VisuMZ[_0x2daef4(0x21a)][_0x2daef4(0x28c)][_0x50a516['id']]=new Function(_0x2daef4(0x1f1),_0x5d733e);}}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x386)]=function(_0xe4c4d4){const _0x1e3e48=_0x19f7cd;_0xe4c4d4[_0x1e3e48(0x3e7)]=[_0x1e3e48(0x39c),'ANY'];const _0xbe052a=_0xe4c4d4['note'],_0x2aba57=_0xbe052a[_0x1e3e48(0x138)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);if(_0x2aba57)for(const _0xaecf05 of _0x2aba57){_0xaecf05[_0x1e3e48(0x138)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);const _0x1d56f2=String(RegExp['$1'])[_0x1e3e48(0x3cd)]()[_0x1e3e48(0x467)]()[_0x1e3e48(0x344)](',');for(const _0x15bfd6 of _0x1d56f2){if(_0x1e3e48(0x415)!==_0x1e3e48(0x200))_0xe4c4d4[_0x1e3e48(0x3e7)]['push'](_0x15bfd6['trim']());else{if(this['_tempActor']||this[_0x1e3e48(0x236)])return;const _0x499733=_0x60e50e[_0x1e3e48(0x21a)]['stateExpireJS'];if(_0x499733[_0x1f546b])_0x499733[_0x2496ff][_0x1e3e48(0x277)](this,_0x13552f);}}}if(_0xbe052a[_0x1e3e48(0x138)](/<(?:CATEGORY|CATEGORIES)>\s*([\s\S]*)\s*<\/(?:CATEGORY|CATEGORIES)>/i)){if(_0x1e3e48(0x239)===_0x1e3e48(0x132))return _0x2a3fd6[_0x1e3e48(0x21a)][_0x1e3e48(0x417)][_0x1e3e48(0x47f)][_0x1e3e48(0x2db)]||0x0;else{const _0x49ae42=RegExp['$1']['split'](/[\r\n]+/);for(const _0x500871 of _0x49ae42){if('sBNUE'==='sBNUE')_0xe4c4d4[_0x1e3e48(0x3e7)][_0x1e3e48(0x272)](_0x500871['toUpperCase']()['trim']());else return this['totalStateCategory'](_0x5e9b78)>0x0;}}}if(_0xbe052a[_0x1e3e48(0x138)](/<POSITIVE STATE>/i)){if(_0x1e3e48(0x2dc)!=='sUzQX')_0xe4c4d4[_0x1e3e48(0x3e7)][_0x1e3e48(0x272)](_0x1e3e48(0x40a));else for(const _0x86f23a of _0x1ff5f7[_0x1e3e48(0x2eb)]()){if(_0x86f23a)_0x86f23a[_0x1e3e48(0x2bb)]();}}_0xbe052a[_0x1e3e48(0x138)](/<NEGATIVE STATE>/i)&&_0xe4c4d4[_0x1e3e48(0x3e7)][_0x1e3e48(0x272)]('NEGATIVE');},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x318)]={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x45b)]=function(_0x3be123){const _0x5692a2=_0x19f7cd,_0x29b5c1=_0x3be123[_0x5692a2(0x1ce)];if(_0x29b5c1[_0x5692a2(0x138)](/<JS PASSIVE CONDITION>\s*([\s\S]*)\s*<\/JS PASSIVE CONDITION>/i)){if('ZQXKI'!==_0x5692a2(0x3be)){const _0x4f2e46=_0x372489[_0x5692a2(0x1ce)],_0x348fd1=_0x3d0ebf[_0x5692a2(0x21a)][_0x5692a2(0x45d)];return _0x348fd1[_0x38fc2a['id']]?_0x348fd1[_0x238c3d['id']][_0x5692a2(0x277)](this,_0x45623b):!![];}else{const _0x1d636c=String(RegExp['$1']),_0x56e125='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20condition\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20condition;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'[_0x5692a2(0x29a)](_0x1d636c);VisuMZ[_0x5692a2(0x21a)][_0x5692a2(0x318)][_0x3be123['id']]=new Function(_0x5692a2(0x3e2),_0x56e125);}}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1cd)]={},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x433)]={},VisuMZ[_0x19f7cd(0x21a)]['stateMpSlipDamageJS']={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1e8)]={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1bd)]={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x271)]={},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x327)]=function(_0x38b9d0){const _0x5ae1cd=_0x19f7cd,_0x59a2c9=_0x38b9d0[_0x5ae1cd(0x1ce)],_0x3b3376=_0x5ae1cd(0x468);if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS HP SLIP DAMAGE>\s*([\s\S]*)\s*<\/JS HP SLIP DAMAGE>/i)){const _0x2745ea=String(RegExp['$1']),_0x53a356=_0x3b3376[_0x5ae1cd(0x29a)](_0x2745ea,_0x5ae1cd(0x13f),-0x1,'slipHp');VisuMZ[_0x5ae1cd(0x21a)][_0x5ae1cd(0x1cd)][_0x38b9d0['id']]=new Function('stateId',_0x53a356);}else{if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS HP SLIP HEAL>\s*([\s\S]*)\s*<\/JS HP SLIP HEAL>/i)){const _0x564780=String(RegExp['$1']),_0x578070=_0x3b3376[_0x5ae1cd(0x29a)](_0x564780,_0x5ae1cd(0x1a8),0x1,_0x5ae1cd(0x300));VisuMZ['SkillsStatesCore'][_0x5ae1cd(0x433)][_0x38b9d0['id']]=new Function(_0x5ae1cd(0x430),_0x578070);}}if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS MP SLIP DAMAGE>\s*([\s\S]*)\s*<\/JS MP SLIP DAMAGE>/i)){if(_0x5ae1cd(0x437)===_0x5ae1cd(0x228))_0x7f3a02=this[_0x5ae1cd(0x434)]();else{const _0x2850eb=String(RegExp['$1']),_0xb7c232=_0x3b3376['format'](_0x2850eb,_0x5ae1cd(0x13f),-0x1,'slipMp');VisuMZ['SkillsStatesCore'][_0x5ae1cd(0x35e)][_0x38b9d0['id']]=new Function('stateId',_0xb7c232);}}else{if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS MP SLIP HEAL>\s*([\s\S]*)\s*<\/JS MP SLIP HEAL>/i)){const _0x444a7b=String(RegExp['$1']),_0x4eb1c0=_0x3b3376[_0x5ae1cd(0x29a)](_0x444a7b,_0x5ae1cd(0x1a8),0x1,'slipMp');VisuMZ['SkillsStatesCore'][_0x5ae1cd(0x1e8)][_0x38b9d0['id']]=new Function('stateId',_0x4eb1c0);}}if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS TP SLIP DAMAGE>\s*([\s\S]*)\s*<\/JS TP SLIP DAMAGE>/i)){const _0xc4d36d=String(RegExp['$1']),_0x1dcabe=_0x3b3376[_0x5ae1cd(0x29a)](_0xc4d36d,_0x5ae1cd(0x13f),-0x1,'slipTp');VisuMZ['SkillsStatesCore'][_0x5ae1cd(0x1bd)][_0x38b9d0['id']]=new Function(_0x5ae1cd(0x430),_0x1dcabe);}else{if(_0x59a2c9[_0x5ae1cd(0x138)](/<JS TP SLIP HEAL>\s*([\s\S]*)\s*<\/JS TP SLIP HEAL>/i)){const _0x311e17=String(RegExp['$1']),_0x24a854=_0x3b3376[_0x5ae1cd(0x29a)](_0x311e17,_0x5ae1cd(0x1a8),0x1,_0x5ae1cd(0x189));VisuMZ[_0x5ae1cd(0x21a)][_0x5ae1cd(0x271)][_0x38b9d0['id']]=new Function(_0x5ae1cd(0x430),_0x24a854);}}},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x470)]={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x33f)]={},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x19f)]={},VisuMZ[_0x19f7cd(0x21a)]['Parse_Notetags_State_ApplyRemoveLeaveJS']=function(_0x41ef7a){const _0x41c721=_0x19f7cd,_0x57f180=_0x41ef7a['note'],_0x4816dd=_0x41c721(0x268);if(_0x57f180['match'](/<JS ON ADD STATE>\s*([\s\S]*)\s*<\/JS ON ADD STATE>/i)){if(_0x41c721(0x1c4)!==_0x41c721(0x439)){const _0x4cfae7=String(RegExp['$1']),_0x9375dd=_0x4816dd[_0x41c721(0x29a)](_0x4cfae7);VisuMZ[_0x41c721(0x21a)][_0x41c721(0x470)][_0x41ef7a['id']]=new Function(_0x41c721(0x430),_0x9375dd);}else{const _0x29c641=_0x3c4016[_0x41c721(0x1ce)];if(_0x29c641[_0x41c721(0x138)](/<JS SKILL ENABLE>\s*([\s\S]*)\s*<\/JS SKILL ENABLE>/i)){const _0x41bd19=_0x4d1d10(_0x296005['$1']),_0x36ecf0='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20enabled\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20enabled;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'[_0x41c721(0x29a)](_0x41bd19);_0x509a78[_0x41c721(0x21a)][_0x41c721(0x45d)][_0x440dff['id']]=new _0xa57c6(_0x41c721(0x1f1),_0x36ecf0);}if(_0x29c641[_0x41c721(0x138)](/<JS SKILL VISIBLE>\s*([\s\S]*)\s*<\/JS SKILL VISIBLE>/i)){const _0x417e7a=_0x9a6487(_0x1c390e['$1']),_0x28cc82=_0x41c721(0x39e)[_0x41c721(0x29a)](_0x417e7a);_0x17049e['SkillsStatesCore'][_0x41c721(0x28c)][_0x1432c8['id']]=new _0x29cf93('skill',_0x28cc82);}}}if(_0x57f180[_0x41c721(0x138)](/<JS ON ERASE STATE>\s*([\s\S]*)\s*<\/JS ON ERASE STATE>/i)){if(_0x41c721(0x41d)!==_0x41c721(0x3b2)){const _0x477420=String(RegExp['$1']),_0x3bb629=_0x4816dd[_0x41c721(0x29a)](_0x477420);VisuMZ[_0x41c721(0x21a)][_0x41c721(0x33f)][_0x41ef7a['id']]=new Function(_0x41c721(0x430),_0x3bb629);}else{const _0x1cbba8=_0x41da0d(_0x3081d5['$1']);if(_0x366df3['isStateCategoryAffected'](_0x1cbba8))return!![];}}if(_0x57f180['match'](/<JS ON EXPIRE STATE>\s*([\s\S]*)\s*<\/JS ON EXPIRE STATE>/i)){if(_0x41c721(0x205)===_0x41c721(0x205)){const _0x228cc6=String(RegExp['$1']),_0x5b22a3=_0x4816dd['format'](_0x228cc6);VisuMZ['SkillsStatesCore'][_0x41c721(0x19f)][_0x41ef7a['id']]=new Function(_0x41c721(0x430),_0x5b22a3);}else return this['_buffTurns'][_0x217bd2]||0x0;}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3c9)]=function(){const _0x1bb99f=_0x19f7cd;if(!VisuMZ[_0x1bb99f(0x21a)][_0x1bb99f(0x417)][_0x1bb99f(0x32e)][_0x1bb99f(0x2c5)])return;for(const _0x500f26 of $dataStates){if('xPGet'!=='ejhSQ'){if(!_0x500f26)continue;_0x500f26[_0x1bb99f(0x490)]===0x4&&_0x500f26[_0x1bb99f(0x424)]===0x1&&(_0x500f26['autoRemovalTiming']=0x2);}else return _0x198e97[_0x1bb99f(0x21a)][_0x1bb99f(0x417)][_0x1bb99f(0x32e)][_0x1bb99f(0x363)]??0x14;}},DataManager[_0x19f7cd(0x3a5)]=function(_0x1f7398){const _0x49ba9a=_0x19f7cd;_0x1f7398=_0x1f7398[_0x49ba9a(0x3cd)]()[_0x49ba9a(0x467)](),this[_0x49ba9a(0x13a)]=this[_0x49ba9a(0x13a)]||{};if(this[_0x49ba9a(0x13a)][_0x1f7398])return this['_classIDs'][_0x1f7398];for(const _0x1f0287 of $dataClasses){if(!_0x1f0287)continue;let _0x30c1c4=_0x1f0287['name'];_0x30c1c4=_0x30c1c4[_0x49ba9a(0x1d8)](/\x1I\[(\d+)\]/gi,''),_0x30c1c4=_0x30c1c4[_0x49ba9a(0x1d8)](/\\I\[(\d+)\]/gi,''),this[_0x49ba9a(0x13a)][_0x30c1c4[_0x49ba9a(0x3cd)]()[_0x49ba9a(0x467)]()]=_0x1f0287['id'];}return this[_0x49ba9a(0x13a)][_0x1f7398]||0x0;},DataManager[_0x19f7cd(0x1cb)]=function(_0x4c2fbe){const _0xcdbf1b=_0x19f7cd;this[_0xcdbf1b(0x3ec)]=this[_0xcdbf1b(0x3ec)]||{};if(this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']])return this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']];this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']]=[_0x4c2fbe['stypeId']];if(_0x4c2fbe[_0xcdbf1b(0x1ce)][_0xcdbf1b(0x138)](/<SKILL[ ](?:TYPE|TYPES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xcdbf1b(0x140)!==_0xcdbf1b(0x1ba)){const _0x4714de=JSON[_0xcdbf1b(0x256)]('['+RegExp['$1']['match'](/\d+/g)+']');this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']]=this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']][_0xcdbf1b(0x2ea)](_0x4714de);}else this[_0xcdbf1b(0x23d)](_0x54c7f5['shift']());}else{if(_0x4c2fbe['note'][_0xcdbf1b(0x138)](/<SKILL[ ](?:TYPE|TYPES):[ ](.*)>/i)){const _0x1bf6dd=RegExp['$1'][_0xcdbf1b(0x344)](',');for(const _0x25193c of _0x1bf6dd){if('nzamu'===_0xcdbf1b(0x2cc)){if(_0x5ef6c2[_0xcdbf1b(0x3cb)])return;this[_0xcdbf1b(0x1b6)](),this[_0xcdbf1b(0x2f8)]();}else{const _0x3ad478=DataManager[_0xcdbf1b(0x463)](_0x25193c);if(_0x3ad478)this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']]['push'](_0x3ad478);}}}}return this[_0xcdbf1b(0x3ec)][_0x4c2fbe['id']];},DataManager[_0x19f7cd(0x463)]=function(_0x2cdf03){const _0x4d5f1b=_0x19f7cd;_0x2cdf03=_0x2cdf03[_0x4d5f1b(0x3cd)]()[_0x4d5f1b(0x467)](),this[_0x4d5f1b(0x3ec)]=this[_0x4d5f1b(0x3ec)]||{};if(this['_stypeIDs'][_0x2cdf03])return this[_0x4d5f1b(0x3ec)][_0x2cdf03];for(let _0x3028fd=0x1;_0x3028fd<0x64;_0x3028fd++){if(_0x4d5f1b(0x29d)===_0x4d5f1b(0x211))this[_0x4d5f1b(0x426)]='',this['_stateData']={},this[_0x4d5f1b(0x431)]={},this[_0x4d5f1b(0x46e)]={};else{if(!$dataSystem['skillTypes'][_0x3028fd])continue;let _0x2994f8=$dataSystem[_0x4d5f1b(0x2a8)][_0x3028fd][_0x4d5f1b(0x3cd)]()['trim']();_0x2994f8=_0x2994f8['replace'](/\x1I\[(\d+)\]/gi,''),_0x2994f8=_0x2994f8[_0x4d5f1b(0x1d8)](/\\I\[(\d+)\]/gi,''),this[_0x4d5f1b(0x3ec)][_0x2994f8]=_0x3028fd;}}return this['_stypeIDs'][_0x2cdf03]||0x0;},DataManager[_0x19f7cd(0x43f)]=function(_0x2b2410){const _0x204858=_0x19f7cd;_0x2b2410=_0x2b2410[_0x204858(0x3cd)]()[_0x204858(0x467)](),this[_0x204858(0x24f)]=this[_0x204858(0x24f)]||{};if(this['_skillIDs'][_0x2b2410])return this[_0x204858(0x24f)][_0x2b2410];for(const _0x70debb of $dataSkills){if(!_0x70debb)continue;this[_0x204858(0x24f)][_0x70debb['name'][_0x204858(0x3cd)]()['trim']()]=_0x70debb['id'];}return this['_skillIDs'][_0x2b2410]||0x0;},DataManager['getStateIdWithName']=function(_0x38fae8){const _0x415be5=_0x19f7cd;_0x38fae8=_0x38fae8[_0x415be5(0x3cd)]()[_0x415be5(0x467)](),this['_stateIDs']=this[_0x415be5(0x28b)]||{};if(this['_stateIDs'][_0x38fae8])return this['_stateIDs'][_0x38fae8];for(const _0x1023c5 of $dataStates){if(!_0x1023c5)continue;this[_0x415be5(0x28b)][_0x1023c5[_0x415be5(0x44c)][_0x415be5(0x3cd)]()[_0x415be5(0x467)]()]=_0x1023c5['id'];}return this['_stateIDs'][_0x38fae8]||0x0;},DataManager[_0x19f7cd(0x1eb)]=function(_0x205ebf){const _0xc42a7d=_0x19f7cd;this[_0xc42a7d(0x302)]=this[_0xc42a7d(0x302)]||{};if(this[_0xc42a7d(0x302)][_0x205ebf])return this[_0xc42a7d(0x302)][_0x205ebf];return $dataStates[_0x205ebf][_0xc42a7d(0x1ce)][_0xc42a7d(0x138)](/<MAX TURNS:[ ](\d+)>/i)?this[_0xc42a7d(0x302)][_0x205ebf]=Number(RegExp['$1']):this[_0xc42a7d(0x302)][_0x205ebf]=VisuMZ[_0xc42a7d(0x21a)][_0xc42a7d(0x417)]['States'][_0xc42a7d(0x451)],this['_stateMaxTurns'][_0x205ebf];},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x40d)]=function(_0x440abf,_0x38fb66){const _0x346678=_0x19f7cd;if(VisuMZ[_0x346678(0x40d)])return VisuMZ[_0x346678(0x40d)](_0x440abf,_0x38fb66);let _0x30e0ae='';if($dataActors['includes'](_0x440abf))_0x30e0ae=_0x346678(0x186)[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataClasses['includes'](_0x440abf))_0x30e0ae=_0x346678(0x360)['format'](_0x440abf['id'],_0x38fb66);if($dataSkills['includes'](_0x440abf))_0x30e0ae=_0x346678(0x19b)[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataItems[_0x346678(0x3c5)](_0x440abf))_0x30e0ae=_0x346678(0x1e5)[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataWeapons[_0x346678(0x3c5)](_0x440abf))_0x30e0ae='Weapon-%1-%2'[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataArmors['includes'](_0x440abf))_0x30e0ae='Armor-%1-%2'[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataEnemies['includes'](_0x440abf))_0x30e0ae='Enemy-%1-%2'[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);if($dataStates[_0x346678(0x3c5)](_0x440abf))_0x30e0ae='State-%1-%2'[_0x346678(0x29a)](_0x440abf['id'],_0x38fb66);return _0x30e0ae;},ColorManager[_0x19f7cd(0x174)]=function(_0x46fc1a,_0x282623){const _0x4248ea=_0x19f7cd;_0x282623=String(_0x282623),this[_0x4248ea(0x17c)]=this[_0x4248ea(0x17c)]||{};if(_0x282623[_0x4248ea(0x138)](/#(.*)/i))this['_colorCache'][_0x46fc1a]='#%1'['format'](String(RegExp['$1']));else{if('Vpdpe'!==_0x4248ea(0x3e3)){if(_0x433d20[_0x4248ea(0x151)](_0x3b714c))return!![];}else this[_0x4248ea(0x17c)][_0x46fc1a]=this[_0x4248ea(0x414)](Number(_0x282623));}return this[_0x4248ea(0x17c)][_0x46fc1a];},ColorManager[_0x19f7cd(0x1cc)]=function(_0x46ac13){const _0x418969=_0x19f7cd;_0x46ac13=String(_0x46ac13);if(_0x46ac13[_0x418969(0x138)](/#(.*)/i))return _0x418969(0x308)['format'](String(RegExp['$1']));else{if(_0x418969(0x1ef)!==_0x418969(0x1ef)){const _0x47ac3e=_0x5b7c6c['SkillsStatesCore'][_0x418969(0x328)]['call'](this),_0x36f927=_0x268936[_0x418969(0x21a)][_0x418969(0x417)]['Skills'];let _0x302951=_0x36f927[_0x418969(0x288)];return _0x5702d3[_0x418969(0x3d7)]()&&(_0x302951=_0x302951[_0x418969(0x2ea)](_0x36f927[_0x418969(0x150)])),_0x47ac3e[_0x418969(0x3ab)](_0x1dc658=>!_0x302951[_0x418969(0x3c5)](_0x1dc658));}else return this[_0x418969(0x414)](Number(_0x46ac13));}},ColorManager[_0x19f7cd(0x339)]=function(_0x5cae26){const _0x1c91be=_0x19f7cd;if(typeof _0x5cae26===_0x1c91be(0x46c))_0x5cae26=$dataStates[_0x5cae26];const _0x338890=_0x1c91be(0x1a2)[_0x1c91be(0x29a)](_0x5cae26['id']);this[_0x1c91be(0x17c)]=this['_colorCache']||{};if(this[_0x1c91be(0x17c)][_0x338890])return this['_colorCache'][_0x338890];const _0x4fc2b6=this[_0x1c91be(0x3f4)](_0x5cae26);return this[_0x1c91be(0x174)](_0x338890,_0x4fc2b6);},ColorManager['retrieveStateColor']=function(_0x25adf9){const _0x13dd25=_0x19f7cd,_0x6291ab=_0x25adf9[_0x13dd25(0x1ce)];if(_0x6291ab[_0x13dd25(0x138)](/<TURN COLOR:[ ](.*)>/i)){if('FZvqK'===_0x13dd25(0x14a)){const _0x5ddeb2=_0x2446c0[_0x13dd25(0x21a)]['statePassiveConditionJS'];if(_0x5ddeb2[_0x2a1a9f['id']]&&!_0x5ddeb2[_0x7036e4['id']][_0x13dd25(0x277)](this,_0x2dc007))return![];return!![];}else return String(RegExp['$1']);}else{if(_0x6291ab[_0x13dd25(0x138)](/<POSITIVE STATE>/i))return VisuMZ['SkillsStatesCore'][_0x13dd25(0x417)][_0x13dd25(0x32e)][_0x13dd25(0x474)];else{if(_0x6291ab[_0x13dd25(0x138)](/<NEGATIVE STATE>/i)){if(_0x13dd25(0x16d)===_0x13dd25(0x16d))return VisuMZ['SkillsStatesCore'][_0x13dd25(0x417)][_0x13dd25(0x32e)][_0x13dd25(0x1c1)];else{if(_0x53f62b[_0x13dd25(0x421)][_0x13dd25(0x3cd)]()==='MP'){let _0x39b1bc=_0x291648[_0x13dd25(0x24c)][_0x13dd25(0x277)](this,_0x26a4f5);return _0x39b1bc=this[_0x13dd25(0x469)](_0x3381bc,_0x39b1bc,_0x3a1459),_0x39b1bc;}}}else return VisuMZ[_0x13dd25(0x21a)][_0x13dd25(0x417)]['States'][_0x13dd25(0x411)];}}},ColorManager[_0x19f7cd(0x13e)]=function(){const _0x517ef1=_0x19f7cd,_0x22cec9=_0x517ef1(0x3e4);this['_colorCache']=this[_0x517ef1(0x17c)]||{};if(this[_0x517ef1(0x17c)][_0x22cec9])return this[_0x517ef1(0x17c)][_0x22cec9];const _0x419faf=VisuMZ[_0x517ef1(0x21a)][_0x517ef1(0x417)]['Buffs'][_0x517ef1(0x2e3)];return this[_0x517ef1(0x174)](_0x22cec9,_0x419faf);},ColorManager[_0x19f7cd(0x2a3)]=function(){const _0x1d1cdd=_0x19f7cd,_0x3cba3f=_0x1d1cdd(0x390);this[_0x1d1cdd(0x17c)]=this[_0x1d1cdd(0x17c)]||{};if(this[_0x1d1cdd(0x17c)][_0x3cba3f])return this[_0x1d1cdd(0x17c)][_0x3cba3f];const _0x335eb5=VisuMZ[_0x1d1cdd(0x21a)][_0x1d1cdd(0x417)][_0x1d1cdd(0x180)][_0x1d1cdd(0x387)];return this[_0x1d1cdd(0x174)](_0x3cba3f,_0x335eb5);},SceneManager[_0x19f7cd(0x3f7)]=function(){const _0xb56b3e=_0x19f7cd;return this[_0xb56b3e(0x42a)]&&this[_0xb56b3e(0x42a)][_0xb56b3e(0x1cf)]===Scene_Battle;},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x371)]=BattleManager['endAction'],BattleManager[_0x19f7cd(0x18a)]=function(){const _0x159185=_0x19f7cd;this[_0x159185(0x3c3)](),VisuMZ[_0x159185(0x21a)][_0x159185(0x371)]['call'](this);},BattleManager[_0x19f7cd(0x3c3)]=function(){const _0x4536ef=_0x19f7cd,_0x445b07=VisuMZ['SkillsStatesCore'][_0x4536ef(0x417)][_0x4536ef(0x32e)];if(!_0x445b07)return;if(_0x445b07[_0x4536ef(0x2c5)]===![])return;if(!this['_subject'])return;this['_subject']['updateStatesActionEnd']();},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x3c3)]=function(){const _0x56f34c=_0x19f7cd;if(BattleManager['_phase']!==_0x56f34c(0x255))return;if(this[_0x56f34c(0x38c)]===Graphics[_0x56f34c(0x338)])return;this['_lastStatesActionEndFrameCount']=Graphics[_0x56f34c(0x338)];for(const _0x39e6f4 of this[_0x56f34c(0x21c)]){const _0x1338b7=$dataStates[_0x39e6f4];if(!_0x1338b7)continue;if(_0x1338b7[_0x56f34c(0x424)]!==0x1)continue;this[_0x56f34c(0x3e0)][_0x39e6f4]>0x0&&this[_0x56f34c(0x3e0)][_0x39e6f4]--;}this[_0x56f34c(0x388)](0x1);},Game_BattlerBase['prototype']['updateStateTurns']=function(){const _0x5af068=_0x19f7cd,_0x54497b=VisuMZ[_0x5af068(0x21a)]['Settings'][_0x5af068(0x32e)];for(const _0xeb321c of this[_0x5af068(0x21c)]){if('nyQRq'===_0x5af068(0x2d6)){const _0x15d390=_0x5ca9a4[_0x5af068(0x21a)]['Settings'][_0x5af068(0x47f)];return _0x15d390[_0x5af068(0x264)]===_0x5af068(0x46c)?_0x484fd0['numberFontFace']():_0x1d3903[_0x5af068(0x261)]();}else{const _0x1c6c85=$dataStates[_0xeb321c];if(_0x54497b&&_0x54497b['ActionEndUpdate']!==![]){if(_0x1c6c85&&_0x1c6c85[_0x5af068(0x424)]===0x1)continue;}this[_0x5af068(0x3e0)][_0xeb321c]>0x0&&this['_stateTurns'][_0xeb321c]--;}}},VisuMZ['SkillsStatesCore']['Game_Switches_onChange']=Game_Switches['prototype'][_0x19f7cd(0x3ad)],Game_Switches[_0x19f7cd(0x296)]['onChange']=function(){const _0x3deab2=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x3deab2(0x2ca)]['call'](this);const _0x423aab=VisuMZ['SkillsStatesCore']['Settings']['PassiveStates'][_0x3deab2(0x31d)]??!![];if(!_0x423aab)return;if(SceneManager[_0x3deab2(0x3f7)]())for(const _0x51080e of BattleManager[_0x3deab2(0x2eb)]()){if(_0x3deab2(0x1b5)!=='CzamC'){if(_0x51080e)_0x51080e[_0x3deab2(0x2bb)]();}else return _0x5e1672[_0x3deab2(0x21a)][_0x3deab2(0x417)][_0x3deab2(0x3cc)][_0x3deab2(0x358)][_0x3deab2(0x277)](this,_0x36d3ca);}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x380)]=Game_Variables['prototype'][_0x19f7cd(0x3ad)],Game_Variables[_0x19f7cd(0x296)]['onChange']=function(){const _0x276030=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x276030(0x380)]['call'](this);const _0x59e9de=VisuMZ[_0x276030(0x21a)]['Settings'][_0x276030(0x3cc)]['RefreshCacheVar']??!![];if(!_0x59e9de)return;if(SceneManager[_0x276030(0x3f7)]())for(const _0x34ce0f of BattleManager[_0x276030(0x2eb)]()){if(_0x276030(0x1d6)!==_0x276030(0x1d6)){const _0x123d3c=_0x9f596a[_0x276030(0x21a)][_0x276030(0x417)][_0x276030(0x180)][_0x276030(0x451)];this[_0x276030(0x179)][_0x3d3df2]=_0x265bf1['clamp'](0x0,_0x123d3c);}else{if(_0x34ce0f)_0x34ce0f[_0x276030(0x2bb)]();}}},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x43b)]=Game_Action[_0x19f7cd(0x296)]['applyItemUserEffect'],Game_Action[_0x19f7cd(0x296)]['applyItemUserEffect']=function(_0x886ee){const _0x527c06=_0x19f7cd;VisuMZ['SkillsStatesCore']['Game_Action_applyItemUserEffect'][_0x527c06(0x277)](this,_0x886ee),this['applySkillsStatesCoreEffects'](_0x886ee);},Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x389)]=function(_0x3e1ed5){const _0x105a63=_0x19f7cd;this[_0x105a63(0x1e4)](_0x3e1ed5),this[_0x105a63(0x16a)](_0x3e1ed5),this[_0x105a63(0x18e)](_0x3e1ed5),this[_0x105a63(0x13c)](_0x3e1ed5);},VisuMZ['SkillsStatesCore']['Game_Action_testApply']=Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x17d)],Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x17d)]=function(_0x2a8066){const _0x3e04c9=_0x19f7cd;if(this[_0x3e04c9(0x403)](_0x2a8066))return!![];return VisuMZ[_0x3e04c9(0x21a)][_0x3e04c9(0x29c)]['call'](this,_0x2a8066);},Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x403)]=function(_0x392ae9){const _0x5a83c9=_0x19f7cd;if(!this['item']())return;const _0x4338d7=this[_0x5a83c9(0x1ca)]()[_0x5a83c9(0x1ce)];if(_0x4338d7[_0x5a83c9(0x138)](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ](.*)>/i)){const _0x2628aa=String(RegExp['$1']);if(_0x392ae9[_0x5a83c9(0x287)](_0x2628aa))return!![];}if(_0x4338d7[_0x5a83c9(0x138)](/<SET STATE[ ](\d+)[ ]TURNS:[ ](.*)>/i)){const _0x22f3a6=Number(RegExp['$1']);if(_0x392ae9['isStateAffected'](_0x22f3a6))return!![];}else{if(_0x4338d7['match'](/<SET STATE[ ](.*)[ ]TURNS:[ ](.*)>/i)){if(_0x5a83c9(0x177)!==_0x5a83c9(0x177))return _0x2a9294['SkillsStatesCore'][_0x5a83c9(0x2d9)]['call'](this);else{const _0x2ca5e2=DataManager[_0x5a83c9(0x314)](RegExp['$1']);if(_0x392ae9[_0x5a83c9(0x3b6)](_0x2ca5e2))return!![];}}}return![];},Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x1e4)]=function(_0x26db61){const _0x38b322=_0x19f7cd;if(_0x26db61[_0x38b322(0x25d)]()[_0x38b322(0x313)]<=0x0)return;const _0x56e38f=this[_0x38b322(0x1ca)]()[_0x38b322(0x1ce)];{if(_0x38b322(0x362)!==_0x38b322(0x362)){const _0x21d8c1=_0x52cfae[_0x38b322(0x21a)][_0x38b322(0x417)]['Gauge'];if(this['valueOutlineWidth']()<=0x0)return _0x38b322(0x41e);else return _0x21d8c1['ValueOutlineSolid']?_0x38b322(0x369):_0x177d3d['outlineColor']();}else{const _0x2f67a3=_0x56e38f[_0x38b322(0x138)](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ]ALL>/gi);if(_0x2f67a3){if(_0x38b322(0x322)!==_0x38b322(0x322)){if(!_0x14a382['value'](_0x4f5ef9))return![];}else for(const _0x346c86 of _0x2f67a3){_0x346c86[_0x38b322(0x138)](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ]ALL>/i);const _0x17dfa4=String(RegExp['$1']);_0x26db61[_0x38b322(0x2a5)](_0x17dfa4);}}}}{const _0x26563f=_0x56e38f['match'](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ](\d+)>/gi);if(_0x26563f){if(_0x38b322(0x40b)===_0x38b322(0x40b))for(const _0x447b0a of _0x26563f){if(_0x38b322(0x260)===_0x38b322(0x260)){_0x447b0a[_0x38b322(0x138)](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ](\d+)>/i);const _0x170c88=String(RegExp['$1']),_0x4ff308=Number(RegExp['$2']);_0x26db61[_0x38b322(0x3eb)](_0x170c88,_0x4ff308);}else return _0x81b68b[_0x38b322(0x21a)][_0x38b322(0x417)][_0x38b322(0x32e)][_0x38b322(0x1c1)];}else this[_0x38b322(0x199)](_0x1ae410);}}},Game_Action[_0x19f7cd(0x296)][_0x19f7cd(0x16a)]=function(_0x2228ea){const _0x303c0d=_0x19f7cd,_0x25fcc4=this[_0x303c0d(0x1ca)]()['note'],_0x575d09=_0x25fcc4['match'](/<SET STATE[ ](.*)[ ]TURNS:[ ](\d+)>/gi);if(_0x575d09)for(const _0x458e53 of _0x575d09){let _0x47ceb1=0x0,_0x22d1aa=0x0;if(_0x458e53[_0x303c0d(0x138)](/<SET STATE[ ](\d+)[ ]TURNS:[ ](\d+)>/i))_0x47ceb1=Number(RegExp['$1']),_0x22d1aa=Number(RegExp['$2']);else _0x458e53[_0x303c0d(0x138)](/<SET STATE[ ](.*)[ ]TURNS:[ ](\d+)>/i)&&(_0x47ceb1=DataManager[_0x303c0d(0x314)](RegExp['$1']),_0x22d1aa=Number(RegExp['$2']));_0x2228ea[_0x303c0d(0x3ed)](_0x47ceb1,_0x22d1aa),this['makeSuccess'](_0x2228ea);}const _0x1632d0=_0x25fcc4['match'](/<STATE[ ](.*)[ ]TURNS:[ ]([\+\-]\d+)>/gi);if(_0x1632d0){if(_0x303c0d(0x146)===_0x303c0d(0x146))for(const _0x3745a1 of _0x1632d0){if(_0x303c0d(0x382)!==_0x303c0d(0x382)){if(_0x2c5a83[_0x303c0d(0x353)](_0x247084))return!![];}else{let _0x1cb029=0x0,_0x321df4=0x0;if(_0x3745a1[_0x303c0d(0x138)](/<STATE[ ](\d+)[ ]TURNS:[ ]([\+\-]\d+)>/i))'BtQTF'!==_0x303c0d(0x2f1)?(_0x1cb029=Number(RegExp['$1']),_0x321df4=Number(RegExp['$2'])):(_0x37c3db[_0x303c0d(0x21a)]['ParseSkillNotetags'][_0x303c0d(0x277)](this,_0x579c6c),_0x4e1176[_0x303c0d(0x21a)]['Parse_Notetags_Skill_Cost'](_0x4cc658),_0x3225de[_0x303c0d(0x21a)][_0x303c0d(0x24e)](_0x26a8c9));else{if(_0x3745a1[_0x303c0d(0x138)](/<STATE[ ](.*)[ ]TURNS:[ ]([\+\-]\d+)>/i)){if('Acqbk'===_0x303c0d(0x486)){if(this['_tempActor']||this[_0x303c0d(0x236)])return;try{_0x56bff5[_0x303c0d(0x21a)][_0x303c0d(0x417)][_0x303c0d(0x32e)]['onAddStateJS'][_0x303c0d(0x277)](this,_0x35a16e);}catch(_0x4f992f){if(_0x5ba126[_0x303c0d(0x405)]())_0xd80296[_0x303c0d(0x258)](_0x4f992f);}}else _0x1cb029=DataManager[_0x303c0d(0x314)](RegExp['$1']),_0x321df4=Number(RegExp['$2']);}}_0x2228ea['addStateTurns'](_0x1cb029,_0x321df4),this[_0x303c0d(0x141)](_0x2228ea);}}else _0x189899[_0x303c0d(0x3e7)]['push'](_0x32dd7a[_0x303c0d(0x467)]());}},Game_Action['prototype'][_0x19f7cd(0x18e)]=function(_0x204819){const _0x32cef0=_0x19f7cd,_0x4ae1e4=[_0x32cef0(0x28d),'MAXMP',_0x32cef0(0x1b2),_0x32cef0(0x3e5),_0x32cef0(0x2da),_0x32cef0(0x2f7),'AGI','LUK'],_0x1222c9=this['item']()[_0x32cef0(0x1ce)],_0x27e1ec=_0x1222c9['match'](/<SET[ ](.*)[ ]BUFF TURNS:[ ](\d+)>/gi);if(_0x27e1ec)for(const _0x13258c of _0x27e1ec){_0x13258c[_0x32cef0(0x138)](/<SET[ ](.*)[ ]BUFF TURNS:[ ](\d+)>/i);const _0x258cc7=_0x4ae1e4['indexOf'](String(RegExp['$1'])[_0x32cef0(0x3cd)]()),_0x5989a7=Number(RegExp['$2']);_0x258cc7>=0x0&&(_0x204819[_0x32cef0(0x1b1)](_0x258cc7,_0x5989a7),this[_0x32cef0(0x141)](_0x204819));}const _0x12f086=_0x1222c9[_0x32cef0(0x138)](/<(.*)[ ]BUFF TURNS:[ ]([\+\-]\d+)>/gi);if(_0x12f086)for(const _0x45c9f7 of _0x27e1ec){_0x45c9f7[_0x32cef0(0x138)](/<(.*)[ ]BUFF TURNS:[ ]([\+\-]\d+)>/i);const _0x472524=_0x4ae1e4['indexOf'](String(RegExp['$1'])['toUpperCase']()),_0x561d6e=Number(RegExp['$2']);_0x472524>=0x0&&(_0x204819[_0x32cef0(0x3e1)](_0x472524,_0x561d6e),this[_0x32cef0(0x141)](_0x204819));}},Game_Action[_0x19f7cd(0x296)]['applyDebuffTurnManipulationEffects']=function(_0x2e9985){const _0x1bc4e2=_0x19f7cd,_0x1e75e1=[_0x1bc4e2(0x28d),'MAXMP',_0x1bc4e2(0x1b2),_0x1bc4e2(0x3e5),'MAT',_0x1bc4e2(0x2f7),_0x1bc4e2(0x1ae),_0x1bc4e2(0x384)],_0x3c1443=this[_0x1bc4e2(0x1ca)]()[_0x1bc4e2(0x1ce)],_0x26d838=_0x3c1443['match'](/<SET[ ](.*)[ ]DEBUFF TURNS:[ ](\d+)>/gi);if(_0x26d838)for(const _0xb1c08f of _0x26d838){if('nFouP'!==_0x1bc4e2(0x406)){if(!_0x116077[_0x1bc4e2(0x2cb)])return![];else return this['isUseSkillsStatesCoreUpdatedLayout']()?!![]:_0x2120a7[_0x1bc4e2(0x21a)][_0x1bc4e2(0x417)][_0x1bc4e2(0x270)]['ShowShopStatus'];}else{_0xb1c08f[_0x1bc4e2(0x138)](/<SET[ ](.*)[ ]DEBUFF TURNS:[ ](\d+)>/i);const _0x1f8cc5=_0x1e75e1[_0x1bc4e2(0x32c)](String(RegExp['$1'])['toUpperCase']()),_0x5196e5=Number(RegExp['$2']);_0x1f8cc5>=0x0&&(_0x2e9985[_0x1bc4e2(0x1e9)](_0x1f8cc5,_0x5196e5),this[_0x1bc4e2(0x141)](_0x2e9985));}}const _0x451a27=_0x3c1443[_0x1bc4e2(0x138)](/<(.*)[ ]DEBUFF TURNS:[ ]([\+\-]\d+)>/gi);if(_0x451a27)for(const _0x52f3c7 of _0x26d838){if(_0x1bc4e2(0x188)==='YEvOF')_0x4151fb=_0x4392bb[_0x1bc4e2(0x314)](_0x52c73b['$1']),_0x57dfba=_0x2ffe89(_0x2969e1['$2']);else{_0x52f3c7[_0x1bc4e2(0x138)](/<(.*)[ ]DEBUFF TURNS:[ ]([\+\-]\d+)>/i);const _0xd1a1a0=_0x1e75e1[_0x1bc4e2(0x32c)](String(RegExp['$1'])[_0x1bc4e2(0x3cd)]()),_0x41e8a1=Number(RegExp['$2']);_0xd1a1a0>=0x0&&('cMyhL'==='cMyhL'?(_0x2e9985[_0x1bc4e2(0x315)](_0xd1a1a0,_0x41e8a1),this[_0x1bc4e2(0x141)](_0x2e9985)):(_0x236a46['SkillsStatesCore'][_0x1bc4e2(0x26d)][_0x1bc4e2(0x277)](this,_0x5e2fac),this['makeCurrentTroopUniqueID']()));}}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x137)]=Game_BattlerBase[_0x19f7cd(0x296)]['initMembers'],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x42f)]=function(){const _0x2811b0=_0x19f7cd;this['_cache']={},this[_0x2811b0(0x1d2)](),VisuMZ[_0x2811b0(0x21a)][_0x2811b0(0x137)][_0x2811b0(0x277)](this);},Game_BattlerBase['prototype'][_0x19f7cd(0x1d2)]=function(){const _0x187de1=_0x19f7cd;this[_0x187de1(0x426)]='',this[_0x187de1(0x16e)]={},this[_0x187de1(0x431)]={},this[_0x187de1(0x46e)]={};},Game_BattlerBase[_0x19f7cd(0x296)]['checkCacheKey']=function(_0x21d196){const _0x5f5cc2=_0x19f7cd;return this[_0x5f5cc2(0x458)]=this[_0x5f5cc2(0x458)]||{},this[_0x5f5cc2(0x458)][_0x21d196]!==undefined;},VisuMZ[_0x19f7cd(0x21a)]['Game_BattlerBase_refresh']=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x2bb)],Game_BattlerBase['prototype']['refresh']=function(){const _0x462a49=_0x19f7cd;this[_0x462a49(0x458)]={},VisuMZ[_0x462a49(0x21a)][_0x462a49(0x341)]['call'](this);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1ad)]=Game_BattlerBase['prototype'][_0x19f7cd(0x224)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x224)]=function(_0x5df293){const _0xf50d2b=_0x19f7cd;let _0x238764=this[_0xf50d2b(0x3b6)](_0x5df293);VisuMZ[_0xf50d2b(0x21a)][_0xf50d2b(0x1ad)][_0xf50d2b(0x277)](this,_0x5df293);if(_0x238764&&!this[_0xf50d2b(0x3b6)](_0x5df293))this[_0xf50d2b(0x41a)](_0x5df293);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x41a)]=function(_0x5a6d3d){const _0x12a765=_0x19f7cd;this[_0x12a765(0x30c)](_0x5a6d3d),this[_0x12a765(0x220)](_0x5a6d3d);},VisuMZ[_0x19f7cd(0x21a)]['Game_Battler_onBattleEnd']=Game_Battler[_0x19f7cd(0x296)]['onBattleEnd'],Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x332)]=function(){const _0x4a34bd=_0x19f7cd;VisuMZ[_0x4a34bd(0x21a)]['Game_Battler_onBattleEnd']['call'](this),this[_0x4a34bd(0x301)]();},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x383)]=Game_BattlerBase['prototype'][_0x19f7cd(0x443)],Game_BattlerBase['prototype'][_0x19f7cd(0x443)]=function(_0x38b420){const _0x22e09d=_0x19f7cd,_0xb689c3=$dataStates[_0x38b420],_0x2e829b=this[_0x22e09d(0x320)](_0x38b420),_0x39bb6b=this[_0x22e09d(0x31e)](_0xb689c3)[_0x22e09d(0x306)]()[_0x22e09d(0x467)]();switch(_0x39bb6b){case _0x22e09d(0x462):if(_0x2e829b<=0x0)this[_0x22e09d(0x2a2)](_0x38b420);break;case'reset':this[_0x22e09d(0x2a2)](_0x38b420);break;case'greater':this[_0x22e09d(0x2a2)](_0x38b420),this[_0x22e09d(0x3e0)][_0x38b420]=Math[_0x22e09d(0x1b7)](this[_0x22e09d(0x3e0)][_0x38b420],_0x2e829b);break;case _0x22e09d(0x14b):this['prepareResetStateCounts'](_0x38b420),this['_stateTurns'][_0x38b420]+=_0x2e829b;break;default:this[_0x22e09d(0x2a2)](_0x38b420);break;}if(this[_0x22e09d(0x3b6)](_0x38b420)){if(_0x22e09d(0x172)===_0x22e09d(0x396))_0x5623de[_0x22e09d(0x3e7)][_0x22e09d(0x272)](_0x22e09d(0x1c6));else{const _0xa63567=DataManager[_0x22e09d(0x1eb)](_0x38b420);this[_0x22e09d(0x3e0)][_0x38b420]=this[_0x22e09d(0x3e0)][_0x38b420]['clamp'](0x0,_0xa63567);}}},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x2a2)]=function(_0x1d7713){const _0x1d2deb=_0x19f7cd;VisuMZ[_0x1d2deb(0x21a)][_0x1d2deb(0x383)][_0x1d2deb(0x277)](this,_0x1d7713);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x31e)]=function(_0x3789f3){const _0x2e0a1c=_0x19f7cd,_0x97cd1f=_0x3789f3[_0x2e0a1c(0x1ce)];if(_0x97cd1f['match'](/<REAPPLY RULES:[ ](.*)>/i)){if('XIxQL'!==_0x2e0a1c(0x453)){if(typeof _0x4a1ec4!==_0x2e0a1c(0x46c))_0x3a3fb8=_0x2ee78c['id'];this[_0x2e0a1c(0x46e)]=this[_0x2e0a1c(0x46e)]||{},this[_0x2e0a1c(0x46e)][_0x52a732]=this[_0x2e0a1c(0x46e)][_0x8dc674]||_0x2e0a1c(0x1da);const _0x3909a1=this[_0x2e0a1c(0x46e)][_0x3c6c53];return this[_0x2e0a1c(0x2d1)](_0x3909a1);}else return String(RegExp['$1']);}else return VisuMZ['SkillsStatesCore']['Settings'][_0x2e0a1c(0x32e)][_0x2e0a1c(0x32a)];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x292)]=Game_BattlerBase[_0x19f7cd(0x296)]['overwriteBuffTurns'],Game_BattlerBase['prototype'][_0x19f7cd(0x2f6)]=function(_0x2336ee,_0x272cc7){const _0xede0be=_0x19f7cd,_0x272ab4=VisuMZ[_0xede0be(0x21a)][_0xede0be(0x417)][_0xede0be(0x180)][_0xede0be(0x32a)],_0xccb395=this['buffTurns'](_0x2336ee);switch(_0x272ab4){case _0xede0be(0x462):if(_0xccb395<=0x0)this[_0xede0be(0x179)][_0x2336ee]=_0x272cc7;break;case _0xede0be(0x47c):this[_0xede0be(0x179)][_0x2336ee]=_0x272cc7;break;case _0xede0be(0x2f9):this[_0xede0be(0x179)][_0x2336ee]=Math[_0xede0be(0x1b7)](_0xccb395,_0x272cc7);break;case _0xede0be(0x14b):this['_buffTurns'][_0x2336ee]+=_0x272cc7;break;default:VisuMZ[_0xede0be(0x21a)][_0xede0be(0x292)][_0xede0be(0x277)](this,_0x2336ee,_0x272cc7);break;}const _0x1dffaa=VisuMZ[_0xede0be(0x21a)]['Settings'][_0xede0be(0x180)]['MaxTurns'];this[_0xede0be(0x179)][_0x2336ee]=this[_0xede0be(0x179)][_0x2336ee]['clamp'](0x0,_0x1dffaa);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x425)]=function(){const _0x39f594=_0x19f7cd;if(this[_0x39f594(0x458)][_0x39f594(0x29f)]!==undefined)return this['_cache'][_0x39f594(0x29f)];this[_0x39f594(0x458)][_0x39f594(0x29f)]=![];const _0x574ddf=this[_0x39f594(0x25d)]();for(const _0xf5b970 of _0x574ddf){if(!_0xf5b970)continue;if(_0xf5b970[_0x39f594(0x1ce)][_0x39f594(0x138)](/<GROUP DEFEAT>/i)){if(_0x39f594(0x204)===_0x39f594(0x204)){this['_cache']['groupDefeat']=!![];break;}else _0x325bf2+=this[_0x39f594(0x320)](_0x360f6f),this[_0x39f594(0x3ed)](_0xa871dd,_0x3a1d8c);}}return this[_0x39f594(0x458)][_0x39f594(0x29f)];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x250)]=Game_Unit[_0x19f7cd(0x296)]['deadMembers'],Game_Unit[_0x19f7cd(0x296)][_0x19f7cd(0x48d)]=function(){const _0x3a80fc=_0x19f7cd;let _0x3fd957=VisuMZ[_0x3a80fc(0x21a)]['Game_Unit_deadMembers'][_0x3a80fc(0x277)](this);return BattleManager[_0x3a80fc(0x149)]&&(_0x3fd957=_0x3fd957[_0x3a80fc(0x2ea)](this[_0x3a80fc(0x2b0)]()[_0x3a80fc(0x3ab)](_0x2ba43a=>_0x2ba43a[_0x3a80fc(0x425)]()))),_0x3fd957;},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x219)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x497)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x497)]=function(){const _0x1454bb=_0x19f7cd;this[_0x1454bb(0x275)]()!==''?this[_0x1454bb(0x35b)]():(VisuMZ[_0x1454bb(0x21a)][_0x1454bb(0x219)][_0x1454bb(0x277)](this),this[_0x1454bb(0x1d2)]());},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x497)]=function(){const _0x20acb9=_0x19f7cd;this[_0x20acb9(0x42c)]=this[_0x20acb9(0x42c)]||{},Game_Battler[_0x20acb9(0x296)][_0x20acb9(0x497)][_0x20acb9(0x277)](this);},Game_BattlerBase[_0x19f7cd(0x296)]['clearStatesWithStateRetain']=function(){const _0xf36ae8=_0x19f7cd,_0x242b3b=this[_0xf36ae8(0x25d)]();for(const _0x403c93 of _0x242b3b){if(_0x403c93&&this[_0xf36ae8(0x24d)](_0x403c93))this[_0xf36ae8(0x224)](_0x403c93['id']);}this[_0xf36ae8(0x458)]={};},Game_BattlerBase[_0x19f7cd(0x296)]['canClearState']=function(_0x5731b0){const _0x2c0127=_0x19f7cd,_0x17ee8e=this[_0x2c0127(0x275)]();if(_0x17ee8e!==''){const _0x441fd2=_0x5731b0[_0x2c0127(0x1ce)];if(_0x17ee8e===_0x2c0127(0x23c)&&_0x441fd2[_0x2c0127(0x138)](/<NO DEATH CLEAR>/i))return![];if(_0x17ee8e==='recover\x20all'&&_0x441fd2[_0x2c0127(0x138)](/<NO RECOVER ALL CLEAR>/i))return![];}return this[_0x2c0127(0x3b6)](_0x5731b0['id']);},Game_BattlerBase[_0x19f7cd(0x296)]['getStateRetainType']=function(){const _0xae0f3b=_0x19f7cd;return this[_0xae0f3b(0x426)];},Game_BattlerBase['prototype'][_0x19f7cd(0x278)]=function(_0x7e33a7){const _0x292fbb=_0x19f7cd;this[_0x292fbb(0x426)]=_0x7e33a7;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x374)]=function(){const _0x152e94=_0x19f7cd;this[_0x152e94(0x426)]='';},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x464)]=Game_BattlerBase['prototype'][_0x19f7cd(0x30d)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x30d)]=function(){const _0x1771b5=_0x19f7cd;this['setStateRetainType'](_0x1771b5(0x23c)),VisuMZ['SkillsStatesCore'][_0x1771b5(0x464)][_0x1771b5(0x277)](this),this[_0x1771b5(0x374)]();},VisuMZ['SkillsStatesCore']['Game_BattlerBase_recoverAll']=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x22d)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x22d)]=function(){const _0x46f424=_0x19f7cd;this['setStateRetainType'](_0x46f424(0x2e4)),VisuMZ[_0x46f424(0x21a)]['Game_BattlerBase_recoverAll'][_0x46f424(0x277)](this),this[_0x46f424(0x374)]();},Game_BattlerBase['prototype'][_0x19f7cd(0x469)]=function(_0x4e2a46,_0x3b5bba,_0x43850a){return _0x3b5bba;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x416)]=function(_0x26d847){const _0x5cfa96=_0x19f7cd;for(settings of VisuMZ[_0x5cfa96(0x21a)][_0x5cfa96(0x417)]['Costs']){if(_0x5cfa96(0x2ba)!=='PIQRn'){let _0x1e15f4=settings[_0x5cfa96(0x24c)][_0x5cfa96(0x277)](this,_0x26d847);_0x1e15f4=this[_0x5cfa96(0x469)](_0x26d847,_0x1e15f4,settings);if(!settings[_0x5cfa96(0x38e)][_0x5cfa96(0x277)](this,_0x26d847,_0x1e15f4))return![];}else{if(_0x451c1d[_0x5cfa96(0x305)]===0x1)return this[_0x5cfa96(0x409)]();else{if(_0x4bb46e[_0x5cfa96(0x305)]===0x2)return this[_0x5cfa96(0x43c)]();}}}return!![];},Game_BattlerBase[_0x19f7cd(0x296)]['paySkillCost']=function(_0x4e72b4){const _0x1067ac=_0x19f7cd;for(settings of VisuMZ[_0x1067ac(0x21a)][_0x1067ac(0x417)][_0x1067ac(0x185)]){if('tSpzK'!==_0x1067ac(0x3df)){const _0x29d5ca=_0x2b374c(_0x197b14['$1']);_0x29d5ca!==_0x1c4da3[_0x963f4d][_0x1067ac(0x36b)]&&(_0x3f1691('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x1067ac(0x29a)](_0x53f742,_0x29d5ca)),_0x200116[_0x1067ac(0x136)]());}else{let _0x506976=settings['CalcJS'][_0x1067ac(0x277)](this,_0x4e72b4);_0x506976=this[_0x1067ac(0x469)](_0x4e72b4,_0x506976,settings),settings[_0x1067ac(0x242)][_0x1067ac(0x277)](this,_0x4e72b4,_0x506976);}}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3a8)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x473)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x473)]=function(_0x53bc47){const _0x5c1c09=_0x19f7cd;if(!_0x53bc47)return![];if(!VisuMZ[_0x5c1c09(0x21a)]['Game_BattlerBase_meetsSkillConditions']['call'](this,_0x53bc47))return![];if(!this[_0x5c1c09(0x34f)](_0x53bc47))return![];if(!this['meetsSkillConditionsEnableJS'](_0x53bc47))return![];if(!this[_0x5c1c09(0x3f3)](_0x53bc47))return![];return!![];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x34f)]=function(_0x5715e0){const _0x50a39d=_0x19f7cd;if(!this[_0x50a39d(0x169)](_0x5715e0))return![];return!![];},Game_BattlerBase['prototype'][_0x19f7cd(0x169)]=function(_0x824fb4){const _0x2d27dd=_0x19f7cd,_0xcd2c16=_0x824fb4['note'];if(_0xcd2c16[_0x2d27dd(0x138)](/<ENABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x9004c7=JSON[_0x2d27dd(0x256)]('['+RegExp['$1'][_0x2d27dd(0x138)](/\d+/g)+']');for(const _0x3419d7 of _0x9004c7){if('wONAP'!==_0x2d27dd(0x2c0)){const _0x919021=this[_0x2d27dd(0x2a8)](),_0x565549=_0x5d1ad4['getSkillTypes'](_0x3b1f1c),_0x608578=_0x919021[_0x2d27dd(0x3ab)](_0x93bfdc=>_0x565549[_0x2d27dd(0x3c5)](_0x93bfdc));return _0x608578['length']>0x0;}else{if(!$gameSwitches[_0x2d27dd(0x151)](_0x3419d7))return![];}}return!![];}if(_0xcd2c16[_0x2d27dd(0x138)](/<ENABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x55c113=JSON[_0x2d27dd(0x256)]('['+RegExp['$1'][_0x2d27dd(0x138)](/\d+/g)+']');for(const _0xd5f6c7 of _0x55c113){if(!$gameSwitches[_0x2d27dd(0x151)](_0xd5f6c7))return![];}return!![];}if(_0xcd2c16[_0x2d27dd(0x138)](/<ENABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0x2d27dd(0x230)!==_0x2d27dd(0x175)){const _0x2b21c1=JSON[_0x2d27dd(0x256)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x30217d of _0x2b21c1){if($gameSwitches[_0x2d27dd(0x151)](_0x30217d))return!![];}return![];}else{const _0x37aa8f=_0x26d9b5[_0x2d27dd(0x256)]('['+_0x16dbae['$1']['match'](/\d+/g)+']');for(const _0x1dfeec of _0x37aa8f){if(!_0x4b8511[_0x2d27dd(0x151)](_0x1dfeec))return![];}return!![];}}if(_0xcd2c16[_0x2d27dd(0x138)](/<DISABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x23d996=JSON[_0x2d27dd(0x256)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x11ebb7 of _0x23d996){if(!$gameSwitches['value'](_0x11ebb7))return!![];}return![];}if(_0xcd2c16[_0x2d27dd(0x138)](/<DISABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x274277=JSON[_0x2d27dd(0x256)]('['+RegExp['$1'][_0x2d27dd(0x138)](/\d+/g)+']');for(const _0xd4b36e of _0x274277){if(!$gameSwitches[_0x2d27dd(0x151)](_0xd4b36e))return!![];}return![];}if(_0xcd2c16[_0x2d27dd(0x138)](/<DISABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x2ddd92=JSON['parse']('['+RegExp['$1'][_0x2d27dd(0x138)](/\d+/g)+']');for(const _0x52a039 of _0x2ddd92){if('tXzRv'!==_0x2d27dd(0x343)){if($gameSwitches[_0x2d27dd(0x151)](_0x52a039))return![];}else{const _0x2a0a2f=_0x2bcb0f[_0x2d27dd(0x256)]('['+_0x438e6e['$1']['match'](/\d+/g)+']');for(const _0x1f60bd of _0x2a0a2f){if(!_0x1c647f[_0x2d27dd(0x151)](_0x1f60bd))return![];}return!![];}}return!![];}return!![];},Game_BattlerBase['prototype'][_0x19f7cd(0x37e)]=function(_0x5e826c){const _0x54e79f=_0x19f7cd,_0x3c3ff9=_0x5e826c['note'],_0x1f164f=VisuMZ['SkillsStatesCore'][_0x54e79f(0x45d)];if(_0x1f164f[_0x5e826c['id']])return _0x1f164f[_0x5e826c['id']][_0x54e79f(0x277)](this,_0x5e826c);else{if('RBfbK'===_0x54e79f(0x2b3))this[_0x54e79f(0x431)][_0x51607b]='';else return!![];}},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3f3)]=function(_0x2c2e03){const _0x34dfc0=_0x19f7cd;return VisuMZ[_0x34dfc0(0x21a)][_0x34dfc0(0x417)][_0x34dfc0(0x270)][_0x34dfc0(0x346)]['call'](this,_0x2c2e03);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x282)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x423)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x423)]=function(_0x549c59){const _0x38769d=_0x19f7cd;for(settings of VisuMZ[_0x38769d(0x21a)]['Settings'][_0x38769d(0x185)]){if('NZsiL'!==_0x38769d(0x2f2)){if(settings[_0x38769d(0x421)][_0x38769d(0x3cd)]()==='MP'){if(_0x38769d(0x3ee)===_0x38769d(0x402))return this['isUseSkillsStatesCoreUpdatedLayout']()?this[_0x38769d(0x3ce)]():_0x1a7dc8[_0x38769d(0x21a)]['Settings'][_0x38769d(0x270)][_0x38769d(0x37c)][_0x38769d(0x277)](this);else{let _0x41506b=settings[_0x38769d(0x24c)][_0x38769d(0x277)](this,_0x549c59);return _0x41506b=this[_0x38769d(0x469)](_0x549c59,_0x41506b,settings),_0x41506b;}}}else for(let _0x40aff8=0x0;_0x40aff8<this[_0x38769d(0x25a)]();_0x40aff8++){if(this[_0x38769d(0x39f)](_0x40aff8)){const _0x10c394=this[_0x38769d(0x365)][_0x40aff8];this[_0x38769d(0x44a)](_0x40aff8);if(_0x10c394>0x0)this[_0x38769d(0x1f7)](_0x40aff8);if(_0x10c394<0x0)this['onExpireDebuff'](_0x40aff8);}}}return VisuMZ[_0x38769d(0x21a)][_0x38769d(0x282)][_0x38769d(0x277)](this,_0x549c59);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3b0)]=Game_BattlerBase['prototype']['skillTpCost'],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x43d)]=function(_0x3c9de4){const _0x4366e8=_0x19f7cd;for(settings of VisuMZ['SkillsStatesCore']['Settings']['Costs']){if(_0x4366e8(0x412)!==_0x4366e8(0x412)){const _0x4a127e=_0x1913a9(_0x2a761d['$1']),_0x165c8e=_0x4366e8(0x2f3)[_0x4366e8(0x29a)](_0x4a127e);_0x5df7fa[_0x4366e8(0x21a)]['statePassiveConditionJS'][_0x1d4506['id']]=new _0x5493be(_0x4366e8(0x3e2),_0x165c8e);}else{if(settings[_0x4366e8(0x421)]['toUpperCase']()==='TP'){let _0x2eed53=settings[_0x4366e8(0x24c)][_0x4366e8(0x277)](this,_0x3c9de4);return _0x2eed53=this['adjustSkillCost'](_0x3c9de4,_0x2eed53,settings),_0x2eed53;}}}return VisuMZ[_0x4366e8(0x21a)][_0x4366e8(0x3b0)][_0x4366e8(0x277)](this,_0x3c9de4);},Game_BattlerBase['prototype']['hasState']=function(_0x5aa87d){const _0x1a21bb=_0x19f7cd;if(typeof _0x5aa87d===_0x1a21bb(0x46c))_0x5aa87d=$dataStates[_0x5aa87d];return this[_0x1a21bb(0x25d)]()[_0x1a21bb(0x3c5)](_0x5aa87d);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3c2)]=Game_BattlerBase['prototype'][_0x19f7cd(0x25d)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x25d)]=function(){const _0x2c163b=_0x19f7cd;let _0x276f58=VisuMZ[_0x2c163b(0x21a)][_0x2c163b(0x3c2)][_0x2c163b(0x277)](this);if($gameTemp[_0x2c163b(0x2bd)])return _0x276f58;return $gameTemp[_0x2c163b(0x2bd)]=!![],this['addPassiveStates'](_0x276f58),$gameTemp[_0x2c163b(0x2bd)]=undefined,_0x276f58;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x22a)]=function(_0x1601d4){const _0x510bba=_0x19f7cd,_0x4aba72=this['passiveStates']();for(state of _0x4aba72){if(!state)continue;if(!this[_0x510bba(0x3c1)](state)&&_0x1601d4[_0x510bba(0x3c5)](state))continue;_0x1601d4[_0x510bba(0x272)](state);}_0x4aba72['length']>0x0&&_0x1601d4[_0x510bba(0x498)]((_0x5e9a94,_0x226e17)=>{const _0x56ccf1=_0x510bba;if(_0x56ccf1(0x2ed)!==_0x56ccf1(0x2ed)){const _0x50d26e=_0x4eb995[_0x56ccf1(0x182)],_0x571ba7=_0x443a81[_0x56ccf1(0x182)];if(_0x50d26e!==_0x571ba7)return _0x571ba7-_0x50d26e;return _0x1abf29-_0x5690ed;}else{const _0x4369b4=_0x5e9a94[_0x56ccf1(0x182)],_0x1f66ba=_0x226e17[_0x56ccf1(0x182)];if(_0x4369b4!==_0x1f66ba)return _0x1f66ba-_0x4369b4;return _0x5e9a94-_0x226e17;}});},Game_BattlerBase[_0x19f7cd(0x296)]['isPassiveStateStackable']=function(_0x1bf7b7){const _0x1954c8=_0x19f7cd;return _0x1bf7b7[_0x1954c8(0x1ce)]['match'](/<PASSIVE STACKABLE>/i);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3de)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3a7)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3a7)]=function(_0x3b3e12){const _0x344725=_0x19f7cd;this[_0x344725(0x3d9)]=!![];let _0x23c4ac=VisuMZ[_0x344725(0x21a)][_0x344725(0x3de)][_0x344725(0x277)](this,_0x3b3e12);return this[_0x344725(0x3d9)]=undefined,_0x23c4ac;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x2df)]=function(){const _0x42a1d1=_0x19f7cd;let _0x5a75d0=[];this[_0x42a1d1(0x47d)]=this[_0x42a1d1(0x47d)]||{};for(;;){_0x5a75d0=[];let _0x1ac662=!![];for(const _0x5e2c5d of this['_cache'][_0x42a1d1(0x27f)]){if(_0x42a1d1(0x158)!==_0x42a1d1(0x158))this['onExpireDebuffGlobalJS'](_0x456687);else{const _0x500c5c=$dataStates[_0x5e2c5d];if(!_0x500c5c)continue;let _0x313206=this['meetsPassiveStateConditions'](_0x500c5c);this[_0x42a1d1(0x47d)][_0x5e2c5d]!==_0x313206&&(_0x1ac662=![],this[_0x42a1d1(0x47d)][_0x5e2c5d]=_0x313206);if(!_0x313206)continue;_0x5a75d0[_0x42a1d1(0x272)](_0x500c5c);}}if(_0x1ac662){if(_0x42a1d1(0x3a1)===_0x42a1d1(0x324))_0x32bb24[_0x42a1d1(0x21a)][_0x42a1d1(0x2d4)][_0x42a1d1(0x277)](this,_0x1c5430),this[_0x42a1d1(0x458)]={},this[_0x42a1d1(0x27f)]();else break;}else{if(_0x42a1d1(0x293)!==_0x42a1d1(0x293)){if(_0x2da12e)_0x51d72d[_0x42a1d1(0x2bb)]();}else{if(!this['_checkingTraitsSetSkillsStatesCore'])this[_0x42a1d1(0x2bb)]();this[_0x42a1d1(0x190)]();}}}return _0x5a75d0;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x247)]=function(_0x556fe8){const _0x257ef0=_0x19f7cd;if(!this['meetsPassiveStateConditionClasses'](_0x556fe8))return![];if(!this['meetsPassiveStateConditionSwitches'](_0x556fe8))return![];if(!this[_0x257ef0(0x37f)](_0x556fe8))return![];if(!this['meetsPassiveStateGlobalConditionJS'](_0x556fe8))return![];return!![];},Game_BattlerBase[_0x19f7cd(0x296)]['meetsPassiveStateConditionClasses']=function(_0x12b8b9){return!![];},Game_Actor['prototype']['meetsPassiveStateConditionClasses']=function(_0xe3ce5a){const _0x108a91=_0x19f7cd,_0x59fa4a=DataManager[_0x108a91(0x3b1)](_0xe3ce5a);if(_0x59fa4a[_0x108a91(0x194)][_0x108a91(0x313)]>0x0){const _0x521ea2=_0x59fa4a[_0x108a91(0x194)];if(!_0x521ea2[_0x108a91(0x3c5)](this['currentClass']()))return![];}if(_0x59fa4a[_0x108a91(0x3da)][_0x108a91(0x313)]>0x0){if(_0x108a91(0x1e7)===_0x108a91(0x15d))_0x8ccbab[_0x108a91(0x1b1)](_0x43e942,_0x1c95c4),this[_0x108a91(0x141)](_0x2e8968);else{const _0xfc7c6f=_0x59fa4a[_0x108a91(0x3da)];let _0x52d85d=[this[_0x108a91(0x194)]()];if(Imported[_0x108a91(0x3d3)]&&this[_0x108a91(0x434)]){if('lJxEg'!==_0x108a91(0x222))return _0x108a91(0x41e);else _0x52d85d=this['multiclasses']();}if(_0xfc7c6f['filter'](_0x1dcfca=>_0x52d85d[_0x108a91(0x3c5)](_0x1dcfca))[_0x108a91(0x313)]<=0x0)return![];}}return Game_BattlerBase[_0x108a91(0x296)][_0x108a91(0x385)][_0x108a91(0x277)](this,_0xe3ce5a);},DataManager[_0x19f7cd(0x3b1)]=function(_0x5b6470){const _0x1d7b80=_0x19f7cd,_0x5b1c9f={'currentClass':[],'multiClass':[]};if(!_0x5b6470)return _0x5b1c9f;this[_0x1d7b80(0x329)]=this[_0x1d7b80(0x329)]||{};if(this[_0x1d7b80(0x329)][_0x5b6470['id']]!==undefined){if(_0x1d7b80(0x273)===_0x1d7b80(0x273))return this[_0x1d7b80(0x329)][_0x5b6470['id']];else{_0x33fa7d[_0x1d7b80(0x296)][_0x1d7b80(0x471)]['call'](this);const _0x5c38a5=_0x5a5af2[_0x1d7b80(0x21a)][_0x1d7b80(0x417)][_0x1d7b80(0x3cc)]['Enemy'];this[_0x1d7b80(0x458)][_0x1d7b80(0x27f)]=this[_0x1d7b80(0x458)][_0x1d7b80(0x27f)][_0x1d7b80(0x2ea)](_0x5c38a5);}}const _0x3a3d8b=_0x5b6470[_0x1d7b80(0x1ce)]||'';if(_0x3a3d8b[_0x1d7b80(0x138)](/<PASSIVE CONDITION[ ](?:CLASS|CLASSES):[ ](.*)>/i)){const _0x284419=String(RegExp['$1'])['split'](',')['map'](_0x4d1b82=>_0x4d1b82['trim']());_0x5b1c9f[_0x1d7b80(0x194)]=VisuMZ['SkillsStatesCore'][_0x1d7b80(0x290)](_0x284419);}if(_0x3a3d8b[_0x1d7b80(0x138)](/<PASSIVE CONDITION[ ](?:MULTICLASS|MULTICLASSES):[ ](.*)>/i)){const _0x51332c=String(RegExp['$1'])[_0x1d7b80(0x344)](',')['map'](_0x5d8eb3=>_0x5d8eb3[_0x1d7b80(0x467)]());_0x5b1c9f['multiClass']=VisuMZ[_0x1d7b80(0x21a)][_0x1d7b80(0x290)](_0x51332c);}return this[_0x1d7b80(0x329)][_0x5b6470['id']]=_0x5b1c9f,this['_cache_getPassiveStateConditionClassesData'][_0x5b6470['id']];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x290)]=function(_0x36d15d){const _0x22aa3c=_0x19f7cd,_0x3ca7a8=[];for(let _0x8abb8d of _0x36d15d){if(_0x22aa3c(0x20d)!=='fVLaO'){const _0xf5e457=_0x290907(_0x46c9ee['$1']),_0x148be0=_0x22aa3c(0x2b7)[_0x22aa3c(0x29a)](_0xf5e457);_0xaf8c1e[_0x22aa3c(0x21a)]['skillEnableJS'][_0x10bb37['id']]=new _0x132945(_0x22aa3c(0x1f1),_0x148be0);}else{_0x8abb8d=(String(_0x8abb8d)||'')[_0x22aa3c(0x467)]();const _0x2854e3=/^\d+$/['test'](_0x8abb8d);_0x2854e3?_0x3ca7a8[_0x22aa3c(0x272)](Number(_0x8abb8d)):_0x22aa3c(0x152)!==_0x22aa3c(0x152)?(_0x39412d['prototype'][_0x22aa3c(0x34b)][_0x22aa3c(0x277)](this,_0x4e5c9c),this[_0x22aa3c(0x410)](_0x2b31bb)):_0x3ca7a8['push'](DataManager[_0x22aa3c(0x3a5)](_0x8abb8d));}}return _0x3ca7a8[_0x22aa3c(0x466)](_0x2c7e35=>$dataClasses[Number(_0x2c7e35)])['remove'](null);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x391)]=function(_0x2af11d){const _0x343f2e=_0x19f7cd,_0x1ac345=DataManager[_0x343f2e(0x2c6)](_0x2af11d);if(_0x1ac345[_0x343f2e(0x397)]&&_0x1ac345['allSwitchOn'][_0x343f2e(0x313)]>0x0){const _0x265401=_0x1ac345['allSwitchOn'];for(const _0x553ad0 of _0x265401){if(!$gameSwitches[_0x343f2e(0x151)](_0x553ad0))return![];}}if(_0x1ac345[_0x343f2e(0x460)]&&_0x1ac345[_0x343f2e(0x460)][_0x343f2e(0x313)]>0x0){const _0x19b6a7=_0x1ac345[_0x343f2e(0x460)];let _0x1f86ac=!![];for(const _0x2ec7eb of _0x19b6a7){if('UTLFx'!==_0x343f2e(0x2b9)){const _0x14bb8f=this[_0x343f2e(0x18c)]();for(const _0x5d3e12 of _0x14bb8f){if(!_0x5d3e12[_0x343f2e(0x425)]())return![];}return!![];}else{if($gameSwitches[_0x343f2e(0x151)](_0x2ec7eb)){_0x1f86ac=![];break;}}}if(_0x1f86ac)return![];}if(_0x1ac345['allSwitchOff']&&_0x1ac345['allSwitchOff']['length']>0x0){const _0x10235d=_0x1ac345['allSwitchOff'];for(const _0x486f0a of _0x10235d){if(_0x343f2e(0x420)!==_0x343f2e(0x1bf)){if($gameSwitches[_0x343f2e(0x151)](_0x486f0a))return![];}else this['bitmap'][_0x343f2e(0x485)](),this[_0x343f2e(0x40c)]['GaugeDrawJS'][_0x343f2e(0x277)](this);}}if(_0x1ac345[_0x343f2e(0x206)]&&_0x1ac345[_0x343f2e(0x206)][_0x343f2e(0x313)]>0x0){if(_0x343f2e(0x2ec)!==_0x343f2e(0x2ec)){const _0x2c5b0b=_0x54fa47[_0x343f2e(0x1ce)];_0x2c5b0b[_0x343f2e(0x138)](/<MP COST:[ ](\d+)>/i)&&(_0xc568ce[_0x343f2e(0x299)]=_0x56c595(_0x5f9c['$1'])),_0x2c5b0b[_0x343f2e(0x138)](/<TP COST:[ ](\d+)>/i)&&(_0x53f91c['tpCost']=_0xb21e26(_0xabfbd7['$1']));}else{const _0x545d4d=_0x1ac345[_0x343f2e(0x206)];let _0x3b4bc4=!![];for(const _0x10d578 of _0x545d4d){if(!$gameSwitches[_0x343f2e(0x151)](_0x10d578)){if(_0x343f2e(0x3fe)!==_0x343f2e(0x3fe)){const _0x43e929=_0x51f413['note'],_0x297f6a=_0x343f2e(0x268);if(_0x43e929[_0x343f2e(0x138)](/<JS ON ADD STATE>\s*([\s\S]*)\s*<\/JS ON ADD STATE>/i)){const _0x1fd034=_0x3b2d52(_0x55ccb5['$1']),_0x307abd=_0x297f6a[_0x343f2e(0x29a)](_0x1fd034);_0x57d1f8['SkillsStatesCore'][_0x343f2e(0x470)][_0x4acfd4['id']]=new _0x51fb05('stateId',_0x307abd);}if(_0x43e929[_0x343f2e(0x138)](/<JS ON ERASE STATE>\s*([\s\S]*)\s*<\/JS ON ERASE STATE>/i)){const _0x1d1463=_0x13afdd(_0x125a53['$1']),_0x38d0e6=_0x297f6a[_0x343f2e(0x29a)](_0x1d1463);_0x1cdf71['SkillsStatesCore'][_0x343f2e(0x33f)][_0x1c452d['id']]=new _0x4e342b(_0x343f2e(0x430),_0x38d0e6);}if(_0x43e929[_0x343f2e(0x138)](/<JS ON EXPIRE STATE>\s*([\s\S]*)\s*<\/JS ON EXPIRE STATE>/i)){const _0x358f04=_0x1d4402(_0x35a345['$1']),_0x1daac6=_0x297f6a[_0x343f2e(0x29a)](_0x358f04);_0x482e12[_0x343f2e(0x21a)][_0x343f2e(0x19f)][_0x3394c0['id']]=new _0x3cd280('stateId',_0x1daac6);}}else{_0x3b4bc4=![];break;}}}if(_0x3b4bc4)return![];}}return!![];},DataManager['getPassiveStateConditionSwitchData']=function(_0x4dbfbc){const _0x382906=_0x19f7cd;let _0x10e262={'allSwitchOn':[],'anySwitchOn':[],'allSwitchOff':[],'anySwitchOff':[]};if(!_0x4dbfbc)return _0x10e262;const _0x1f1063=_0x4dbfbc['id'];this[_0x382906(0x457)]=this[_0x382906(0x457)]||{};if(this[_0x382906(0x457)][_0x1f1063]!==undefined)return this[_0x382906(0x457)][_0x1f1063];const _0xbbd673=_0x4dbfbc['note']||'';return _0xbbd673['match'](/PASSIVE CONDITION(?:| ALL)[ ](?:SWITCH|SWITCHES)[ ]ON:[ ](.*)/i)&&(_0x10e262[_0x382906(0x397)]=String(RegExp['$1'])[_0x382906(0x344)](',')['map'](_0x1b3dd9=>Number(_0x1b3dd9))),_0xbbd673[_0x382906(0x138)](/PASSIVE CONDITION ANY[ ](?:SWITCH|SWITCHES)[ ]ON:[ ](.*)/i)&&(_0x382906(0x459)==='BYNCO'?_0x5af65e[_0x382906(0x3b4)](_0x49416b):_0x10e262[_0x382906(0x460)]=String(RegExp['$1'])[_0x382906(0x344)](',')[_0x382906(0x466)](_0x453ffc=>Number(_0x453ffc))),_0xbbd673[_0x382906(0x138)](/PASSIVE CONDITION(?:| ALL)[ ](?:SWITCH|SWITCHES)[ ]OFF:[ ](.*)/i)&&(_0x10e262[_0x382906(0x14e)]=String(RegExp['$1'])[_0x382906(0x344)](',')[_0x382906(0x466)](_0x1f4916=>Number(_0x1f4916))),_0xbbd673[_0x382906(0x138)](/PASSIVE CONDITION ANY[ ](?:SWITCH|SWITCHES)[ ]OFF:[ ](.*)/i)&&(_0x10e262[_0x382906(0x206)]=String(RegExp['$1'])[_0x382906(0x344)](',')[_0x382906(0x466)](_0x3788af=>Number(_0x3788af))),this[_0x382906(0x457)][_0x1f1063]=_0x10e262,this['_cache_getPassiveStateConditionSwitchData'][_0x1f1063];},Game_BattlerBase[_0x19f7cd(0x296)]['meetsPassiveStateConditionJS']=function(_0x27fb7d){const _0x21867e=_0x19f7cd,_0x258afa=VisuMZ[_0x21867e(0x21a)][_0x21867e(0x318)];if(_0x258afa[_0x27fb7d['id']]&&!_0x258afa[_0x27fb7d['id']][_0x21867e(0x277)](this,_0x27fb7d))return![];return!![];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x348)]=function(_0x3b5011){const _0x2dfeee=_0x19f7cd;return VisuMZ[_0x2dfeee(0x21a)][_0x2dfeee(0x417)][_0x2dfeee(0x3cc)][_0x2dfeee(0x358)]['call'](this,_0x3b5011);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x27f)]=function(){const _0x3026af=_0x19f7cd;if(this['checkCacheKey']('passiveStates'))return this['convertPassiveStates']();if(this[_0x3026af(0x1e2)])return[];return this['_checkingVisuMzPassiveStateObjects']=!![],this[_0x3026af(0x190)](),this[_0x3026af(0x1e2)]=undefined,this[_0x3026af(0x2df)]();},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x190)]=function(){const _0x394634=_0x19f7cd;this[_0x394634(0x1e2)]=!![],this['_cache'][_0x394634(0x27f)]=[],this[_0x394634(0x445)](),this[_0x394634(0x36c)](),this['addPassiveStatesByPluginParameters'](),this[_0x394634(0x458)][_0x394634(0x27f)]=this[_0x394634(0x458)][_0x394634(0x27f)][_0x394634(0x498)]((_0xe396ca,_0x138e27)=>_0xe396ca-_0x138e27),this[_0x394634(0x1e2)]=undefined;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x445)]=function(){const _0x1d7020=_0x19f7cd;if(Imported[_0x1d7020(0x2b8)])this[_0x1d7020(0x27a)]();},Game_BattlerBase['prototype']['passiveStateObjects']=function(){return[];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x36c)]=function(){const _0x54d583=_0x19f7cd,_0x54b458=this['_cache']['passiveStates']||[],_0x5ace38=this['passiveStateObjects']();this['_cache'][_0x54d583(0x27f)]=_0x54b458||[];for(const _0x33e51c of _0x5ace38){if(_0x54d583(0x187)!=='EfDTK'){if(!_0x33e51c)continue;const _0x2bbb95=DataManager[_0x54d583(0x392)](_0x33e51c);for(const _0x437c79 of _0x2bbb95){'zxCvi'===_0x54d583(0x1d9)?this[_0x54d583(0x458)][_0x54d583(0x27f)]['push'](_0x437c79):this[_0x54d583(0x478)](_0x353b9e)&&(_0x2f6257+=this[_0x54d583(0x195)](_0x4fb265),this['setDebuffTurns'](_0x24b6da,_0x1fa36b));}}else{let _0x17e568=_0x5171ec['CalcJS']['call'](this,_0xada7cb);return _0x17e568=this[_0x54d583(0x469)](_0x2c6574,_0x17e568,_0x37aa30),_0x17e568;}}},DataManager['getPassiveStatesFromObj']=function(_0x5cd01b){const _0x50f9b0=_0x19f7cd;if(!_0x5cd01b)return[];const _0x4a716b=VisuMZ[_0x50f9b0(0x21a)][_0x50f9b0(0x40d)](_0x5cd01b,_0x50f9b0(0x269));this['_cache_getPassiveStatesFromObj']=this[_0x50f9b0(0x479)]||{};if(this[_0x50f9b0(0x479)][_0x4a716b]!==undefined)return this[_0x50f9b0(0x479)][_0x4a716b];const _0x15d4cb=[],_0x16f20f=_0x5cd01b[_0x50f9b0(0x1ce)]||'',_0x4a1c40=/<PASSIVE (?:STATE|STATES):[ ](.*)>/gi,_0x38c98a=_0x16f20f[_0x50f9b0(0x138)](_0x4a1c40);if(_0x38c98a)for(const _0x3f2984 of _0x38c98a){if(_0x50f9b0(0x345)!==_0x50f9b0(0x345)){const _0x34265d=_0x3943ec(_0x3e1338['$1'])[_0x50f9b0(0x344)](/[\r\n]+/)[_0x50f9b0(0x466)](_0x417146=>_0x2cb965(_0x417146)[_0x50f9b0(0x3cd)]()[_0x50f9b0(0x467)]());_0x82a5a8=_0x37c1f1['concat'](_0x34265d);}else{_0x3f2984[_0x50f9b0(0x138)](_0x4a1c40);const _0x3a7608=String(RegExp['$1'])[_0x50f9b0(0x344)](',')[_0x50f9b0(0x466)](_0x408c2c=>_0x408c2c[_0x50f9b0(0x467)]());for(const _0x3414bf of _0x3a7608){const _0x18458c=/^\d+$/['test'](_0x3414bf);let _0x17b1bc=0x0;if(_0x18458c){if(_0x50f9b0(0x2ff)!=='JSQZi')return _0x72d28a[_0x50f9b0(0x261)]();else _0x17b1bc=Number(_0x3414bf);}else _0x17b1bc=DataManager[_0x50f9b0(0x314)](_0x3414bf);_0x17b1bc&&('rmixl'!==_0x50f9b0(0x15b)?_0x15d4cb[_0x50f9b0(0x272)](_0x17b1bc):(_0x492249=![],this[_0x50f9b0(0x47d)][_0x14b196]=_0x63d8e7));}}}return this[_0x50f9b0(0x479)][_0x4a716b]=_0x15d4cb,this[_0x50f9b0(0x479)][_0x4a716b];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x471)]=function(){const _0x433ef6=_0x19f7cd,_0x10c05d=VisuMZ[_0x433ef6(0x21a)][_0x433ef6(0x417)]['PassiveStates'][_0x433ef6(0x191)];this[_0x433ef6(0x458)][_0x433ef6(0x27f)]=this['_cache'][_0x433ef6(0x27f)][_0x433ef6(0x2ea)](_0x10c05d);},Game_BattlerBase['prototype'][_0x19f7cd(0x320)]=function(_0x142a01){if(typeof _0x142a01!=='number')_0x142a01=_0x142a01['id'];return this['_stateTurns'][_0x142a01]||0x0;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3ed)]=function(_0x439043,_0xd6b40b){const _0x332347=_0x19f7cd;if(typeof _0x439043!=='number')_0x439043=_0x439043['id'];if(this[_0x332347(0x3b6)](_0x439043)){const _0x1d421e=DataManager[_0x332347(0x1eb)](_0x439043);this[_0x332347(0x3e0)][_0x439043]=_0xd6b40b['clamp'](0x0,_0x1d421e);if(this[_0x332347(0x3e0)][_0x439043]<=0x0)this[_0x332347(0x23d)](_0x439043);}},Game_BattlerBase[_0x19f7cd(0x296)]['addStateTurns']=function(_0x35867a,_0x3faba4){const _0x5332bb=_0x19f7cd;if(typeof _0x35867a!==_0x5332bb(0x46c))_0x35867a=_0x35867a['id'];this[_0x5332bb(0x3b6)](_0x35867a)&&(_0x3faba4+=this[_0x5332bb(0x320)](_0x35867a),this['setStateTurns'](_0x35867a,_0x3faba4));},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x36d)]=Game_BattlerBase[_0x19f7cd(0x296)]['eraseBuff'],Game_BattlerBase[_0x19f7cd(0x296)]['eraseBuff']=function(_0x1723d8){const _0x50fa14=_0x19f7cd,_0xffeafe=this[_0x50fa14(0x365)][_0x1723d8];VisuMZ[_0x50fa14(0x21a)][_0x50fa14(0x36d)][_0x50fa14(0x277)](this,_0x1723d8);if(_0xffeafe>0x0)this[_0x50fa14(0x34b)](_0x1723d8);if(_0xffeafe<0x0)this[_0x50fa14(0x326)](_0x1723d8);},VisuMZ['SkillsStatesCore']['Game_BattlerBase_increaseBuff']=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x429)],Game_BattlerBase['prototype']['increaseBuff']=function(_0x5909a6){const _0x2a5769=_0x19f7cd;VisuMZ[_0x2a5769(0x21a)]['Game_BattlerBase_increaseBuff'][_0x2a5769(0x277)](this,_0x5909a6);if(!this['isBuffOrDebuffAffected'](_0x5909a6))this[_0x2a5769(0x1a9)](_0x5909a6);},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x36e)]=Game_BattlerBase['prototype'][_0x19f7cd(0x2b5)],Game_BattlerBase['prototype'][_0x19f7cd(0x2b5)]=function(_0x1a17cc){const _0x18d60a=_0x19f7cd;VisuMZ[_0x18d60a(0x21a)][_0x18d60a(0x36e)][_0x18d60a(0x277)](this,_0x1a17cc);if(!this[_0x18d60a(0x2e5)](_0x1a17cc))this[_0x18d60a(0x1a9)](_0x1a17cc);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x34b)]=function(_0x1573ef){},Game_BattlerBase['prototype'][_0x19f7cd(0x326)]=function(_0x19f940){},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3d8)]=function(_0x549d81){const _0x252f0f=_0x19f7cd;return this[_0x252f0f(0x365)][_0x549d81]===VisuMZ['SkillsStatesCore'][_0x252f0f(0x417)][_0x252f0f(0x180)][_0x252f0f(0x3d1)];},Game_BattlerBase['prototype'][_0x19f7cd(0x291)]=function(_0x41a519){const _0x4bce89=_0x19f7cd;return this[_0x4bce89(0x365)][_0x41a519]===-VisuMZ[_0x4bce89(0x21a)][_0x4bce89(0x417)][_0x4bce89(0x180)][_0x4bce89(0x1b0)];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1ee)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1f8)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1f8)]=function(_0x4ce833,_0xde50da){const _0xc2fee5=_0x19f7cd;return _0x4ce833=_0x4ce833[_0xc2fee5(0x154)](-0x2,0x2),VisuMZ['SkillsStatesCore'][_0xc2fee5(0x1ee)][_0xc2fee5(0x277)](this,_0x4ce833,_0xde50da);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x178)]=function(_0x45ff61){const _0x582196=_0x19f7cd,_0x154aff=this[_0x582196(0x365)][_0x45ff61];return VisuMZ[_0x582196(0x21a)][_0x582196(0x417)][_0x582196(0x180)][_0x582196(0x477)][_0x582196(0x277)](this,_0x45ff61,_0x154aff);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x195)]=function(_0x41f7fe){const _0x388dfb=_0x19f7cd;return this[_0x388dfb(0x179)][_0x41f7fe]||0x0;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x15f)]=function(_0x43beb4){const _0x2d1ee6=_0x19f7cd;return this[_0x2d1ee6(0x195)](_0x43beb4);},Game_BattlerBase['prototype']['setBuffTurns']=function(_0x7e49d8,_0x2b6eba){const _0xe4ad10=_0x19f7cd;if(this[_0xe4ad10(0x232)](_0x7e49d8)){const _0x4810a4=VisuMZ[_0xe4ad10(0x21a)][_0xe4ad10(0x417)]['Buffs'][_0xe4ad10(0x451)];this[_0xe4ad10(0x179)][_0x7e49d8]=_0x2b6eba[_0xe4ad10(0x154)](0x0,_0x4810a4);}},Game_BattlerBase[_0x19f7cd(0x296)]['addBuffTurns']=function(_0x3bea4c,_0x2bdddd){const _0x174dd9=_0x19f7cd;this[_0x174dd9(0x232)](_0x3bea4c)&&(_0x2bdddd+=this[_0x174dd9(0x195)](stateId),this[_0x174dd9(0x1b1)](_0x3bea4c,_0x2bdddd));},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1e9)]=function(_0x2092b1,_0x242a3b){const _0x273bda=_0x19f7cd;if(this['isDebuffAffected'](_0x2092b1)){const _0x22558a=VisuMZ[_0x273bda(0x21a)][_0x273bda(0x417)][_0x273bda(0x180)]['MaxTurns'];this[_0x273bda(0x179)][_0x2092b1]=_0x242a3b['clamp'](0x0,_0x22558a);}},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x315)]=function(_0x4572cf,_0x2909d5){const _0x19bb38=_0x19f7cd;if(this[_0x19bb38(0x478)](_0x4572cf)){if(_0x19bb38(0x27d)==='XmDTo')return _0x43ce56[_0x19bb38(0x3d5)]&&_0x4391c5[_0x19bb38(0x296)][_0x19bb38(0x274)][_0x19bb38(0x277)](this);else _0x2909d5+=this[_0x19bb38(0x195)](stateId),this[_0x19bb38(0x1e9)](_0x4572cf,_0x2909d5);}},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1ec)]=function(_0x1e5088){const _0x195a82=_0x19f7cd;if(typeof _0x1e5088!=='number')_0x1e5088=_0x1e5088['id'];return this[_0x195a82(0x16e)]=this[_0x195a82(0x16e)]||{},this[_0x195a82(0x16e)][_0x1e5088]=this['_stateData'][_0x1e5088]||{},this[_0x195a82(0x16e)][_0x1e5088];},Game_BattlerBase['prototype'][_0x19f7cd(0x23f)]=function(_0x332da0,_0x4cad29){const _0x66e985=_0x19f7cd;if(typeof _0x332da0!==_0x66e985(0x46c))_0x332da0=_0x332da0['id'];const _0x471832=this[_0x66e985(0x1ec)](_0x332da0);return _0x471832[_0x4cad29];},Game_BattlerBase[_0x19f7cd(0x296)]['setStateData']=function(_0x380134,_0x444683,_0x8d64f0){if(typeof _0x380134!=='number')_0x380134=_0x380134['id'];const _0x556bea=this['stateData'](_0x380134);_0x556bea[_0x444683]=_0x8d64f0;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x30c)]=function(_0x28b83b){const _0x210840=_0x19f7cd;if(typeof _0x28b83b!==_0x210840(0x46c))_0x28b83b=_0x28b83b['id'];this[_0x210840(0x16e)]=this[_0x210840(0x16e)]||{},this[_0x210840(0x16e)][_0x28b83b]={};},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x22f)]=function(_0x3e8730){const _0x50bba3=_0x19f7cd;if(typeof _0x3e8730!==_0x50bba3(0x46c))_0x3e8730=_0x3e8730['id'];return this[_0x50bba3(0x431)]=this[_0x50bba3(0x431)]||{},this[_0x50bba3(0x431)][_0x3e8730]===undefined&&(this[_0x50bba3(0x431)][_0x3e8730]=''),this[_0x50bba3(0x431)][_0x3e8730];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x33a)]=function(_0x416ca7,_0x5cf89b){const _0xcb3b1d=_0x19f7cd;if(typeof _0x416ca7!=='number')_0x416ca7=_0x416ca7['id'];this[_0xcb3b1d(0x431)]=this[_0xcb3b1d(0x431)]||{},this[_0xcb3b1d(0x431)][_0x416ca7]=_0x5cf89b;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x220)]=function(_0x20a6f8){const _0x6346b7=_0x19f7cd;if(typeof _0x20a6f8!==_0x6346b7(0x46c))_0x20a6f8=_0x20a6f8['id'];this[_0x6346b7(0x431)]=this[_0x6346b7(0x431)]||{},this[_0x6346b7(0x431)][_0x20a6f8]='';},Game_BattlerBase['prototype'][_0x19f7cd(0x370)]=function(_0x4a9687){const _0x274948=_0x19f7cd;if(typeof _0x4a9687!=='number')_0x4a9687=_0x4a9687['id'];this[_0x274948(0x46e)]=this[_0x274948(0x46e)]||{},this[_0x274948(0x46e)][_0x4a9687]=this['_stateOrigin'][_0x4a9687]||_0x274948(0x1da);const _0x3a1a56=this['_stateOrigin'][_0x4a9687];return this[_0x274948(0x2d1)](_0x3a1a56);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x3b3)]=function(_0x4e7e0c,_0x20ceaf){const _0x268933=_0x19f7cd;this[_0x268933(0x46e)]=this['_stateOrigin']||{};const _0x232e12=_0x20ceaf?this[_0x268933(0x1fd)](_0x20ceaf):this[_0x268933(0x27c)]();this[_0x268933(0x46e)][_0x4e7e0c]=_0x232e12;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x30b)]=function(_0x5f0d2d){const _0x97c33b=_0x19f7cd;this[_0x97c33b(0x46e)]=this['_stateOrigin']||{},delete this['_stateOrigin'][_0x5f0d2d];},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x301)]=function(){const _0x48a526=_0x19f7cd;this[_0x48a526(0x46e)]={};},Game_BattlerBase['prototype'][_0x19f7cd(0x27c)]=function(){const _0x59f873=_0x19f7cd,_0xf2ea79=this[_0x59f873(0x1fe)]();return this[_0x59f873(0x1fd)](_0xf2ea79);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1fe)]=function(){const _0x2de2af=_0x19f7cd;if($gameParty[_0x2de2af(0x3d7)]()){if('XIUwP'!==_0x2de2af(0x307)){if(BattleManager[_0x2de2af(0x355)])return BattleManager[_0x2de2af(0x355)];else{if(BattleManager[_0x2de2af(0x3af)])return BattleManager[_0x2de2af(0x3af)];}}else _0x5b8868=_0x2e7221(_0x597a9a['$1']),_0x147d2e=_0x438bb7(_0x5620c1['$2']);}else{if(_0x2de2af(0x40f)===_0x2de2af(0x40f)){const _0x177cbb=SceneManager['_scene'];if(![Scene_Map,Scene_Item][_0x2de2af(0x3c5)](_0x177cbb['constructor']))return $gameParty[_0x2de2af(0x422)]();}else{const _0xfeebf8=_0x243c9c(_0x311d3a['$1']),_0x156fe7=_0x324039[_0x2de2af(0x29a)](_0xfeebf8);_0x2ae0a7[_0x2de2af(0x21a)][_0x2de2af(0x19f)][_0x4b2a1f['id']]=new _0x49f4d8('stateId',_0x156fe7);}}return this;},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1fd)]=function(_0x1d4af9){const _0x4ed8ee=_0x19f7cd;if(!_0x1d4af9)return'user';if(_0x1d4af9['isActor']())return _0x4ed8ee(0x163)[_0x4ed8ee(0x29a)](_0x1d4af9[_0x4ed8ee(0x2c7)]());else{if(_0x4ed8ee(0x34a)==='TrHmv')this[_0x4ed8ee(0x1e2)]=!![],this[_0x4ed8ee(0x458)][_0x4ed8ee(0x27f)]=[],this[_0x4ed8ee(0x445)](),this[_0x4ed8ee(0x36c)](),this[_0x4ed8ee(0x471)](),this[_0x4ed8ee(0x458)][_0x4ed8ee(0x27f)]=this[_0x4ed8ee(0x458)][_0x4ed8ee(0x27f)]['sort']((_0x2bb6ca,_0x10d134)=>_0x2bb6ca-_0x10d134),this[_0x4ed8ee(0x1e2)]=_0x433e18;else{const _0x538a85=_0x4ed8ee(0x2c3)[_0x4ed8ee(0x29a)](_0x1d4af9[_0x4ed8ee(0x18d)]()),_0x599f96=_0x4ed8ee(0x398)[_0x4ed8ee(0x29a)](_0x1d4af9['index']()),_0x1484d1=_0x4ed8ee(0x29e)[_0x4ed8ee(0x29a)]($gameTroop[_0x4ed8ee(0x2d8)]());return _0x4ed8ee(0x3bf)[_0x4ed8ee(0x29a)](_0x538a85,_0x599f96,_0x1484d1);}}return _0x4ed8ee(0x1da);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x2d1)]=function(_0x55f871){const _0x5293c0=_0x19f7cd;if(_0x55f871===_0x5293c0(0x1da)){if(_0x5293c0(0x36a)===_0x5293c0(0x36a))return this;else for(const _0x3ad4ba of _0x339564){_0x3ad4ba[_0x5293c0(0x138)](/<(.*)[ ]BUFF TURNS:[ ]([\+\-]\d+)>/i);const _0x354778=_0x27355e[_0x5293c0(0x32c)](_0x5cebc9(_0x24ddc5['$1'])[_0x5293c0(0x3cd)]()),_0x2f1cc0=_0x565760(_0x74d777['$2']);_0x354778>=0x0&&(_0x31ea57[_0x5293c0(0x3e1)](_0x354778,_0x2f1cc0),this[_0x5293c0(0x141)](_0x28cf0e));}}else{if(_0x55f871[_0x5293c0(0x138)](/<actor-(\d+)>/i))return $gameActors[_0x5293c0(0x16c)](Number(RegExp['$1']));else{if($gameParty[_0x5293c0(0x3d7)]()&&_0x55f871[_0x5293c0(0x138)](/<troop-(\d+)>/i)){const _0x5a7999=Number(RegExp['$1']);if(_0x5a7999===$gameTroop[_0x5293c0(0x2d8)]()){if(_0x55f871['match'](/<member-(\d+)>/i))return $gameTroop[_0x5293c0(0x2b0)]()[Number(RegExp['$1'])];}}if(_0x55f871[_0x5293c0(0x138)](/<enemy-(\d+)>/i))return new Game_Enemy(Number(RegExp['$1']),-0x1f4,-0x1f4);}}return this;},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x3ef)]=Game_Battler[_0x19f7cd(0x296)]['addState'],Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x3b4)]=function(_0x15aab9){const _0x1ed6cd=_0x19f7cd,_0xe8b685=this[_0x1ed6cd(0x2c9)](_0x15aab9);VisuMZ['SkillsStatesCore'][_0x1ed6cd(0x3ef)][_0x1ed6cd(0x277)](this,_0x15aab9);if(_0xe8b685&&this['hasState']($dataStates[_0x15aab9])){if('tCHnI'!=='ouURt'){this[_0x1ed6cd(0x2ee)](_0x15aab9);;}else return _0x5b43bd[_0x1ed6cd(0x1cb)](_0x3a68de)[_0x1ed6cd(0x3c5)](this[_0x1ed6cd(0x209)]);}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x483)]=Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2c9)],Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2c9)]=function(_0x9ea591){const _0x22e013=_0x19f7cd,_0x4cedee=$dataStates[_0x9ea591];if(_0x4cedee&&_0x4cedee[_0x22e013(0x1ce)][_0x22e013(0x138)](/<NO DEATH CLEAR>/i))return!this[_0x22e013(0x333)](_0x9ea591)&&!this[_0x22e013(0x3a6)](_0x9ea591)&&!this['_result']['isStateRemoved'](_0x9ea591);return VisuMZ[_0x22e013(0x21a)]['Game_Battler_isStateAddable']['call'](this,_0x9ea591);},Game_Battler['prototype'][_0x19f7cd(0x2ee)]=function(_0x50db8d){const _0x117b57=_0x19f7cd;this['setStateOrigin'](_0x50db8d),this[_0x117b57(0x257)](_0x50db8d),this['onAddStateMakeCustomSlipValues'](_0x50db8d),this[_0x117b57(0x349)](_0x50db8d),this[_0x117b57(0x155)](_0x50db8d);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x41a)]=function(_0x3ad559){const _0x29882a=_0x19f7cd;this[_0x29882a(0x23e)](_0x3ad559),this[_0x29882a(0x3a9)](_0x3ad559),Game_BattlerBase[_0x29882a(0x296)][_0x29882a(0x41a)]['call'](this,_0x3ad559);},Game_Battler[_0x19f7cd(0x296)]['removeStatesAuto']=function(_0x34c63d){const _0x15a95b=_0x19f7cd;for(const _0x77f1bd of this['states']()){this['isStateExpired'](_0x77f1bd['id'])&&_0x77f1bd[_0x15a95b(0x424)]===_0x34c63d&&(this[_0x15a95b(0x23d)](_0x77f1bd['id']),this[_0x15a95b(0x375)](_0x77f1bd['id']),this[_0x15a95b(0x233)](_0x77f1bd['id']));}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x375)]=function(_0x1a16b7){const _0x488d09=_0x19f7cd;this[_0x488d09(0x42e)](_0x1a16b7);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x349)]=function(_0x15a107){const _0x8aa652=_0x19f7cd;if(this[_0x8aa652(0x1b9)]||this['_tempBattler'])return;const _0x801552=VisuMZ[_0x8aa652(0x21a)][_0x8aa652(0x470)];if(_0x801552[_0x15a107])_0x801552[_0x15a107]['call'](this,_0x15a107);},Game_Battler['prototype']['onEraseStateCustomJS']=function(_0x4d2193){const _0x16c415=_0x19f7cd;if(this[_0x16c415(0x1b9)]||this[_0x16c415(0x236)])return;const _0x415aa2=VisuMZ['SkillsStatesCore'][_0x16c415(0x33f)];if(_0x415aa2[_0x4d2193])_0x415aa2[_0x4d2193][_0x16c415(0x277)](this,_0x4d2193);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x42e)]=function(_0x3f7432){const _0x53b13c=_0x19f7cd;if(this[_0x53b13c(0x1b9)]||this[_0x53b13c(0x236)])return;const _0x114cd9=VisuMZ[_0x53b13c(0x21a)][_0x53b13c(0x19f)];if(_0x114cd9[_0x3f7432])_0x114cd9[_0x3f7432][_0x53b13c(0x277)](this,_0x3f7432);},Game_Battler[_0x19f7cd(0x296)]['onAddStateGlobalJS']=function(_0x157521){const _0x529e80=_0x19f7cd;if(this[_0x529e80(0x1b9)]||this['_tempBattler'])return;try{VisuMZ[_0x529e80(0x21a)][_0x529e80(0x417)][_0x529e80(0x32e)][_0x529e80(0x472)][_0x529e80(0x277)](this,_0x157521);}catch(_0x133f56){if($gameTemp[_0x529e80(0x405)]())console[_0x529e80(0x258)](_0x133f56);}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x3a9)]=function(_0x304d00){const _0x3d7f31=_0x19f7cd;if(this[_0x3d7f31(0x1b9)]||this[_0x3d7f31(0x236)])return;try{if(_0x3d7f31(0x480)===_0x3d7f31(0x1b8)){const _0x5188b9=_0x56a57d[_0x3d7f31(0x256)]('['+_0x22f2c7['$1']['match'](/\d+/g)+']');for(const _0x5db17a of _0x5188b9){if(_0x312849[_0x3d7f31(0x151)](_0x5db17a))return!![];}return![];}else VisuMZ['SkillsStatesCore'][_0x3d7f31(0x417)][_0x3d7f31(0x32e)][_0x3d7f31(0x317)]['call'](this,_0x304d00);}catch(_0x28b590){if($gameTemp['isPlaytest']())console[_0x3d7f31(0x258)](_0x28b590);}},Game_Battler[_0x19f7cd(0x296)]['onExpireStateGlobalJS']=function(_0x5d52f3){const _0x14fcf9=_0x19f7cd;if(this[_0x14fcf9(0x1b9)]||this[_0x14fcf9(0x236)])return;try{VisuMZ[_0x14fcf9(0x21a)][_0x14fcf9(0x417)]['States'][_0x14fcf9(0x46d)][_0x14fcf9(0x277)](this,_0x5d52f3);}catch(_0x35702b){if($gameTemp[_0x14fcf9(0x405)]())console['log'](_0x35702b);}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x295)]=function(_0x8beabf){const _0x491c56=_0x19f7cd;return _0x8beabf=_0x8beabf[_0x491c56(0x3cd)]()[_0x491c56(0x467)](),this['states']()[_0x491c56(0x3ab)](_0x56da38=>_0x56da38[_0x491c56(0x3e7)][_0x491c56(0x3c5)](_0x8beabf));},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x3eb)]=function(_0x20b352,_0x921a4){const _0xd59357=_0x19f7cd;_0x20b352=_0x20b352['toUpperCase']()[_0xd59357(0x467)](),_0x921a4=_0x921a4||0x0;const _0x213ddf=this[_0xd59357(0x295)](_0x20b352),_0x570f98=[];for(const _0x59b8e8 of _0x213ddf){if(!_0x59b8e8)continue;if(_0x921a4<=0x0)break;_0x570f98[_0xd59357(0x272)](_0x59b8e8['id']),this[_0xd59357(0x248)][_0xd59357(0x23b)]=!![],_0x921a4--;}while(_0x570f98[_0xd59357(0x313)]>0x0){this['removeState'](_0x570f98[_0xd59357(0x217)]());}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2a5)]=function(_0xafce0f,_0x18adf8){const _0xd677bb=_0x19f7cd;_0xafce0f=_0xafce0f[_0xd677bb(0x3cd)]()[_0xd677bb(0x467)](),_0x18adf8=_0x18adf8||[];const _0x483659=this[_0xd677bb(0x295)](_0xafce0f),_0x1dd182=[];for(const _0x4a08df of _0x483659){if(!_0x4a08df)continue;if(_0x18adf8[_0xd677bb(0x3c5)](_0x4a08df))continue;_0x1dd182[_0xd677bb(0x272)](_0x4a08df['id']),this[_0xd677bb(0x248)][_0xd677bb(0x23b)]=!![];}while(_0x1dd182[_0xd677bb(0x313)]>0x0){this[_0xd677bb(0x23d)](_0x1dd182[_0xd677bb(0x217)]());}},Game_Battler[_0x19f7cd(0x296)]['isStateCategoryAffected']=function(_0x5a3a06){return this['totalStateCategoryAffected'](_0x5a3a06)>0x0;},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x3b5)]=function(_0x238a1e){const _0x57e3b0=_0x19f7cd;return this[_0x57e3b0(0x145)](_0x238a1e)>0x0;},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x26c)]=function(_0x3a52d8){const _0x854b4a=_0x19f7cd,_0x33ebef=this[_0x854b4a(0x295)](_0x3a52d8)[_0x854b4a(0x3ab)](_0x230927=>this[_0x854b4a(0x3b6)](_0x230927['id']));return _0x33ebef[_0x854b4a(0x313)];},Game_Battler[_0x19f7cd(0x296)]['totalStateCategory']=function(_0x81a2e4){const _0x42518f=_0x19f7cd,_0x3200e3=this[_0x42518f(0x295)](_0x81a2e4);return _0x3200e3[_0x42518f(0x313)];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x3ae)]=Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x333)],Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x333)]=function(_0x5c4b39){const _0x13930c=_0x19f7cd,_0x4f84e1=$dataStates[_0x5c4b39];if(_0x4f84e1&&_0x4f84e1[_0x13930c(0x3e7)]['length']>0x0){if('yflTL'===_0x13930c(0x131))return _0x1ecd5e[_0x13930c(0x21a)]['Settings'][_0x13930c(0x270)][_0x13930c(0x164)];else for(const _0x4691d5 of _0x4f84e1[_0x13930c(0x3e7)]){if(this[_0x13930c(0x1a6)](_0x4691d5))return!![];}}return VisuMZ[_0x13930c(0x21a)]['Game_BattlerBase_isStateResist'][_0x13930c(0x277)](this,_0x5c4b39);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x1a6)]=function(_0x4d600d){const _0x3cceb7=_0x19f7cd;let _0x2fcfc7=_0x3cceb7(0x3aa);if(this['checkCacheKey'](_0x2fcfc7))return this[_0x3cceb7(0x458)][_0x2fcfc7][_0x3cceb7(0x3c5)](_0x4d600d);return this[_0x3cceb7(0x458)][_0x2fcfc7]=this[_0x3cceb7(0x25b)](),this[_0x3cceb7(0x458)][_0x2fcfc7][_0x3cceb7(0x3c5)](_0x4d600d);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x25b)]=function(){const _0x59ea12=_0x19f7cd,_0x2ef86d=/<RESIST STATE (?:CATEGORY|CATEGORIES):[ ](.*)>/gi,_0x214381=/<RESIST STATE (?:CATEGORY|CATEGORIES)>\s*([\s\S]*)\s*<\/RESIST STATE (?:CATEGORY|CATEGORIES)>/i;let _0x305f46=[];for(const _0x4d1adb of this[_0x59ea12(0x3d2)]()){if(!_0x4d1adb)continue;const _0x3694d5=_0x4d1adb[_0x59ea12(0x1ce)],_0xe18d05=_0x3694d5[_0x59ea12(0x138)](_0x2ef86d);if(_0xe18d05){if(_0x59ea12(0x310)===_0x59ea12(0x310))for(const _0xa06a45 of _0xe18d05){_0xa06a45[_0x59ea12(0x138)](_0x2ef86d);const _0x207572=String(RegExp['$1'])[_0x59ea12(0x344)](',')[_0x59ea12(0x466)](_0x474127=>String(_0x474127)[_0x59ea12(0x3cd)]()['trim']());_0x305f46=_0x305f46['concat'](_0x207572);}else{this[_0x59ea12(0x3ec)]=this[_0x59ea12(0x3ec)]||{};if(this[_0x59ea12(0x3ec)][_0x1c2d0c['id']])return this[_0x59ea12(0x3ec)][_0x29c5f9['id']];this[_0x59ea12(0x3ec)][_0xb4480a['id']]=[_0x363b3d[_0x59ea12(0x40e)]];if(_0x2324b7[_0x59ea12(0x1ce)][_0x59ea12(0x138)](/<SKILL[ ](?:TYPE|TYPES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x216d63=_0x27da64['parse']('['+_0x227649['$1'][_0x59ea12(0x138)](/\d+/g)+']');this['_stypeIDs'][_0x399d21['id']]=this[_0x59ea12(0x3ec)][_0x1fafd1['id']][_0x59ea12(0x2ea)](_0x216d63);}else{if(_0x31ed60['note'][_0x59ea12(0x138)](/<SKILL[ ](?:TYPE|TYPES):[ ](.*)>/i)){const _0x371c5c=_0x15fe4f['$1'][_0x59ea12(0x344)](',');for(const _0x3f6c0d of _0x371c5c){const _0x5667b8=_0x28edc0[_0x59ea12(0x463)](_0x3f6c0d);if(_0x5667b8)this['_stypeIDs'][_0x129a48['id']][_0x59ea12(0x272)](_0x5667b8);}}}return this[_0x59ea12(0x3ec)][_0x2aad7b['id']];}}if(_0x3694d5[_0x59ea12(0x138)](_0x214381)){const _0x37d642=String(RegExp['$1'])[_0x59ea12(0x344)](/[\r\n]+/)[_0x59ea12(0x466)](_0x43bbb6=>String(_0x43bbb6)[_0x59ea12(0x3cd)]()[_0x59ea12(0x467)]());_0x305f46=_0x305f46[_0x59ea12(0x2ea)](_0x37d642);}}return _0x305f46;},Game_BattlerBase[_0x19f7cd(0x296)]['removeOtherStatesOfSameCategory']=function(_0x499711){const _0x534036=_0x19f7cd,_0x17efd2=$dataStates[_0x499711];if(!_0x17efd2)return;const _0x47336c=_0x17efd2[_0x534036(0x1ce)]||'',_0x1027b9=_0x47336c[_0x534036(0x138)](/<REMOVE OTHER (.*) STATES>/gi);if(_0x1027b9){if(_0x534036(0x2af)===_0x534036(0x143)){const _0x168d7b=0x0,_0x947f2f=this[_0x534036(0x321)](),_0x4d254b=_0x126988[_0x534036(0x22b)],_0xe98d1e=this[_0x534036(0x160)]();return new _0x4f067e(_0x168d7b,_0x947f2f,_0x4d254b,_0xe98d1e);}else{const _0x103d68=[_0x17efd2];for(const _0x4f9d51 of _0x1027b9){if(_0x534036(0x2bf)==='dqRBS'){_0x4f9d51[_0x534036(0x138)](/<REMOVE OTHER (.*) STATES>/i);const _0x4ecd53=String(RegExp['$1']);this['removeStatesByCategoryAll'](_0x4ecd53,_0x103d68);}else return _0x782b50[_0x534036(0x3af)];}}}},VisuMZ[_0x19f7cd(0x21a)]['Game_Battler_addBuff']=Game_Battler[_0x19f7cd(0x296)]['addBuff'],Game_Battler['prototype']['addBuff']=function(_0x2bd928,_0x1f78f9){const _0x330aea=_0x19f7cd;VisuMZ[_0x330aea(0x21a)][_0x330aea(0x2ab)]['call'](this,_0x2bd928,_0x1f78f9);if(this['isBuffAffected'](_0x2bd928)){if(_0x330aea(0x1f0)==='ZFrQt'){const _0x1c431c=this[_0x330aea(0x376)](_0xb563cd,_0x394141),_0x24b4aa=this[_0x330aea(0x235)](_0x1c431c,_0x18f67d,_0x2b3ed4,_0x230eab),_0xb0ee1c=_0xe44a6a+_0x3a0751-_0x24b4aa[_0x330aea(0x2b1)];this[_0x330aea(0x192)](_0x1c431c,_0xb0ee1c,_0x4c7b31,_0x4ad51b),this['resetFontSettings']();}else this[_0x330aea(0x2fe)](_0x2bd928,_0x1f78f9);}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x33d)]=function(_0x410f60){},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x448)]=Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2ce)],Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2ce)]=function(_0x2a02f0,_0x6aa6f9){const _0x56e71f=_0x19f7cd;VisuMZ[_0x56e71f(0x21a)][_0x56e71f(0x448)]['call'](this,_0x2a02f0,_0x6aa6f9),this[_0x56e71f(0x478)](_0x2a02f0)&&this[_0x56e71f(0x26e)](_0x2a02f0,_0x6aa6f9);},Game_Battler['prototype'][_0x19f7cd(0x2a9)]=function(){const _0x3afcbd=_0x19f7cd;for(let _0x1e7da2=0x0;_0x1e7da2<this[_0x3afcbd(0x25a)]();_0x1e7da2++){if(this[_0x3afcbd(0x39f)](_0x1e7da2)){if(_0x3afcbd(0x3f8)!==_0x3afcbd(0x3f8)){if(typeof _0x12fdf1!==_0x3afcbd(0x46c))_0x2de734=_0xcb5919['id'];return this['_stateDisplay']=this[_0x3afcbd(0x431)]||{},this[_0x3afcbd(0x431)][_0x7abb1e]===_0x1da347&&(this['_stateDisplay'][_0x4af592]=''),this[_0x3afcbd(0x431)][_0x2c15c4];}else{const _0x2506f4=this[_0x3afcbd(0x365)][_0x1e7da2];this[_0x3afcbd(0x44a)](_0x1e7da2);if(_0x2506f4>0x0)this[_0x3afcbd(0x1f7)](_0x1e7da2);if(_0x2506f4<0x0)this[_0x3afcbd(0x438)](_0x1e7da2);}}}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2fe)]=function(_0x1814cb,_0x5bda6b){const _0x1227d1=_0x19f7cd;this[_0x1227d1(0x226)](_0x1814cb,_0x5bda6b);},Game_Battler[_0x19f7cd(0x296)]['onAddDebuff']=function(_0x4ec618,_0x5e82d4){const _0x4df229=_0x19f7cd;this[_0x4df229(0x3d6)](_0x4ec618,_0x5e82d4);},Game_Battler['prototype'][_0x19f7cd(0x34b)]=function(_0x22f733){const _0x20f710=_0x19f7cd;Game_BattlerBase[_0x20f710(0x296)][_0x20f710(0x34b)][_0x20f710(0x277)](this,_0x22f733),this[_0x20f710(0x410)](_0x22f733);},Game_Battler['prototype'][_0x19f7cd(0x326)]=function(_0x71a864){const _0x50e70d=_0x19f7cd;Game_BattlerBase['prototype'][_0x50e70d(0x326)][_0x50e70d(0x277)](this,_0x71a864),this[_0x50e70d(0x2d3)](_0x71a864);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x1f7)]=function(_0x22d4fa){const _0x2f7593=_0x19f7cd;this[_0x2f7593(0x1dd)](_0x22d4fa);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x438)]=function(_0x18e3ab){const _0x10eee8=_0x19f7cd;this[_0x10eee8(0x3a0)](_0x18e3ab);},Game_Battler['prototype'][_0x19f7cd(0x226)]=function(_0x397aa2,_0x1fc643){const _0xb3d946=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0xb3d946(0x417)][_0xb3d946(0x180)]['onAddBuffJS']['call'](this,_0x397aa2,_0x1fc643);},Game_Battler['prototype'][_0x19f7cd(0x3d6)]=function(_0x51eed8,_0x3dde65){const _0x30c763=_0x19f7cd;VisuMZ[_0x30c763(0x21a)][_0x30c763(0x417)][_0x30c763(0x180)][_0x30c763(0x2d2)]['call'](this,_0x51eed8,_0x3dde65);},Game_BattlerBase[_0x19f7cd(0x296)][_0x19f7cd(0x410)]=function(_0x5b712f){const _0x530ddd=_0x19f7cd;VisuMZ[_0x530ddd(0x21a)]['Settings'][_0x530ddd(0x180)][_0x530ddd(0x2fd)][_0x530ddd(0x277)](this,_0x5b712f);},Game_BattlerBase[_0x19f7cd(0x296)]['onEraseDebuffGlobalJS']=function(_0x5da414){const _0x2edce3=_0x19f7cd;VisuMZ[_0x2edce3(0x21a)]['Settings'][_0x2edce3(0x180)][_0x2edce3(0x26a)][_0x2edce3(0x277)](this,_0x5da414);},Game_Battler['prototype'][_0x19f7cd(0x1dd)]=function(_0x4d9138){const _0x11ab4c=_0x19f7cd;VisuMZ[_0x11ab4c(0x21a)][_0x11ab4c(0x417)][_0x11ab4c(0x180)][_0x11ab4c(0x181)][_0x11ab4c(0x277)](this,_0x4d9138);},Game_Battler[_0x19f7cd(0x296)]['onExpireDebuffGlobalJS']=function(_0x504ede){const _0x447503=_0x19f7cd;VisuMZ['SkillsStatesCore']['Settings'][_0x447503(0x180)][_0x447503(0x436)][_0x447503(0x277)](this,_0x504ede);},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x1a5)]=function(_0x334500){const _0x37ff1b=_0x19f7cd,_0xcf9470=VisuMZ[_0x37ff1b(0x21a)],_0x31e2d5=[_0x37ff1b(0x1cd),_0x37ff1b(0x433),_0x37ff1b(0x35e),_0x37ff1b(0x1e8),_0x37ff1b(0x1bd),_0x37ff1b(0x271)];for(const _0xe700a5 of _0x31e2d5){if(_0x37ff1b(0x2a4)===_0x37ff1b(0x2a4))_0xcf9470[_0xe700a5][_0x334500]&&_0xcf9470[_0xe700a5][_0x334500][_0x37ff1b(0x277)](this,_0x334500);else{let _0x112e71=_0x3a37be['SkillsStatesCore'][_0x37ff1b(0x250)]['call'](this);return _0x30bfd1[_0x37ff1b(0x149)]&&(_0x112e71=_0x112e71[_0x37ff1b(0x2ea)](this['members']()[_0x37ff1b(0x3ab)](_0x4ba72e=>_0x4ba72e[_0x37ff1b(0x425)]()))),_0x112e71;}}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x2dd)]=Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x395)],Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x395)]=function(){const _0x90327c=_0x19f7cd;this[_0x90327c(0x41f)](),VisuMZ[_0x90327c(0x21a)]['Game_Battler_regenerateAll'][_0x90327c(0x277)](this),this['setPassiveStateSlipDamageJS'](),this[_0x90327c(0x48c)]();},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x210)]=function(){const _0xdb3fc=_0x19f7cd;for(const _0x56f979 of this[_0xdb3fc(0x27f)]()){if(!_0x56f979)continue;this[_0xdb3fc(0x1a5)](_0x56f979['id']);}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x41f)]=function(){const _0x42e5bf=_0x19f7cd;for(const _0x505bb9 of this['states']()){if(_0x42e5bf(0x354)!==_0x42e5bf(0x354))return this['statusWindowRectSkillsStatesCore']();else{if(!_0x505bb9)continue;_0x505bb9[_0x42e5bf(0x1ce)][_0x42e5bf(0x138)](/<JS SLIP REFRESH>/i)&&this[_0x42e5bf(0x1a5)](_0x505bb9['id']);}}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x48c)]=function(){const _0x3999dc=_0x19f7cd;if(!this['isAlive']())return;const _0x1ec434=this[_0x3999dc(0x25d)]();for(const _0x3a7749 of _0x1ec434){if('xjArh'==='XwXmv')return this[_0x3999dc(0x35d)]&&this[_0x3999dc(0x35d)][_0x3999dc(0x364)]?_0x73aeb3['buttonAssistSwitch']:'';else{if(!_0x3a7749)continue;this[_0x3999dc(0x2c8)](_0x3a7749);}}},Game_Battler[_0x19f7cd(0x296)][_0x19f7cd(0x2c8)]=function(_0x3f7658){const _0x5c2210=_0x19f7cd,_0x59319a=this['getStateData'](_0x3f7658['id'],_0x5c2210(0x300))||0x0,_0x1b7abd=-this[_0x5c2210(0x44d)](),_0x1029e7=Math[_0x5c2210(0x1b7)](_0x59319a,_0x1b7abd);if(_0x1029e7!==0x0){const _0x217a36=this['_result'][_0x5c2210(0x3f2)]||0x0;this[_0x5c2210(0x496)](_0x1029e7),this['_result']['hpDamage']+=_0x217a36;}const _0x2c51fe=this[_0x5c2210(0x23f)](_0x3f7658['id'],_0x5c2210(0x2f0))||0x0;if(_0x2c51fe!==0x0){const _0x5ce795=this[_0x5c2210(0x248)][_0x5c2210(0x183)]||0x0;this[_0x5c2210(0x2e9)](_0x2c51fe),this[_0x5c2210(0x248)][_0x5c2210(0x183)]+=_0x5ce795;}const _0x4d9030=this[_0x5c2210(0x23f)](_0x3f7658['id'],_0x5c2210(0x189))||0x0;_0x4d9030!==0x0&&(_0x5c2210(0x2e2)===_0x5c2210(0x2e2)?this[_0x5c2210(0x1c3)](_0x4d9030):(_0x541f90=_0xe947cd['getStateIdWithName'](_0x4998a6['$1']),_0x3467be=_0xaed569(_0x4a8598['$2'])));},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x328)]=Game_Actor['prototype'][_0x19f7cd(0x2a8)],Game_Actor[_0x19f7cd(0x296)]['skillTypes']=function(){const _0x553f50=_0x19f7cd,_0x217cb0=VisuMZ[_0x553f50(0x21a)][_0x553f50(0x328)][_0x553f50(0x277)](this),_0x533c4d=VisuMZ[_0x553f50(0x21a)]['Settings'][_0x553f50(0x270)];let _0x4cbe28=_0x533c4d['HiddenSkillTypes'];return $gameParty[_0x553f50(0x3d7)]()&&(_0x4cbe28=_0x4cbe28[_0x553f50(0x2ea)](_0x533c4d['BattleHiddenSkillTypes'])),_0x217cb0['filter'](_0x1c6b0e=>!_0x4cbe28[_0x553f50(0x3c5)](_0x1c6b0e));},Game_Actor['prototype']['usableSkills']=function(){const _0x404375=_0x19f7cd;return this[_0x404375(0x249)]()[_0x404375(0x3ab)](_0x49e3a6=>this[_0x404375(0x31a)](_0x49e3a6));},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x31a)]=function(_0x47edd9){const _0x706e2a=_0x19f7cd;if(!this[_0x706e2a(0x2fa)](_0x47edd9))return![];if(!_0x47edd9)return![];if(!this[_0x706e2a(0x488)](_0x47edd9))return![];if(this[_0x706e2a(0x1fb)](_0x47edd9))return![];return!![];},Game_Actor[_0x19f7cd(0x296)]['isSkillTypeMatchForUse']=function(_0x193595){const _0x1e5838=_0x19f7cd,_0x364b47=this[_0x1e5838(0x2a8)](),_0x37390b=DataManager['getSkillTypes'](_0x193595),_0x357c5d=_0x364b47[_0x1e5838(0x3ab)](_0x2b202b=>_0x37390b[_0x1e5838(0x3c5)](_0x2b202b));return _0x357c5d[_0x1e5838(0x313)]>0x0;},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x1fb)]=function(_0x2b03ab){const _0x550bca=_0x19f7cd;if(!VisuMZ[_0x550bca(0x21a)][_0x550bca(0x447)](this,_0x2b03ab))return!![];if(!VisuMZ['SkillsStatesCore'][_0x550bca(0x13d)](this,_0x2b03ab))return!![];if(!VisuMZ[_0x550bca(0x21a)][_0x550bca(0x319)](this,_0x2b03ab))return!![];return![];},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x281)]=function(){const _0x4c989e=_0x19f7cd;let _0x1ec4b7=[this[_0x4c989e(0x16c)](),this[_0x4c989e(0x194)]()];_0x1ec4b7=_0x1ec4b7[_0x4c989e(0x2ea)](this[_0x4c989e(0x17e)]()[_0x4c989e(0x3ab)](_0x10b56a=>_0x10b56a));for(const _0x3cf191 of this[_0x4c989e(0x3bd)]){if(_0x4c989e(0x279)!==_0x4c989e(0x2f4)){const _0x478720=$dataSkills[_0x3cf191];if(_0x478720)_0x1ec4b7[_0x4c989e(0x272)](_0x478720);}else _0x19658d[_0x4c989e(0x21a)][_0x4c989e(0x383)][_0x4c989e(0x277)](this,_0x11db03);}return _0x1ec4b7;},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x471)]=function(){const _0x55b257=_0x19f7cd;Game_Battler[_0x55b257(0x296)][_0x55b257(0x471)][_0x55b257(0x277)](this);const _0x41ed8e=VisuMZ[_0x55b257(0x21a)][_0x55b257(0x417)][_0x55b257(0x3cc)]['Actor'];this['_cache'][_0x55b257(0x27f)]=this[_0x55b257(0x458)][_0x55b257(0x27f)][_0x55b257(0x2ea)](_0x41ed8e);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x2d4)]=Game_Actor['prototype'][_0x19f7cd(0x1d4)],Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x1d4)]=function(_0x570574){const _0x540423=_0x19f7cd;VisuMZ[_0x540423(0x21a)][_0x540423(0x2d4)][_0x540423(0x277)](this,_0x570574),this[_0x540423(0x458)]={},this[_0x540423(0x27f)]();},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x252)]=Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x196)],Game_Actor[_0x19f7cd(0x296)]['forgetSkill']=function(_0xddddc0){const _0x3d366e=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x3d366e(0x252)][_0x3d366e(0x277)](this,_0xddddc0),this['_cache']={},this[_0x3d366e(0x27f)]();},Game_Actor[_0x19f7cd(0x296)][_0x19f7cd(0x3fc)]=function(){const _0x55272e=_0x19f7cd;return VisuMZ['SkillsStatesCore'][_0x55272e(0x417)][_0x55272e(0x32e)][_0x55272e(0x363)]??0x14;},Game_Enemy[_0x19f7cd(0x296)][_0x19f7cd(0x281)]=function(){const _0x3232a6=_0x19f7cd;let _0x38053c=[this[_0x3232a6(0x3ac)]()];return _0x38053c['concat'](this[_0x3232a6(0x249)]());},Game_Enemy[_0x19f7cd(0x296)][_0x19f7cd(0x471)]=function(){const _0x1f1ba0=_0x19f7cd;Game_Battler['prototype'][_0x1f1ba0(0x471)][_0x1f1ba0(0x277)](this);const _0x3f518f=VisuMZ[_0x1f1ba0(0x21a)]['Settings']['PassiveStates'][_0x1f1ba0(0x3a4)];this[_0x1f1ba0(0x458)][_0x1f1ba0(0x27f)]=this[_0x1f1ba0(0x458)][_0x1f1ba0(0x27f)][_0x1f1ba0(0x2ea)](_0x3f518f);},Game_Enemy[_0x19f7cd(0x296)][_0x19f7cd(0x249)]=function(){const _0x268ab1=_0x19f7cd,_0x16f5fb=[];for(const _0x4528b1 of this[_0x268ab1(0x3ac)]()[_0x268ab1(0x1f2)]){if('rdqqF'===_0x268ab1(0x44b)){const _0x16b278=_0x47c8d0[_0x268ab1(0x256)]('['+_0x4ae249['$1'][_0x268ab1(0x138)](/\d+/g)+']');for(const _0x320543 of _0x16b278){if(_0xc9dfab[_0x268ab1(0x1f4)](_0x320543))return![];}return!![];}else{const _0x60e970=$dataSkills[_0x4528b1['skillId']];if(_0x60e970&&!_0x16f5fb['includes'](_0x60e970))_0x16f5fb['push'](_0x60e970);}}return _0x16f5fb;},Game_Enemy['prototype'][_0x19f7cd(0x316)]=function(_0xe7a4d4){const _0x25b5ea=_0x19f7cd;return this[_0x25b5ea(0x35f)]($dataStates[_0xe7a4d4]);},VisuMZ[_0x19f7cd(0x21a)]['Game_Unit_isAllDead']=Game_Unit[_0x19f7cd(0x296)][_0x19f7cd(0x31b)],Game_Unit[_0x19f7cd(0x296)][_0x19f7cd(0x31b)]=function(){const _0x2735a6=_0x19f7cd;if(this[_0x2735a6(0x335)]())return!![];return VisuMZ[_0x2735a6(0x21a)]['Game_Unit_isAllDead'][_0x2735a6(0x277)](this);},Game_Unit['prototype'][_0x19f7cd(0x335)]=function(){const _0x2953e6=_0x19f7cd,_0x2f30d6=this[_0x2953e6(0x18c)]();for(const _0x46b873 of _0x2f30d6){if(_0x2953e6(0x27e)===_0x2953e6(0x27e)){if(!_0x46b873[_0x2953e6(0x425)]())return![];}else{if(_0x37f96b[_0x2953e6(0x421)][_0x2953e6(0x3cd)]()==='TP'){let _0xaaf087=_0x4b243b[_0x2953e6(0x24c)]['call'](this,_0x137014);return _0xaaf087=this[_0x2953e6(0x469)](_0x31d107,_0xaaf087,_0x24a0a0),_0xaaf087;}}}return!![];},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x26d)]=Game_Troop[_0x19f7cd(0x296)][_0x19f7cd(0x246)],Game_Troop[_0x19f7cd(0x296)][_0x19f7cd(0x246)]=function(_0x3a9d00){const _0x49fc59=_0x19f7cd;VisuMZ[_0x49fc59(0x21a)]['Game_Troop_setup']['call'](this,_0x3a9d00),this[_0x49fc59(0x475)]();},Game_Troop['prototype'][_0x19f7cd(0x475)]=function(){const _0x58075c=_0x19f7cd;this[_0x58075c(0x42b)]=Graphics[_0x58075c(0x338)];},Game_Troop['prototype'][_0x19f7cd(0x2d8)]=function(){const _0x3a9695=_0x19f7cd;return this[_0x3a9695(0x42b)]=this['_currentTroopUniqueID']||Graphics['frameCount'],this[_0x3a9695(0x42b)];},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x1f9)]=function(){const _0x390b28=_0x19f7cd;if(ConfigManager['uiMenuStyle']&&ConfigManager[_0x390b28(0x399)]!==undefined)return ConfigManager[_0x390b28(0x399)];else{if(this[_0x390b28(0x440)]())return this[_0x390b28(0x3ea)]()[_0x390b28(0x138)](/LOWER/i);else{if(_0x390b28(0x42d)!==_0x390b28(0x42d)){const _0x4eedd5=_0x402740(_0x26222d['$1']);_0x4eedd5<_0x2e130a?(_0x3c85de(_0x390b28(0x2e6)[_0x390b28(0x29a)](_0x47abd6,_0x4eedd5,_0x2d4cbc)),_0x4bb0c9[_0x390b28(0x136)]()):_0x27752e=_0x42d246[_0x390b28(0x1b7)](_0x4eedd5,_0x7f60a2);}else Scene_ItemBase[_0x390b28(0x296)][_0x390b28(0x14c)][_0x390b28(0x277)](this);}}},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x14c)]=function(){const _0x488095=_0x19f7cd;if(ConfigManager[_0x488095(0x32f)]&&ConfigManager['uiInputPosition']!==undefined){if(_0x488095(0x26f)===_0x488095(0x3a3))this[_0x488095(0x331)][_0x488095(0x408)]=_0x25d070['mainFontFace'](),this[_0x488095(0x331)]['fontSize']=_0x51aaab[_0x488095(0x254)](),this[_0x488095(0x21f)]();else return ConfigManager['uiInputPosition'];}else{if(this[_0x488095(0x440)]()){if(_0x488095(0x34d)===_0x488095(0x34d))return this['updatedLayoutStyle']()[_0x488095(0x138)](/RIGHT/i);else _0x33f062[_0x488095(0x21a)][_0x488095(0x252)]['call'](this,_0x290d2c),this['_cache']={},this[_0x488095(0x27f)]();}else return Scene_ItemBase[_0x488095(0x296)]['isRightInputMode'][_0x488095(0x277)](this);}},Scene_Skill[_0x19f7cd(0x296)]['updatedLayoutStyle']=function(){const _0x21524f=_0x19f7cd;return VisuMZ[_0x21524f(0x21a)][_0x21524f(0x417)][_0x21524f(0x270)][_0x21524f(0x22e)];},Scene_Skill['prototype'][_0x19f7cd(0x274)]=function(){const _0x4fdb79=_0x19f7cd;return this[_0x4fdb79(0x340)]&&this[_0x4fdb79(0x340)][_0x4fdb79(0x274)]();},Scene_Skill[_0x19f7cd(0x296)]['isUseSkillsStatesCoreUpdatedLayout']=function(){const _0x4abc89=_0x19f7cd;return VisuMZ[_0x4abc89(0x21a)][_0x4abc89(0x417)][_0x4abc89(0x270)][_0x4abc89(0x3d4)];},VisuMZ[_0x19f7cd(0x21a)]['Scene_Skill_helpWindowRect']=Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x19e)],Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x19e)]=function(){const _0x318b2d=_0x19f7cd;if(this['isUseSkillsStatesCoreUpdatedLayout']()){if('sxidD'!==_0x318b2d(0x26b))return this['helpWindowRectSkillsStatesCore']();else _0x14ef10[_0x318b2d(0x21a)][_0x318b2d(0x19d)]['call'](this,_0x4c2e88),_0x50fcee[_0x318b2d(0x21a)][_0x318b2d(0x386)](_0x14ee3e),_0x23b1b5[_0x318b2d(0x21a)][_0x318b2d(0x45b)](_0x20a6c5),_0x2adc89[_0x318b2d(0x21a)][_0x318b2d(0x327)](_0x3a4ae8),_0x6a6d23[_0x318b2d(0x21a)][_0x318b2d(0x251)](_0x380c5a);}else{if(_0x318b2d(0x309)==='xaGWZ')return VisuMZ[_0x318b2d(0x21a)][_0x318b2d(0x2d9)][_0x318b2d(0x277)](this);else{const _0xdd930b=_0x266f21[_0x318b2d(0x1eb)](_0x718109);this[_0x318b2d(0x3e0)][_0x368740]=this[_0x318b2d(0x3e0)][_0x5cfcfe][_0x318b2d(0x154)](0x0,_0xdd930b);}}},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x44e)]=function(){const _0x478931=_0x19f7cd,_0x10cd47=0x0,_0x372e5c=this['helpAreaTop'](),_0x5c4e55=Graphics[_0x478931(0x22b)],_0x2b0aec=this[_0x478931(0x160)]();return new Rectangle(_0x10cd47,_0x372e5c,_0x5c4e55,_0x2b0aec);},VisuMZ[_0x19f7cd(0x21a)]['Scene_Skill_skillTypeWindowRect']=Scene_Skill[_0x19f7cd(0x296)]['skillTypeWindowRect'],Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x33e)]=function(){const _0x1e9cd7=_0x19f7cd;if(this[_0x1e9cd7(0x440)]()){if(_0x1e9cd7(0x21d)===_0x1e9cd7(0x311))_0x3a8226['addState'](_0x299348);else return this[_0x1e9cd7(0x213)]();}else return VisuMZ[_0x1e9cd7(0x21a)][_0x1e9cd7(0x234)][_0x1e9cd7(0x277)](this);},Scene_Skill[_0x19f7cd(0x296)]['mainCommandWidth']=function(){const _0x35ed47=_0x19f7cd;return VisuMZ['SkillsStatesCore'][_0x35ed47(0x417)][_0x35ed47(0x270)][_0x35ed47(0x35c)]??Scene_MenuBase['prototype'][_0x35ed47(0x373)][_0x35ed47(0x277)](this);},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x213)]=function(){const _0x2931fd=_0x19f7cd,_0xd15465=this['mainCommandWidth'](),_0x4ecca5=this[_0x2931fd(0x487)](0x3,!![]),_0xb70524=this['isRightInputMode']()?Graphics[_0x2931fd(0x22b)]-_0xd15465:0x0,_0x4080d5=this[_0x2931fd(0x3c7)]();return new Rectangle(_0xb70524,_0x4080d5,_0xd15465,_0x4ecca5);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1ac)]=Scene_Skill[_0x19f7cd(0x296)]['statusWindowRect'],Scene_Skill['prototype'][_0x19f7cd(0x35a)]=function(){const _0x46b294=_0x19f7cd;return this['isUseSkillsStatesCoreUpdatedLayout']()?this[_0x46b294(0x1f6)]():VisuMZ[_0x46b294(0x21a)]['Scene_Skill_statusWindowRect'][_0x46b294(0x277)](this);},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x1f6)]=function(){const _0x1f8c74=_0x19f7cd,_0x3a49fb=Graphics[_0x1f8c74(0x22b)]-this['mainCommandWidth'](),_0x437c39=this[_0x1f8c74(0x35d)][_0x1f8c74(0x171)],_0x49ed57=this[_0x1f8c74(0x14c)]()?0x0:Graphics['boxWidth']-_0x3a49fb,_0x34fcfe=this[_0x1f8c74(0x3c7)]();return new Rectangle(_0x49ed57,_0x34fcfe,_0x3a49fb,_0x437c39);},VisuMZ[_0x19f7cd(0x21a)]['Scene_Skill_createItemWindow']=Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x276)],Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x276)]=function(){const _0x5b8d88=_0x19f7cd;VisuMZ[_0x5b8d88(0x21a)]['Scene_Skill_createItemWindow'][_0x5b8d88(0x277)](this),this['allowCreateShopStatusWindow']()&&this['createShopStatusWindow']();},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x2bc)]=Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x48b)],Scene_Skill[_0x19f7cd(0x296)]['itemWindowRect']=function(){const _0x5d8e9b=_0x19f7cd;if(this[_0x5d8e9b(0x440)]())return this[_0x5d8e9b(0x202)]();else{if(_0x5d8e9b(0x1c0)===_0x5d8e9b(0x1c0)){const _0x19d8e2=VisuMZ[_0x5d8e9b(0x21a)]['Scene_Skill_itemWindowRect'][_0x5d8e9b(0x277)](this);if(this[_0x5d8e9b(0x45e)]()&&this[_0x5d8e9b(0x1a7)]()){if(_0x5d8e9b(0x1bb)!==_0x5d8e9b(0x2fc))_0x19d8e2['width']-=this[_0x5d8e9b(0x25f)]();else return this[_0x5d8e9b(0x365)][_0xb3c2bd]===-_0x442acf[_0x5d8e9b(0x21a)][_0x5d8e9b(0x417)]['Buffs'][_0x5d8e9b(0x1b0)];}return _0x19d8e2;}else _0x13bd5b['SkillsStatesCore'][_0x5d8e9b(0x2e1)][_0x5d8e9b(0x277)](this);}},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x202)]=function(){const _0x4d648a=_0x19f7cd,_0x50055a=Graphics[_0x4d648a(0x22b)]-this[_0x4d648a(0x25f)](),_0x5e0f40=this[_0x4d648a(0x18f)]()-this[_0x4d648a(0x1af)]['height'],_0x47e190=this[_0x4d648a(0x14c)]()?Graphics[_0x4d648a(0x22b)]-_0x50055a:0x0,_0x1bf18f=this['_statusWindow']['y']+this[_0x4d648a(0x1af)]['height'];return new Rectangle(_0x47e190,_0x1bf18f,_0x50055a,_0x5e0f40);},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x45e)]=function(){const _0x46816f=_0x19f7cd;if(!Imported[_0x46816f(0x2cb)])return![];else{if(this['isUseSkillsStatesCoreUpdatedLayout']()){if(_0x46816f(0x46b)!=='HffXt')return!![];else _0x20e5c6['categories'][_0x46816f(0x272)](_0x480aa9[_0x46816f(0x3cd)]()[_0x46816f(0x467)]());}else return VisuMZ[_0x46816f(0x21a)][_0x46816f(0x417)][_0x46816f(0x270)][_0x46816f(0x164)];}},Scene_Skill[_0x19f7cd(0x296)]['adjustItemWidthByShopStatus']=function(){const _0x23877f=_0x19f7cd;return VisuMZ[_0x23877f(0x21a)][_0x23877f(0x417)]['Skills'][_0x23877f(0x312)];},Scene_Skill['prototype'][_0x19f7cd(0x241)]=function(){const _0x489147=_0x19f7cd,_0x1ab50f=this[_0x489147(0x1ff)]();this[_0x489147(0x491)]=new Window_ShopStatus(_0x1ab50f),this[_0x489147(0x134)](this[_0x489147(0x491)]),this[_0x489147(0x372)]['setStatusWindow'](this[_0x489147(0x491)]);const _0x59c9eb=VisuMZ['SkillsStatesCore']['Settings'][_0x489147(0x270)]['SkillSceneStatusBgType'];this[_0x489147(0x491)][_0x489147(0x47e)](_0x59c9eb||0x0);},Scene_Skill[_0x19f7cd(0x296)]['shopStatusWindowRect']=function(){const _0x1a7adc=_0x19f7cd;return this['isUseSkillsStatesCoreUpdatedLayout']()?this['shopStatusWindowRectSkillsStatesCore']():VisuMZ['SkillsStatesCore'][_0x1a7adc(0x417)]['Skills'][_0x1a7adc(0x37c)][_0x1a7adc(0x277)](this);},Scene_Skill['prototype']['shopStatusWindowRectSkillsStatesCore']=function(){const _0x43f250=_0x19f7cd,_0x1ae039=this[_0x43f250(0x25f)](),_0x3ab30f=this[_0x43f250(0x372)][_0x43f250(0x171)],_0xbf096a=this['isRightInputMode']()?0x0:Graphics[_0x43f250(0x22b)]-this[_0x43f250(0x25f)](),_0x4a3e39=this['_itemWindow']['y'];return new Rectangle(_0xbf096a,_0x4a3e39,_0x1ae039,_0x3ab30f);},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x25f)]=function(){const _0x26fba6=_0x19f7cd;return Imported[_0x26fba6(0x2cb)]?Scene_Shop['prototype'][_0x26fba6(0x2de)]():0x0;},Scene_Skill[_0x19f7cd(0x296)][_0x19f7cd(0x263)]=function(){const _0xacb2c2=_0x19f7cd;if(this['_skillTypeWindow']&&this[_0xacb2c2(0x35d)][_0xacb2c2(0x364)])return TextManager[_0xacb2c2(0x351)];else{if(_0xacb2c2(0x20b)==='hKVGH'){const _0x5b4e4d=this[_0xacb2c2(0x1fe)]();return this['convertTargetToStateOriginKey'](_0x5b4e4d);}else return'';}},VisuMZ[_0x19f7cd(0x21a)]['Sprite_Gauge_initMembers']=Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x42f)],Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x42f)]=function(){const _0x5d2365=_0x19f7cd;VisuMZ[_0x5d2365(0x21a)][_0x5d2365(0x347)]['call'](this),this[_0x5d2365(0x40c)]=null;},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x2fb)]=Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x246)],Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x246)]=function(_0x9d9343,_0x46df52){const _0xf0cac9=_0x19f7cd;this[_0xf0cac9(0x31c)](_0x9d9343,_0x46df52),_0x46df52=_0x46df52[_0xf0cac9(0x306)](),VisuMZ[_0xf0cac9(0x21a)][_0xf0cac9(0x2fb)][_0xf0cac9(0x277)](this,_0x9d9343,_0x46df52);},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x31c)]=function(_0x4e7501,_0xa44a2d){const _0x4c22ba=_0x19f7cd,_0x7388be=VisuMZ['SkillsStatesCore'][_0x4c22ba(0x417)]['Costs'][_0x4c22ba(0x3ab)](_0x44f8af=>_0x44f8af['Name'][_0x4c22ba(0x3cd)]()===_0xa44a2d[_0x4c22ba(0x3cd)]());_0x7388be[_0x4c22ba(0x313)]>=0x1?this['_costSettings']=_0x7388be[0x0]:this[_0x4c22ba(0x40c)]=null;},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x2cf)]=Sprite_Gauge['prototype'][_0x19f7cd(0x1fc)],Sprite_Gauge[_0x19f7cd(0x296)]['currentValue']=function(){const _0x4a143c=_0x19f7cd;return this[_0x4a143c(0x41b)]&&this['_costSettings']?this[_0x4a143c(0x45a)]():VisuMZ['SkillsStatesCore'][_0x4a143c(0x2cf)]['call'](this);},Sprite_Gauge[_0x19f7cd(0x296)]['currentValueSkillsStatesCore']=function(){const _0x2a6f8e=_0x19f7cd;return this[_0x2a6f8e(0x40c)]['GaugeCurrentJS'][_0x2a6f8e(0x277)](this[_0x2a6f8e(0x41b)]);},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x450)]=Sprite_Gauge[_0x19f7cd(0x296)]['currentMaxValue'],Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x1db)]=function(){const _0x51a9f1=_0x19f7cd;if(this[_0x51a9f1(0x41b)]&&this[_0x51a9f1(0x40c)]){if(_0x51a9f1(0x435)===_0x51a9f1(0x28a))for(const _0x32442a of _0x402a78){_0x32442a[_0x51a9f1(0x138)](_0x5dfc8f);const _0x2f2774=_0x2717d1(_0x1b9f7b['$1'])[_0x51a9f1(0x344)](',')[_0x51a9f1(0x466)](_0x53d497=>_0x518c50(_0x53d497)['toUpperCase']()['trim']());_0x49da69=_0x3d24da[_0x51a9f1(0x2ea)](_0x2f2774);}else return this['currentMaxValueSkillsStatesCore']();}else return VisuMZ[_0x51a9f1(0x21a)]['Sprite_Gauge_currentMaxValue']['call'](this);},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x48a)]=function(){const _0x3786a2=_0x19f7cd;return this['_costSettings'][_0x3786a2(0x229)][_0x3786a2(0x277)](this[_0x3786a2(0x41b)]);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x201)]=Sprite_Gauge[_0x19f7cd(0x296)]['gaugeRate'],Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x3c6)]=function(){const _0x320503=_0x19f7cd,_0x1f2dff=VisuMZ['SkillsStatesCore']['Sprite_Gauge_gaugeRate'][_0x320503(0x277)](this);return _0x1f2dff['clamp'](0x0,0x1);},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x2e1)]=Sprite_Gauge['prototype']['redraw'],Sprite_Gauge[_0x19f7cd(0x296)]['redraw']=function(){const _0x18ba8a=_0x19f7cd;if(this[_0x18ba8a(0x41b)]&&this[_0x18ba8a(0x40c)]){if(_0x18ba8a(0x162)!==_0x18ba8a(0x3e6))this[_0x18ba8a(0x297)][_0x18ba8a(0x485)](),this['redrawSkillsStatesCore']();else{const _0x1abbb4=_0x401688[_0x18ba8a(0x256)]('['+_0x5b7250['$1'][_0x18ba8a(0x138)](/\d+/g)+']');for(const _0x208a14 of _0x1abbb4){if(!_0x19bfb8['value'](_0x208a14))return!![];}return![];}}else VisuMZ[_0x18ba8a(0x21a)]['Sprite_Gauge_redraw'][_0x18ba8a(0x277)](this);},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x46a)]=function(){const _0x421a39=_0x19f7cd;let _0x5ea178=this['currentValue']();if(Imported[_0x421a39(0x3d5)]&&this[_0x421a39(0x13b)]()){if('Abhyf'!==_0x421a39(0x133)){if(!_0xdfca67)return;_0x58bbcc[_0x421a39(0x296)][_0x421a39(0x493)][_0x421a39(0x277)](this,_0x4ef25f,_0x53cb86,_0x439d98,_0x50a747);}else _0x5ea178=VisuMZ['GroupDigits'](_0x5ea178);}return _0x5ea178;},Sprite_Gauge[_0x19f7cd(0x296)]['redrawSkillsStatesCore']=function(){const _0x27cafa=_0x19f7cd;this[_0x27cafa(0x297)][_0x27cafa(0x485)](),this['_costSettings'][_0x27cafa(0x3b9)][_0x27cafa(0x277)](this);},Sprite_Gauge['prototype'][_0x19f7cd(0x2c4)]=function(_0x2703d2,_0x50c0d5,_0x5d2ca2,_0x38642b,_0x522a6b,_0x57d999){const _0xb24761=_0x19f7cd,_0x3c21a5=this[_0xb24761(0x3c6)](),_0x376690=Math[_0xb24761(0x465)]((_0x522a6b-0x2)*_0x3c21a5),_0x5cad83=_0x57d999-0x2,_0x4face1=this[_0xb24761(0x1c8)]();this[_0xb24761(0x297)][_0xb24761(0x20f)](_0x5d2ca2,_0x38642b,_0x522a6b,_0x57d999,_0x4face1),this[_0xb24761(0x297)][_0xb24761(0x30a)](_0x5d2ca2+0x1,_0x38642b+0x1,_0x376690,_0x5cad83,_0x2703d2,_0x50c0d5);},Sprite_Gauge['prototype'][_0x19f7cd(0x427)]=function(){const _0x507e25=_0x19f7cd,_0x50ed57=VisuMZ[_0x507e25(0x21a)][_0x507e25(0x417)][_0x507e25(0x47f)];if(_0x50ed57['LabelFontMainType']===_0x507e25(0x46c)){if('QsDdC'===_0x507e25(0x240))_0x37abd0['prototype'][_0x507e25(0x215)][_0x507e25(0x277)](this,_0x53067b);else return $gameSystem[_0x507e25(0x48f)]();}else return $gameSystem[_0x507e25(0x261)]();},Sprite_Gauge[_0x19f7cd(0x296)]['labelFontSize']=function(){const _0x54f4ac=_0x19f7cd,_0x33913b=VisuMZ[_0x54f4ac(0x21a)][_0x54f4ac(0x417)][_0x54f4ac(0x47f)];return _0x33913b[_0x54f4ac(0x264)]===_0x54f4ac(0x46c)?$gameSystem[_0x54f4ac(0x254)]()-0x6:$gameSystem[_0x54f4ac(0x254)]()-0x2;},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x3c8)]=function(){const _0x4c1688=_0x19f7cd,_0x43add2=VisuMZ[_0x4c1688(0x21a)]['Settings'][_0x4c1688(0x47f)];return _0x43add2[_0x4c1688(0x337)]===_0x4c1688(0x46c)?$gameSystem[_0x4c1688(0x48f)]():$gameSystem[_0x4c1688(0x261)]();},Sprite_Gauge[_0x19f7cd(0x296)]['valueFontSize']=function(){const _0x566a53=_0x19f7cd,_0x2a2289=VisuMZ[_0x566a53(0x21a)][_0x566a53(0x417)][_0x566a53(0x47f)];return _0x2a2289[_0x566a53(0x337)]===_0x566a53(0x46c)?$gameSystem[_0x566a53(0x254)]()-0x6:$gameSystem[_0x566a53(0x254)]()-0x2;},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x166)]=function(){const _0x26ca1e=_0x19f7cd,_0x2f5e55=VisuMZ[_0x26ca1e(0x21a)][_0x26ca1e(0x417)][_0x26ca1e(0x47f)];if(_0x2f5e55['MatchLabelColor']){if(_0x2f5e55['MatchLabelGaugeColor']===0x1){if(_0x26ca1e(0x216)==='smlHi')return this['gaugeColor1']();else{if(_0x4859b8[_0x26ca1e(0x353)](_0x52e487))return![];}}else{if(_0x2f5e55[_0x26ca1e(0x305)]===0x2){if(_0x26ca1e(0x2b6)!=='SZegJ')_0x4d7024[_0x26ca1e(0x397)]=_0x45ca31(_0x523d5a['$1'])['split'](',')[_0x26ca1e(0x466)](_0x37b380=>_0x19ee6c(_0x37b380));else return this[_0x26ca1e(0x43c)]();}}}const _0x509339=_0x2f5e55['PresetLabelGaugeColor'];return ColorManager[_0x26ca1e(0x1cc)](_0x509339);},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x304)]=function(){const _0x22818f=_0x19f7cd,_0x47d24e=VisuMZ['SkillsStatesCore'][_0x22818f(0x417)]['Gauge'];if(this['labelOutlineWidth']()<=0x0)return'rgba(0,\x200,\x200,\x200)';else return _0x47d24e['LabelOutlineSolid']?_0x22818f(0x369):ColorManager[_0x22818f(0x3bb)]();},Sprite_Gauge[_0x19f7cd(0x296)]['labelOutlineWidth']=function(){const _0x343315=_0x19f7cd;return VisuMZ[_0x343315(0x21a)][_0x343315(0x417)][_0x343315(0x47f)]['LabelOutlineWidth']||0x0;},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x2be)]=function(){const _0x392c45=_0x19f7cd,_0x37b523=VisuMZ[_0x392c45(0x21a)][_0x392c45(0x417)]['Gauge'];if(this[_0x392c45(0x24a)]()<=0x0)return'uXPtv'===_0x392c45(0x303)?_0x309c45[_0x392c45(0x254)]()-0x6:_0x392c45(0x41e);else return _0x37b523[_0x392c45(0x168)]?_0x392c45(0x369):ColorManager['outlineColor']();},Sprite_Gauge[_0x19f7cd(0x296)][_0x19f7cd(0x24a)]=function(){const _0xe9b842=_0x19f7cd;return VisuMZ[_0xe9b842(0x21a)][_0xe9b842(0x417)]['Gauge'][_0xe9b842(0x1de)]||0x0;},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x21e)]=Sprite_StateIcon['prototype'][_0x19f7cd(0x198)],Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x198)]=function(){const _0x4ef947=_0x19f7cd;VisuMZ[_0x4ef947(0x21a)][_0x4ef947(0x21e)][_0x4ef947(0x277)](this),this[_0x4ef947(0x46f)]();},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x46f)]=function(){const _0x4f3a99=_0x19f7cd,_0x107052=Window_Base[_0x4f3a99(0x296)]['lineHeight']();this['_turnDisplaySprite']=new Sprite(),this[_0x4f3a99(0x3fb)][_0x4f3a99(0x297)]=new Bitmap(ImageManager[_0x4f3a99(0x2a6)],_0x107052),this[_0x4f3a99(0x3fb)]['anchor']['x']=this[_0x4f3a99(0x25c)]['x'],this[_0x4f3a99(0x3fb)][_0x4f3a99(0x25c)]['y']=this[_0x4f3a99(0x25c)]['y'],this[_0x4f3a99(0x20e)](this[_0x4f3a99(0x3fb)]),this[_0x4f3a99(0x331)]=this[_0x4f3a99(0x3fb)][_0x4f3a99(0x297)];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1ed)]=Sprite_StateIcon[_0x19f7cd(0x296)]['updateFrame'],Sprite_StateIcon[_0x19f7cd(0x296)]['updateFrame']=function(){const _0x103a76=_0x19f7cd;VisuMZ[_0x103a76(0x21a)][_0x103a76(0x1ed)][_0x103a76(0x277)](this),this[_0x103a76(0x3c4)]();},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x223)]=function(_0x3ebb11,_0x44551e,_0x2bf5b6,_0x496c72,_0x1107c8){const _0x4b1b50=_0x19f7cd;this[_0x4b1b50(0x331)][_0x4b1b50(0x223)](_0x3ebb11,_0x44551e,_0x2bf5b6,_0x496c72,this[_0x4b1b50(0x331)]['height'],_0x1107c8);},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x3c4)]=function(){const _0x44fa53=_0x19f7cd;this[_0x44fa53(0x32d)](),this[_0x44fa53(0x331)][_0x44fa53(0x485)]();const _0x1c0cdd=this[_0x44fa53(0x41b)];if(!_0x1c0cdd)return;const _0x443dc0=_0x1c0cdd[_0x44fa53(0x25d)]()['filter'](_0x766472=>_0x766472['iconIndex']>0x0),_0x42ad1e=[...Array(0x8)[_0x44fa53(0x342)]()]['filter'](_0x58781b=>_0x1c0cdd[_0x44fa53(0x323)](_0x58781b)!==0x0),_0x27272e=this[_0x44fa53(0x170)],_0x29d2f3=_0x443dc0[_0x27272e];if(_0x29d2f3)_0x44fa53(0x1df)!=='cPOFH'?(Window_Base[_0x44fa53(0x296)][_0x44fa53(0x47a)][_0x44fa53(0x277)](this,_0x1c0cdd,_0x29d2f3,0x0,0x0),Window_Base[_0x44fa53(0x296)]['drawActorStateData'][_0x44fa53(0x277)](this,_0x1c0cdd,_0x29d2f3,0x0,0x0)):(this[_0x44fa53(0x3b3)](_0x224fe3),this[_0x44fa53(0x257)](_0x552651),this[_0x44fa53(0x1a5)](_0x13428e),this[_0x44fa53(0x349)](_0x516b30),this['onAddStateGlobalJS'](_0x2a0a0c));else{const _0x112344=_0x42ad1e[_0x27272e-_0x443dc0[_0x44fa53(0x313)]];if(_0x112344===undefined)return;Window_Base[_0x44fa53(0x296)][_0x44fa53(0x1bc)][_0x44fa53(0x277)](this,_0x1c0cdd,_0x112344,0x0,0x0),Window_Base['prototype']['drawActorBuffRates'][_0x44fa53(0x277)](this,_0x1c0cdd,_0x112344,0x0,0x0);}},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x32d)]=function(){const _0x1b4db4=_0x19f7cd;this['contents'][_0x1b4db4(0x408)]=$gameSystem[_0x1b4db4(0x261)](),this['contents'][_0x1b4db4(0x41c)]=$gameSystem[_0x1b4db4(0x254)](),this['resetTextColor']();},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x21f)]=function(){const _0xaedd41=_0x19f7cd;this[_0xaedd41(0x33c)](ColorManager[_0xaedd41(0x441)]()),this[_0xaedd41(0x1a0)](ColorManager['outlineColor']());},Sprite_StateIcon[_0x19f7cd(0x296)]['changeTextColor']=function(_0x4035fa){const _0x20e2c1=_0x19f7cd;this[_0x20e2c1(0x331)][_0x20e2c1(0x414)]=_0x4035fa;},Sprite_StateIcon[_0x19f7cd(0x296)][_0x19f7cd(0x1a0)]=function(_0x4343ee){const _0x5e2761=_0x19f7cd;this[_0x5e2761(0x331)][_0x5e2761(0x3bb)]=_0x4343ee;},Sprite_StateIcon['prototype']['hide']=function(){const _0x27d56f=_0x19f7cd;this[_0x27d56f(0x3fd)]=!![],this[_0x27d56f(0x45f)]();},Window_Base[_0x19f7cd(0x296)]['drawSkillCost']=function(_0x15d3e5,_0xfe1a72,_0x3c055e,_0x2a4446,_0x2cb910){const _0x4a9b24=_0x19f7cd,_0x3ac9bc=this[_0x4a9b24(0x376)](_0x15d3e5,_0xfe1a72),_0x216fa9=this[_0x4a9b24(0x235)](_0x3ac9bc,_0x3c055e,_0x2a4446,_0x2cb910),_0x264088=_0x3c055e+_0x2cb910-_0x216fa9['width'];this[_0x4a9b24(0x192)](_0x3ac9bc,_0x264088,_0x2a4446,_0x2cb910),this[_0x4a9b24(0x32d)]();},Window_Base[_0x19f7cd(0x296)]['createAllSkillCostText']=function(_0x4e0dca,_0x5593db){const _0x51f7b3=_0x19f7cd;let _0x5aca20='';for(settings of VisuMZ['SkillsStatesCore'][_0x51f7b3(0x417)][_0x51f7b3(0x185)]){if('SFlAQ'!==_0x51f7b3(0x352)){if(!this['isSkillCostShown'](_0x4e0dca,_0x5593db,settings))continue;if(_0x5aca20['length']>0x0)_0x5aca20+=this['skillCostSeparator']();_0x5aca20+=this[_0x51f7b3(0x184)](_0x4e0dca,_0x5593db,settings);}else return this[_0x51f7b3(0x409)]();}_0x5aca20=this['makeAdditionalSkillCostText'](_0x4e0dca,_0x5593db,_0x5aca20);if(_0x5593db[_0x51f7b3(0x1ce)][_0x51f7b3(0x138)](/<CUSTOM COST TEXT>\s*([\s\S]*)\s*<\/CUSTOM COST TEXT>/i)){if(_0x5aca20[_0x51f7b3(0x313)]>0x0)_0x5aca20+=this[_0x51f7b3(0x3f0)]();_0x5aca20+=String(RegExp['$1']);}return _0x5aca20;},Window_Base[_0x19f7cd(0x296)]['makeAdditionalSkillCostText']=function(_0x525f74,_0x5ef263,_0x4e26c4){return _0x4e26c4;},Window_Base[_0x19f7cd(0x296)][_0x19f7cd(0x1e1)]=function(_0x238b65,_0x34a2ab,_0x26f527){const _0x4d3f21=_0x19f7cd;let _0x37c5c3=_0x26f527[_0x4d3f21(0x24c)][_0x4d3f21(0x277)](_0x238b65,_0x34a2ab);return _0x37c5c3=_0x238b65[_0x4d3f21(0x469)](_0x34a2ab,_0x37c5c3,_0x26f527),_0x26f527['ShowJS']['call'](_0x238b65,_0x34a2ab,_0x37c5c3,_0x26f527);},Window_Base[_0x19f7cd(0x296)][_0x19f7cd(0x184)]=function(_0x5e889d,_0x397518,_0x1324df){const _0x31ef92=_0x19f7cd;let _0x5a7e8c=_0x1324df[_0x31ef92(0x24c)][_0x31ef92(0x277)](_0x5e889d,_0x397518);return _0x5a7e8c=_0x5e889d[_0x31ef92(0x469)](_0x397518,_0x5a7e8c,_0x1324df),_0x1324df[_0x31ef92(0x379)][_0x31ef92(0x277)](_0x5e889d,_0x397518,_0x5a7e8c,_0x1324df);},Window_Base[_0x19f7cd(0x296)]['skillCostSeparator']=function(){return'\x20';},Window_Base[_0x19f7cd(0x296)][_0x19f7cd(0x493)]=function(_0x9775cc,_0x7db9d1,_0x1ffe51,_0x59e408){const _0x3430f8=_0x19f7cd;if(!_0x9775cc)return;VisuMZ[_0x3430f8(0x21a)][_0x3430f8(0x401)][_0x3430f8(0x277)](this,_0x9775cc,_0x7db9d1,_0x1ffe51,_0x59e408),this[_0x3430f8(0x30f)](_0x9775cc,_0x7db9d1,_0x1ffe51,_0x59e408);},Window_Base['prototype'][_0x19f7cd(0x30f)]=function(_0x3a1de1,_0x2dd731,_0x511041,_0x40c90d){const _0x3cfa47=_0x19f7cd;_0x40c90d=_0x40c90d||0x90;const _0x3fdaa3=ImageManager[_0x3cfa47(0x2a6)],_0x3142d6=_0x3a1de1[_0x3cfa47(0x2c2)]()['slice'](0x0,Math[_0x3cfa47(0x465)](_0x40c90d/_0x3fdaa3)),_0x240c49=_0x3a1de1[_0x3cfa47(0x25d)]()[_0x3cfa47(0x3ab)](_0x5d4ba0=>_0x5d4ba0['iconIndex']>0x0),_0x19041d=[...Array(0x8)[_0x3cfa47(0x342)]()][_0x3cfa47(0x3ab)](_0x5c8bc6=>_0x3a1de1[_0x3cfa47(0x323)](_0x5c8bc6)!==0x0),_0x473167=[];let _0x323f6d=_0x2dd731;for(let _0x274704=0x0;_0x274704<_0x3142d6[_0x3cfa47(0x313)];_0x274704++){if(_0x3cfa47(0x176)===_0x3cfa47(0x400))return _0x258aa9['SkillsStatesCore'][_0x3cfa47(0x417)][_0x3cfa47(0x270)][_0x3cfa47(0x2f5)];else{this['resetFontSettings']();const _0x3abafd=_0x240c49[_0x274704];if(_0x3abafd){if('SJDwK'!==_0x3cfa47(0x2aa))return _0x39e35c[_0x3cfa47(0x3bb)]();else{if(!_0x473167[_0x3cfa47(0x3c5)](_0x3abafd)){if(_0x3cfa47(0x161)==='dqtkF')this[_0x3cfa47(0x47a)](_0x3a1de1,_0x3abafd,_0x323f6d,_0x511041);else{const _0x3a2f9e=this[_0x3cfa47(0x1ff)]();this['_shopStatusWindow']=new _0x3097a8(_0x3a2f9e),this[_0x3cfa47(0x134)](this[_0x3cfa47(0x491)]),this[_0x3cfa47(0x372)][_0x3cfa47(0x14d)](this[_0x3cfa47(0x491)]);const _0x4dac62=_0x3d1d61[_0x3cfa47(0x21a)][_0x3cfa47(0x417)][_0x3cfa47(0x270)][_0x3cfa47(0x173)];this[_0x3cfa47(0x491)][_0x3cfa47(0x47e)](_0x4dac62||0x0);}}this[_0x3cfa47(0x48e)](_0x3a1de1,_0x3abafd,_0x323f6d,_0x511041),_0x473167[_0x3cfa47(0x272)](_0x3abafd);}}else{const _0x1e8a81=_0x19041d[_0x274704-_0x240c49[_0x3cfa47(0x313)]];this[_0x3cfa47(0x1bc)](_0x3a1de1,_0x1e8a81,_0x323f6d,_0x511041),this[_0x3cfa47(0x243)](_0x3a1de1,_0x1e8a81,_0x323f6d,_0x511041);}_0x323f6d+=_0x3fdaa3;}}},Window_Base[_0x19f7cd(0x296)][_0x19f7cd(0x47a)]=function(_0x4b3df1,_0x4bb6ff,_0x48b2ed,_0x2cdff9){const _0x4c1aae=_0x19f7cd;if(!VisuMZ[_0x4c1aae(0x21a)][_0x4c1aae(0x417)][_0x4c1aae(0x32e)][_0x4c1aae(0x2d5)])return;if(!_0x4b3df1[_0x4c1aae(0x3b6)](_0x4bb6ff['id']))return;if(_0x4bb6ff[_0x4c1aae(0x424)]===0x0)return;if(_0x4bb6ff[_0x4c1aae(0x1ce)][_0x4c1aae(0x138)](/<HIDE STATE TURNS>/i))return;const _0xb4b1ee=_0x4b3df1[_0x4c1aae(0x320)](_0x4bb6ff['id']),_0x224b59=ImageManager[_0x4c1aae(0x2a6)],_0x5e061f=ColorManager[_0x4c1aae(0x339)](_0x4bb6ff);this[_0x4c1aae(0x33c)](_0x5e061f),this['changeOutlineColor'](_0x4c1aae(0x369)),this[_0x4c1aae(0x331)][_0x4c1aae(0x157)]=!![],this[_0x4c1aae(0x331)]['fontSize']=VisuMZ[_0x4c1aae(0x21a)][_0x4c1aae(0x417)][_0x4c1aae(0x32e)][_0x4c1aae(0x1c5)],_0x48b2ed+=VisuMZ[_0x4c1aae(0x21a)]['Settings'][_0x4c1aae(0x32e)]['TurnOffsetX'],_0x2cdff9+=VisuMZ[_0x4c1aae(0x21a)][_0x4c1aae(0x417)]['States'][_0x4c1aae(0x461)],this[_0x4c1aae(0x223)](_0xb4b1ee,_0x48b2ed,_0x2cdff9,_0x224b59,_0x4c1aae(0x350)),this[_0x4c1aae(0x331)][_0x4c1aae(0x157)]=![],this[_0x4c1aae(0x32d)]();},Window_Base['prototype'][_0x19f7cd(0x48e)]=function(_0x50e6dc,_0x1725ba,_0x1577e1,_0x3a1665){const _0x35c722=_0x19f7cd;if(!VisuMZ[_0x35c722(0x21a)]['Settings'][_0x35c722(0x32e)][_0x35c722(0x2a7)])return;const _0xb9cae2=ImageManager[_0x35c722(0x2a6)],_0xa4a1d9=ImageManager['iconHeight']/0x2,_0x314673=ColorManager['normalColor']();this[_0x35c722(0x33c)](_0x314673),this[_0x35c722(0x1a0)](_0x35c722(0x369)),this['contents']['fontBold']=!![],this[_0x35c722(0x331)][_0x35c722(0x41c)]=VisuMZ[_0x35c722(0x21a)][_0x35c722(0x417)][_0x35c722(0x32e)][_0x35c722(0x3dd)],_0x1577e1+=VisuMZ['SkillsStatesCore']['Settings'][_0x35c722(0x32e)]['DataOffsetX'],_0x3a1665+=VisuMZ['SkillsStatesCore'][_0x35c722(0x417)][_0x35c722(0x32e)][_0x35c722(0x1c2)];const _0x2e4da2=String(_0x50e6dc[_0x35c722(0x22f)](_0x1725ba['id']));this[_0x35c722(0x223)](_0x2e4da2,_0x1577e1,_0x3a1665,_0xb9cae2,_0x35c722(0x17f)),this['contents']['fontBold']=![],this[_0x35c722(0x32d)]();},Window_Base['prototype'][_0x19f7cd(0x1bc)]=function(_0x49faea,_0x303c0c,_0x3d2f40,_0x3dad2d){const _0x13c456=_0x19f7cd;if(!VisuMZ[_0x13c456(0x21a)][_0x13c456(0x417)][_0x13c456(0x180)][_0x13c456(0x2d5)])return;const _0x1717ab=_0x49faea['buff'](_0x303c0c);if(_0x1717ab===0x0)return;const _0x5bfcc0=_0x49faea['buffTurns'](_0x303c0c),_0xb9585b=ImageManager[_0x13c456(0x2a6)],_0xabbbdf=_0x1717ab>0x0?ColorManager[_0x13c456(0x13e)]():ColorManager['debuffColor']();this['changeTextColor'](_0xabbbdf),this['changeOutlineColor'](_0x13c456(0x369)),this[_0x13c456(0x331)]['fontBold']=!![],this['contents'][_0x13c456(0x41c)]=VisuMZ['SkillsStatesCore'][_0x13c456(0x417)]['Buffs'][_0x13c456(0x1c5)],_0x3d2f40+=VisuMZ[_0x13c456(0x21a)]['Settings'][_0x13c456(0x180)]['TurnOffsetX'],_0x3dad2d+=VisuMZ[_0x13c456(0x21a)][_0x13c456(0x417)]['Buffs']['TurnOffsetY'],this[_0x13c456(0x223)](_0x5bfcc0,_0x3d2f40,_0x3dad2d,_0xb9585b,_0x13c456(0x350)),this[_0x13c456(0x331)][_0x13c456(0x157)]=![],this[_0x13c456(0x32d)]();},Window_Base[_0x19f7cd(0x296)][_0x19f7cd(0x243)]=function(_0x55c4f4,_0x34f0d3,_0x1318f9,_0x1a3d42){const _0x38091e=_0x19f7cd;if(!VisuMZ['SkillsStatesCore'][_0x38091e(0x417)][_0x38091e(0x180)]['ShowData'])return;const _0x5ec81f=_0x55c4f4[_0x38091e(0x178)](_0x34f0d3),_0x30d979=_0x55c4f4[_0x38091e(0x323)](_0x34f0d3),_0x322f33=ImageManager[_0x38091e(0x2a6)],_0x4e4550=ImageManager[_0x38091e(0x244)]/0x2,_0x36e4fb=_0x30d979>0x0?ColorManager[_0x38091e(0x13e)]():ColorManager[_0x38091e(0x2a3)]();this['changeTextColor'](_0x36e4fb),this[_0x38091e(0x1a0)]('rgba(0,\x200,\x200,\x201)'),this['contents'][_0x38091e(0x157)]=!![],this[_0x38091e(0x331)][_0x38091e(0x41c)]=VisuMZ[_0x38091e(0x21a)][_0x38091e(0x417)][_0x38091e(0x180)][_0x38091e(0x3dd)],_0x1318f9+=VisuMZ[_0x38091e(0x21a)]['Settings'][_0x38091e(0x180)]['DataOffsetX'],_0x1a3d42+=VisuMZ['SkillsStatesCore'][_0x38091e(0x417)][_0x38091e(0x180)][_0x38091e(0x1c2)];const _0x565896=_0x38091e(0x1a4)[_0x38091e(0x29a)](Math['round'](_0x5ec81f*0x64));this[_0x38091e(0x223)](_0x565896,_0x1318f9,_0x1a3d42,_0x322f33,'center'),this[_0x38091e(0x331)][_0x38091e(0x157)]=![],this[_0x38091e(0x32d)]();},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x208)]=Window_StatusBase[_0x19f7cd(0x296)][_0x19f7cd(0x3ba)],Window_StatusBase[_0x19f7cd(0x296)][_0x19f7cd(0x3ba)]=function(_0x19099b,_0x585475,_0x11ccc4,_0x33a2d9){const _0xff31c2=_0x19f7cd;if(_0x19099b[_0xff31c2(0x19c)]())_0x585475=this[_0xff31c2(0x499)](_0x19099b,_0x585475);this[_0xff31c2(0x3e9)](_0x19099b,_0x585475,_0x11ccc4,_0x33a2d9);},Window_StatusBase[_0x19f7cd(0x296)]['placeExactGauge']=function(_0x5d54d6,_0x164729,_0x3abce0,_0x57427c){const _0x7fb7e8=_0x19f7cd;if(['none','untitled'][_0x7fb7e8(0x3c5)](_0x164729['toLowerCase']()))return;VisuMZ[_0x7fb7e8(0x21a)][_0x7fb7e8(0x208)]['call'](this,_0x5d54d6,_0x164729,_0x3abce0,_0x57427c);},Window_StatusBase[_0x19f7cd(0x296)]['convertGaugeTypeSkillsStatesCore']=function(_0x1a6163,_0x8ab42f){const _0x579196=_0x19f7cd,_0x4560de=_0x1a6163[_0x579196(0x194)]()[_0x579196(0x1ce)];if(_0x8ab42f==='hp'&&_0x4560de['match'](/<REPLACE HP GAUGE:[ ](.*)>/i)){if(_0x579196(0x165)!=='xUZSL'){const _0x2056ed=this[_0x579196(0x3f1)](_0x37a813),_0x4f0821=this[_0x579196(0x235)](_0xd734f4)['width'];return _0x4f0821<=_0x2056ed[_0x579196(0x2b1)]?_0x579196(0x14f):_0x579196(0x494);}else return String(RegExp['$1']);}else{if(_0x8ab42f==='mp'&&_0x4560de[_0x579196(0x138)](/<REPLACE MP GAUGE:[ ](.*)>/i))return String(RegExp['$1']);else return _0x8ab42f==='tp'&&_0x4560de[_0x579196(0x138)](/<REPLACE TP GAUGE:[ ](.*)>/i)?String(RegExp['$1']):_0x8ab42f;}},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x401)]=Window_StatusBase[_0x19f7cd(0x296)][_0x19f7cd(0x493)],Window_StatusBase[_0x19f7cd(0x296)]['drawActorIcons']=function(_0x24d501,_0x443d81,_0x1ff180,_0x44c89e){const _0x734481=_0x19f7cd;if(!_0x24d501)return;Window_Base[_0x734481(0x296)][_0x734481(0x493)]['call'](this,_0x24d501,_0x443d81,_0x1ff180,_0x44c89e);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x148)]=Window_SkillType[_0x19f7cd(0x296)]['initialize'],Window_SkillType['prototype']['initialize']=function(_0x4a924a){const _0x2edd2c=_0x19f7cd;VisuMZ['SkillsStatesCore'][_0x2edd2c(0x148)]['call'](this,_0x4a924a),this[_0x2edd2c(0x418)](_0x4a924a);},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x418)]=function(_0x5253bc){const _0x10c580=_0x19f7cd,_0x3fec9b=new Rectangle(0x0,0x0,_0x5253bc[_0x10c580(0x2b1)],_0x5253bc[_0x10c580(0x171)]);this[_0x10c580(0x167)]=new Window_Base(_0x3fec9b),this[_0x10c580(0x167)][_0x10c580(0x38d)]=0x0,this[_0x10c580(0x20e)](this[_0x10c580(0x167)]),this['updateCommandNameWindow']();},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x1f5)]=function(){const _0x25d59f=_0x19f7cd;Window_Command['prototype'][_0x25d59f(0x1f5)][_0x25d59f(0x277)](this);if(this[_0x25d59f(0x167)])this[_0x25d59f(0x1c7)]();},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x1c7)]=function(){const _0x3113f4=_0x19f7cd,_0x10c15e=this['_commandNameWindow'];_0x10c15e[_0x3113f4(0x331)][_0x3113f4(0x485)]();const _0x8abff5=this[_0x3113f4(0x16f)](this['index']());if(_0x8abff5===_0x3113f4(0x494)&&this['maxItems']()>0x0){if(_0x3113f4(0x1a1)!==_0x3113f4(0x34c)){const _0x53df9a=this[_0x3113f4(0x3f1)](this['index']());let _0x1eb773=this[_0x3113f4(0x368)](this[_0x3113f4(0x2e7)]());_0x1eb773=_0x1eb773['replace'](/\\I\[(\d+)\]/gi,''),_0x10c15e[_0x3113f4(0x32d)](),this[_0x3113f4(0x2cd)](_0x1eb773,_0x53df9a),this[_0x3113f4(0x31f)](_0x1eb773,_0x53df9a),this[_0x3113f4(0x283)](_0x1eb773,_0x53df9a);}else this[_0x3113f4(0x47a)](_0x277d64,_0x587796,_0x1617a2,_0x59b766);}},Window_SkillType[_0x19f7cd(0x296)]['commandNameWindowDrawBackground']=function(_0xe2d91d,_0x575395){},Window_SkillType[_0x19f7cd(0x296)]['commandNameWindowDrawText']=function(_0xbfee8a,_0x43ed87){const _0x9eb138=_0x19f7cd,_0x33c69a=this[_0x9eb138(0x167)];_0x33c69a[_0x9eb138(0x223)](_0xbfee8a,0x0,_0x43ed87['y'],_0x33c69a['innerWidth'],'center');},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x283)]=function(_0x42101c,_0x1a6b4b){const _0x3d1697=_0x19f7cd,_0x5c0c54=this[_0x3d1697(0x167)],_0x12fc1a=$gameSystem['windowPadding'](),_0x2ad8db=_0x1a6b4b['x']+Math[_0x3d1697(0x465)](_0x1a6b4b['width']/0x2)+_0x12fc1a;_0x5c0c54['x']=_0x5c0c54[_0x3d1697(0x2b1)]/-0x2+_0x2ad8db,_0x5c0c54['y']=Math['floor'](_0x1a6b4b[_0x3d1697(0x171)]/0x2);},Window_SkillType['prototype']['isUseModernControls']=function(){const _0x3af493=_0x19f7cd;return Imported['VisuMZ_0_CoreEngine']&&Window_Command[_0x3af493(0x296)][_0x3af493(0x274)]['call'](this);},Window_SkillType['prototype'][_0x19f7cd(0x378)]=function(){const _0x3f68eb=_0x19f7cd;if(!this['_actor'])return;const _0x22eaf9=this[_0x3f68eb(0x15a)][_0x3f68eb(0x2a8)]();for(const _0x43cc1e of _0x22eaf9){if(_0x3f68eb(0x30e)===_0x3f68eb(0x259)){_0x19e536[_0x3f68eb(0x296)][_0x3f68eb(0x1f5)][_0x3f68eb(0x277)](this);if(this['_commandNameWindow'])this[_0x3f68eb(0x1c7)]();}else{const _0x1e09e9=this[_0x3f68eb(0x3b7)](_0x43cc1e);this['addCommand'](_0x1e09e9,_0x3f68eb(0x1f1),!![],_0x43cc1e);}}},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x3b7)]=function(_0x4d9e5e){const _0x2f504e=_0x19f7cd;let _0x1ee290=$dataSystem[_0x2f504e(0x2a8)][_0x4d9e5e];if(_0x1ee290['match'](/\\I\[(\d+)\]/i))return _0x1ee290;if(this[_0x2f504e(0x203)]()==='text')return _0x1ee290;const _0x2483bf=VisuMZ[_0x2f504e(0x21a)][_0x2f504e(0x417)]['Skills'],_0x2b784d=$dataSystem[_0x2f504e(0x3cf)][_0x2f504e(0x3c5)](_0x4d9e5e),_0x47e55e=_0x2b784d?_0x2483bf[_0x2f504e(0x156)]:_0x2483bf[_0x2f504e(0x45c)];return _0x2f504e(0x2ae)['format'](_0x47e55e,_0x1ee290);},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x2c1)]=function(){const _0x2af1bc=_0x19f7cd;return VisuMZ[_0x2af1bc(0x21a)][_0x2af1bc(0x417)]['Skills'][_0x2af1bc(0x36f)];},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x215)]=function(_0x1d78f8){const _0x424db1=_0x19f7cd,_0x441186=this[_0x424db1(0x16f)](_0x1d78f8);if(_0x441186===_0x424db1(0x14f)){if(_0x424db1(0x1e3)!==_0x424db1(0x1e3)){if(typeof _0x191f38!==_0x424db1(0x46c))_0x4473c3=_0x1a0414['id'];return this[_0x424db1(0x16e)]=this[_0x424db1(0x16e)]||{},this[_0x424db1(0x16e)][_0x5d9217]=this['_stateData'][_0x19a336]||{},this[_0x424db1(0x16e)][_0x3b8a8f];}else this[_0x424db1(0x245)](_0x1d78f8);}else _0x441186===_0x424db1(0x494)?this['drawItemStyleIcon'](_0x1d78f8):_0x424db1(0x47b)===_0x424db1(0x47b)?Window_Command[_0x424db1(0x296)][_0x424db1(0x215)][_0x424db1(0x277)](this,_0x1d78f8):(_0x49a88f['addState'](_0xab1ec4),_0xca9a1[_0x424db1(0x3ed)](_0x27eb61,_0x16099e));},Window_SkillType['prototype'][_0x19f7cd(0x203)]=function(){const _0x79647d=_0x19f7cd;return VisuMZ['SkillsStatesCore'][_0x79647d(0x417)]['Skills'][_0x79647d(0x2f5)];},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x16f)]=function(_0x27ebba){const _0x177278=_0x19f7cd;if(_0x27ebba<0x0)return _0x177278(0x2b2);const _0x2f3e5d=this['commandStyle']();if(_0x2f3e5d!==_0x177278(0x22c))return _0x2f3e5d;else{if(this[_0x177278(0x286)]()>0x0){const _0x9344fe=this[_0x177278(0x368)](_0x27ebba);if(_0x9344fe[_0x177278(0x138)](/\\I\[(\d+)\]/i)){const _0x27b144=this['itemLineRect'](_0x27ebba),_0x16dd24=this[_0x177278(0x235)](_0x9344fe)[_0x177278(0x2b1)];if(_0x16dd24<=_0x27b144['width']){if(_0x177278(0x367)!==_0x177278(0x284))return _0x177278(0x14f);else _0x1f3bb3['SkillsStatesCore'][_0x177278(0x417)][_0x177278(0x180)][_0x177278(0x2d2)][_0x177278(0x277)](this,_0xe8771d,_0x5639b3);}else return _0x177278(0x494);}}}return _0x177278(0x2b2);},Window_SkillType[_0x19f7cd(0x296)][_0x19f7cd(0x245)]=function(_0x4e8b77){const _0x1cff1=_0x19f7cd,_0x15179f=this['itemLineRect'](_0x4e8b77),_0x449909=this['commandName'](_0x4e8b77),_0xde2e0a=this[_0x1cff1(0x235)](_0x449909)[_0x1cff1(0x2b1)];this[_0x1cff1(0x266)](this[_0x1cff1(0x444)](_0x4e8b77));const _0x4d0d0d=this['itemTextAlign']();if(_0x4d0d0d===_0x1cff1(0x350)){if(_0x1cff1(0x446)!=='usyXb')this[_0x1cff1(0x192)](_0x449909,_0x15179f['x']+_0x15179f[_0x1cff1(0x2b1)]-_0xde2e0a,_0x15179f['y'],_0xde2e0a);else for(const _0x46e3dc of _0x17bbd5){_0x46e3dc[_0x1cff1(0x138)](/<STATE[ ](.*)[ ]CATEGORY REMOVE:[ ]ALL>/i);const _0x3e82ce=_0x29c742(_0x339d2f['$1']);_0x36c57f[_0x1cff1(0x2a5)](_0x3e82ce);}}else{if(_0x4d0d0d===_0x1cff1(0x17f)){const _0x1b0dd8=_0x15179f['x']+Math[_0x1cff1(0x465)]((_0x15179f[_0x1cff1(0x2b1)]-_0xde2e0a)/0x2);this[_0x1cff1(0x192)](_0x449909,_0x1b0dd8,_0x15179f['y'],_0xde2e0a);}else _0x1cff1(0x3bc)===_0x1cff1(0x294)?(_0x373f92[_0x1cff1(0x3b4)](_0x4b0e9e),_0xc9f555['setStateTurns'](_0x472546,_0x39301a)):this[_0x1cff1(0x192)](_0x449909,_0x15179f['x'],_0x15179f['y'],_0xde2e0a);}},Window_SkillType[_0x19f7cd(0x296)]['drawItemStyleIcon']=function(_0x30eff0){const _0x497bf0=_0x19f7cd;this[_0x497bf0(0x368)](_0x30eff0)[_0x497bf0(0x138)](/\\I\[(\d+)\]/i);const _0x34ec19=Number(RegExp['$1'])||0x0,_0x5d6769=this['itemLineRect'](_0x30eff0),_0x3e07d5=_0x5d6769['x']+Math[_0x497bf0(0x465)]((_0x5d6769[_0x497bf0(0x2b1)]-ImageManager['iconWidth'])/0x2),_0x2a2be4=_0x5d6769['y']+(_0x5d6769[_0x497bf0(0x171)]-ImageManager['iconHeight'])/0x2;this['drawIcon'](_0x34ec19,_0x3e07d5,_0x2a2be4);},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x135)]=Window_SkillStatus['prototype'][_0x19f7cd(0x2bb)],Window_SkillStatus[_0x19f7cd(0x296)][_0x19f7cd(0x2bb)]=function(){const _0x789aef=_0x19f7cd;VisuMZ[_0x789aef(0x21a)][_0x789aef(0x135)]['call'](this);if(this['_actor'])this[_0x789aef(0x428)]();},Window_SkillStatus[_0x19f7cd(0x296)][_0x19f7cd(0x428)]=function(){const _0x1dc03b=_0x19f7cd;if(!Imported[_0x1dc03b(0x3d5)])return;if(!Imported[_0x1dc03b(0x130)])return;const _0x2407a1=this[_0x1dc03b(0x39d)]();let _0x2ec15c=this[_0x1dc03b(0x32b)]()/0x2+0xb4+0xb4+0xb4,_0x49f937=this[_0x1dc03b(0x455)]-_0x2ec15c-0x2;if(_0x49f937>=0x12c){const _0x32fc63=VisuMZ[_0x1dc03b(0x1dc)][_0x1dc03b(0x417)][_0x1dc03b(0x39b)][_0x1dc03b(0x207)],_0x5969e9=Math[_0x1dc03b(0x465)](_0x49f937/0x2)-0x18;let _0x4733e6=_0x2ec15c,_0x55d035=Math[_0x1dc03b(0x465)]((this[_0x1dc03b(0x147)]-Math[_0x1dc03b(0x361)](_0x32fc63['length']/0x2)*_0x2407a1)/0x2),_0x4de21f=0x0;for(const _0x97ae49 of _0x32fc63){if(_0x1dc03b(0x359)!==_0x1dc03b(0x3ff)){this['drawExtendedParameter'](_0x4733e6,_0x55d035,_0x5969e9,_0x97ae49),_0x4de21f++;if(_0x4de21f%0x2===0x0){if('FmHZX'!==_0x1dc03b(0x407)){const _0x449f56=this[_0x1dc03b(0x253)](_0x785896),_0x5cdfb2=_0x449f56?_0x449f56[_0x1dc03b(0x44c)]:'';if(_0x449f56)this[_0x1dc03b(0x432)](_0x449f56);_0x5dbe09[_0x1dc03b(0x21a)]['Window_SkillList_drawItem']['call'](this,_0x53d2e3);if(_0x449f56)_0x449f56['name']=_0x5cdfb2;}else _0x4733e6=_0x2ec15c,_0x55d035+=_0x2407a1;}else _0x4733e6+=_0x5969e9+0x18;}else{if(this[_0x1dc03b(0x1a6)](_0x44912b))return!![];}}}this[_0x1dc03b(0x32d)]();},Window_SkillStatus[_0x19f7cd(0x296)][_0x19f7cd(0x482)]=function(_0x5ed4eb,_0x283fd6,_0x52f045,_0x5d6a49){const _0x75bc66=_0x19f7cd,_0x20565f=this[_0x75bc66(0x39d)]();this['resetFontSettings'](),this['drawParamText'](_0x5ed4eb,_0x283fd6,_0x52f045,_0x5d6a49,!![]),this[_0x75bc66(0x21f)](),this[_0x75bc66(0x331)][_0x75bc66(0x41c)]-=0x8;const _0x2beac5=this[_0x75bc66(0x15a)]['paramValueByName'](_0x5d6a49,!![]);this[_0x75bc66(0x331)][_0x75bc66(0x223)](_0x2beac5,_0x5ed4eb,_0x283fd6,_0x52f045,_0x20565f,_0x75bc66(0x350));},VisuMZ[_0x19f7cd(0x21a)]['Window_SkillList_includes']=Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x3c5)],Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x3c5)]=function(_0xc0ec5c){return this['includesSkillsStatesCore'](_0xc0ec5c);},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x33b)]=Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x34e)],Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x34e)]=function(){const _0x286d45=_0x19f7cd;return SceneManager['_scene'][_0x286d45(0x1cf)]===Scene_Battle?VisuMZ[_0x286d45(0x21a)][_0x286d45(0x33b)][_0x286d45(0x277)](this):VisuMZ[_0x286d45(0x21a)][_0x286d45(0x417)]['Skills']['ListWindowCols'];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x21b)]=Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x231)],Window_SkillList['prototype'][_0x19f7cd(0x231)]=function(_0x41e8a8){const _0x28b93c=_0x19f7cd,_0x61c021=this[_0x28b93c(0x15a)]!==_0x41e8a8;VisuMZ[_0x28b93c(0x21a)][_0x28b93c(0x21b)][_0x28b93c(0x277)](this,_0x41e8a8);if(_0x61c021){if(this[_0x28b93c(0x1af)]&&this[_0x28b93c(0x1af)][_0x28b93c(0x1cf)]===Window_ShopStatus){if(_0x28b93c(0x16b)===_0x28b93c(0x16b))this[_0x28b93c(0x1af)][_0x28b93c(0x27b)](this['itemAt'](0x0));else{if(!this[_0x28b93c(0x169)](_0x373986))return![];return!![];}}}},Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x1be)]=function(_0x1a826d){const _0x4d48ad=_0x19f7cd;if(this[_0x4d48ad(0x209)]===_0x1a826d)return;this[_0x4d48ad(0x209)]=_0x1a826d,this[_0x4d48ad(0x2bb)](),this['scrollTo'](0x0,0x0),this[_0x4d48ad(0x1af)]&&this[_0x4d48ad(0x1af)][_0x4d48ad(0x1cf)]===Window_ShopStatus&&this['_statusWindow']['setItem'](this[_0x4d48ad(0x253)](0x0));},Window_SkillList['prototype'][_0x19f7cd(0x37a)]=function(_0x268b05){const _0x33d487=_0x19f7cd;if(!_0x268b05)return VisuMZ[_0x33d487(0x21a)][_0x33d487(0x492)][_0x33d487(0x277)](this,_0x268b05);if(!this[_0x33d487(0x38b)](_0x268b05))return![];if(!this[_0x33d487(0x267)](_0x268b05))return![];if(!this[_0x33d487(0x3f9)](_0x268b05))return![];return!![];},Window_SkillList['prototype']['checkSkillTypeMatch']=function(_0x64fb01){const _0x1ca883=_0x19f7cd;return DataManager['getSkillTypes'](_0x64fb01)[_0x1ca883(0x3c5)](this[_0x1ca883(0x209)]);},Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x267)]=function(_0x1adfe2){const _0x4b3a64=_0x19f7cd;if(!VisuMZ[_0x4b3a64(0x21a)]['CheckVisibleBattleNotetags'](this[_0x4b3a64(0x15a)],_0x1adfe2))return![];if(!VisuMZ['SkillsStatesCore'][_0x4b3a64(0x13d)](this[_0x4b3a64(0x15a)],_0x1adfe2))return![];if(!VisuMZ[_0x4b3a64(0x21a)][_0x4b3a64(0x319)](this[_0x4b3a64(0x15a)],_0x1adfe2))return![];return!![];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x447)]=function(_0x18aef3,_0x4bbe29){const _0x492d72=_0x19f7cd,_0x551041=_0x4bbe29[_0x492d72(0x1ce)];if(_0x551041[_0x492d72(0x138)](/<HIDE IN BATTLE>/i)&&$gameParty[_0x492d72(0x3d7)]())return![];else return _0x551041[_0x492d72(0x138)](/<HIDE OUTSIDE BATTLE>/i)&&!$gameParty[_0x492d72(0x3d7)]()?![]:!![];},VisuMZ['SkillsStatesCore'][_0x19f7cd(0x13d)]=function(_0x10a3c4,_0x4fe50a){const _0x330390=_0x19f7cd,_0x3a9d4a=_0x4fe50a['note'];if(_0x3a9d4a[_0x330390(0x138)](/<SHOW[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0x330390(0x1b3)===_0x330390(0x1b3)){const _0x60d66c=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x19ea2b of _0x60d66c){if(!$gameSwitches['value'](_0x19ea2b))return![];}return!![];}else{let _0x2b93b0=_0x330390(0x3aa);if(this[_0x330390(0x3db)](_0x2b93b0))return this[_0x330390(0x458)][_0x2b93b0]['includes'](_0x46bf04);return this['_cache'][_0x2b93b0]=this['makeResistedStateCategories'](),this[_0x330390(0x458)][_0x2b93b0]['includes'](_0x359af7);}}if(_0x3a9d4a['match'](/<SHOW ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x2670e0=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x32eafa of _0x2670e0){if(!$gameSwitches['value'](_0x32eafa))return![];}return!![];}if(_0x3a9d4a[_0x330390(0x138)](/<SHOW ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('ZEklF'!==_0x330390(0x23a)){const _0x278ea0=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x2e724e of _0x278ea0){if(_0x330390(0x1a3)!=='WzaDJ')return this['_buffs'][_0x3c268d]===_0x3482ee[_0x330390(0x21a)][_0x330390(0x417)][_0x330390(0x180)]['StackBuffMax'];else{if($gameSwitches[_0x330390(0x151)](_0x2e724e))return!![];}}return![];}else return _0x27c64f[_0x330390(0x21a)][_0x330390(0x417)][_0x330390(0x270)][_0x330390(0x312)];}if(_0x3a9d4a[_0x330390(0x138)](/<HIDE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3ac91e=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x37653f of _0x3ac91e){if(!$gameSwitches['value'](_0x37653f))return!![];}return![];}if(_0x3a9d4a[_0x330390(0x138)](/<HIDE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x25db00=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x1fecb5 of _0x25db00){if('pBKYU'===_0x330390(0x356))return'<actor-%1>'['format'](_0x2c90e1[_0x330390(0x2c7)]());else{if(!$gameSwitches['value'](_0x1fecb5))return!![];}}return![];}if(_0x3a9d4a['match'](/<HIDE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x17daf7=JSON[_0x330390(0x256)]('['+RegExp['$1'][_0x330390(0x138)](/\d+/g)+']');for(const _0x44c83f of _0x17daf7){if(_0x330390(0x481)!==_0x330390(0x1d1)){if($gameSwitches[_0x330390(0x151)](_0x44c83f))return![];}else _0x3f2abb=_0x44a6ab,_0x270840+=_0x1cdf0e;}return!![];}return!![];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x319)]=function(_0x5c88ee,_0x1fe241){const _0xbc7fdb=_0x19f7cd,_0x28a71a=_0x1fe241[_0xbc7fdb(0x1ce)];if(_0x28a71a['match'](/<SHOW IF LEARNED[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x5ebc55=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0xd20895 of _0x5ebc55){if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0xd20895))return![];}return!![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF LEARNED[ ](?:SKILL|SKILLS):[ ](.*)>/i)){if(_0xbc7fdb(0x334)!==_0xbc7fdb(0x1d0)){const _0x382541=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x5143b7 of _0x382541){if(_0xbc7fdb(0x393)!=='cegQw'){const _0x1166c8=_0x315dde[_0x5a7cf1];if(_0x1166c8&&_0x1166c8[_0xbc7fdb(0x3e7)]['length']>0x0)for(const _0x54ba56 of _0x1166c8[_0xbc7fdb(0x3e7)]){if(this['isStateCategoryResisted'](_0x54ba56))return!![];}return _0x3cc45a[_0xbc7fdb(0x21a)][_0xbc7fdb(0x3ae)]['call'](this,_0x34cf44);}else{const _0x5d232a=DataManager[_0xbc7fdb(0x43f)](_0x5143b7);if(!_0x5d232a)continue;if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0x5d232a))return![];}}return!![];}else{for(_0x4dd0dd of _0x21bda6['SkillsStatesCore']['Settings'][_0xbc7fdb(0x185)]){let _0x220957=_0x212837[_0xbc7fdb(0x24c)][_0xbc7fdb(0x277)](this,_0x4a953e);_0x220957=this['adjustSkillCost'](_0x5a6eba,_0x220957,_0x54a844);if(!_0x563245[_0xbc7fdb(0x38e)][_0xbc7fdb(0x277)](this,_0x50204c,_0x220957))return![];}return!![];}}}if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF LEARNED ALL[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x1bed57=JSON['parse']('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x52ae2d of _0x1bed57){if(_0xbc7fdb(0x29b)!==_0xbc7fdb(0x2ac)){if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0x52ae2d))return![];}else{if(typeof _0x3a1cbb!==_0xbc7fdb(0x46c))_0x8616e7=_0x374901['id'];this['isStateAffected'](_0x34efa2)&&(_0x2dfe36+=this[_0xbc7fdb(0x320)](_0x10844b),this[_0xbc7fdb(0x3ed)](_0x43dae1,_0x51d9c1));}}return!![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF LEARNED ALL[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x35e1f7=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x2cd639 of _0x35e1f7){const _0x30c781=DataManager[_0xbc7fdb(0x43f)](_0x2cd639);if(!_0x30c781)continue;if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0x30c781))return![];}return!![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF LEARNED ANY[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xbc7fdb(0x1d5)!==_0xbc7fdb(0x197)){const _0x10f75a=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x1b9683 of _0x10f75a){if(_0x5c88ee[_0xbc7fdb(0x1f4)](_0x1b9683))return!![];}return![];}else{if(this[_0xbc7fdb(0x440)]())return this[_0xbc7fdb(0x202)]();else{const _0x404f19=_0x3f03da['SkillsStatesCore'][_0xbc7fdb(0x2bc)][_0xbc7fdb(0x277)](this);return this[_0xbc7fdb(0x45e)]()&&this[_0xbc7fdb(0x1a7)]()&&(_0x404f19[_0xbc7fdb(0x2b1)]-=this[_0xbc7fdb(0x25f)]()),_0x404f19;}}}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF LEARNED ANY[ ](?:SKILL|SKILLS):[ ](.*)>/i)){if(_0xbc7fdb(0x3a2)===_0xbc7fdb(0x193))_0x1a81e1[_0xbc7fdb(0x21a)][_0xbc7fdb(0x148)][_0xbc7fdb(0x277)](this,_0x5e7b6f),this[_0xbc7fdb(0x418)](_0x4beefd);else{const _0x5a977f=RegExp['$1']['split'](',');for(const _0x5e6756 of _0x5a977f){if('xVWOJ'!==_0xbc7fdb(0x3dc)){const _0x751264=DataManager[_0xbc7fdb(0x43f)](_0x5e6756);if(!_0x751264)continue;if(_0x5c88ee[_0xbc7fdb(0x1f4)](_0x751264))return!![];}else _0x5addab['SkillsStatesCore'][_0xbc7fdb(0x2d7)][_0xbc7fdb(0x277)](this),this['clearAllStateOrigins']();}return![];}}}if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('zlkgd'===_0xbc7fdb(0x19a)){const _0x2c0457=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x496ad0 of _0x2c0457){if(!_0x5c88ee['isLearnedSkill'](_0x496ad0))return!![];}return![];}else{const _0x9c983a=_0x1f6700[_0xbc7fdb(0x256)]('['+_0x5da42b['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x56d270 of _0x9c983a){if(!_0x1cad42['isLearnedSkill'](_0x56d270))return!![];}return![];}}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x491e39=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x158b6f of _0x491e39){if(_0xbc7fdb(0x419)!==_0xbc7fdb(0x20c)){const _0x37b442=DataManager[_0xbc7fdb(0x43f)](_0x158b6f);if(!_0x37b442)continue;if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0x37b442))return!![];}else{this[_0xbc7fdb(0x32d)](),this[_0xbc7fdb(0x331)][_0xbc7fdb(0x485)]();const _0x1b0167=this['_battler'];if(!_0x1b0167)return;const _0x3ca00c=_0x1b0167[_0xbc7fdb(0x25d)]()[_0xbc7fdb(0x3ab)](_0x4943e5=>_0x4943e5[_0xbc7fdb(0x15c)]>0x0),_0x79080b=[..._0x146f24(0x8)[_0xbc7fdb(0x342)]()]['filter'](_0x6af455=>_0x1b0167['buff'](_0x6af455)!==0x0),_0x4f0599=this[_0xbc7fdb(0x170)],_0x317c83=_0x3ca00c[_0x4f0599];if(_0x317c83)_0x5a8990[_0xbc7fdb(0x296)][_0xbc7fdb(0x47a)]['call'](this,_0x1b0167,_0x317c83,0x0,0x0),_0x2d53c8[_0xbc7fdb(0x296)]['drawActorStateData'][_0xbc7fdb(0x277)](this,_0x1b0167,_0x317c83,0x0,0x0);else{const _0x2aa4ba=_0x79080b[_0x4f0599-_0x3ca00c[_0xbc7fdb(0x313)]];if(_0x2aa4ba===_0x59ada3)return;_0x17cc4b['prototype'][_0xbc7fdb(0x1bc)][_0xbc7fdb(0x277)](this,_0x1b0167,_0x2aa4ba,0x0,0x0),_0x5a558d[_0xbc7fdb(0x296)][_0xbc7fdb(0x243)][_0xbc7fdb(0x277)](this,_0x1b0167,_0x2aa4ba,0x0,0x0);}}}return![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED ALL[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if('wZNxm'!=='wZNxm')return _0x16befa(_0x4176c0['$1']);else{const _0x301365=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x165bdd of _0x301365){if(_0xbc7fdb(0x17a)!==_0xbc7fdb(0x38a)){if(!_0x5c88ee['isLearnedSkill'](_0x165bdd))return!![];}else return this[_0xbc7fdb(0x340)]&&this[_0xbc7fdb(0x340)][_0xbc7fdb(0x274)]();}return![];}}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED ALL[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x5144f7=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x3e3a3d of _0x5144f7){if(_0xbc7fdb(0x1e6)===_0xbc7fdb(0x1e6)){const _0x10fe49=DataManager['getSkillIdWithName'](_0x3e3a3d);if(!_0x10fe49)continue;if(!_0x5c88ee[_0xbc7fdb(0x1f4)](_0x10fe49))return!![];}else return![];}return![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED ANY[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x237e18=JSON['parse']('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x5c76d1 of _0x237e18){if(_0x5c88ee['isLearnedSkill'](_0x5c76d1))return![];}return!![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF LEARNED ANY[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x32f05e=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x103662 of _0x32f05e){const _0x54516b=DataManager[_0xbc7fdb(0x43f)](_0x103662);if(!_0x54516b)continue;if(_0x5c88ee[_0xbc7fdb(0x1f4)](_0x54516b))return![];}return!![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF (?:HAS|HAVE)[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x34adc3=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x9cf9d4 of _0x34adc3){if(_0xbc7fdb(0x3f5)!==_0xbc7fdb(0x3f5)){const _0x3f88ad=_0x28375a[_0xbc7fdb(0x21a)][_0xbc7fdb(0x201)][_0xbc7fdb(0x277)](this);return _0x3f88ad[_0xbc7fdb(0x154)](0x0,0x1);}else{if(!_0x5c88ee['hasSkill'](_0x9cf9d4))return![];}}return!![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF (?:HAS|HAVE)[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x526188=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x11548e of _0x526188){const _0x4d1d30=DataManager[_0xbc7fdb(0x43f)](_0x11548e);if(!_0x4d1d30)continue;if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x4d1d30))return![];}return!![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF (?:HAS|HAVE) ALL[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x595ad8=JSON['parse']('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x17f8a4 of _0x595ad8){if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x17f8a4))return![];}return!![];}else{if(_0x28a71a['match'](/<SHOW IF (?:HAS|HAVE) ALL[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x16d132=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x172353 of _0x16d132){if('vgbDC'==='bUpKJ'){const _0x4f8990=_0x5072db(_0xcdc5ec['$1']),_0xc72a53=_0x4c5e0a[_0xbc7fdb(0x29a)](_0x4f8990,_0xbc7fdb(0x1a8),0x1,_0xbc7fdb(0x189));_0x44c265[_0xbc7fdb(0x21a)][_0xbc7fdb(0x271)][_0x9dbece['id']]=new _0x253783(_0xbc7fdb(0x430),_0xc72a53);}else{const _0x3645ac=DataManager[_0xbc7fdb(0x43f)](_0x172353);if(!_0x3645ac)continue;if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x3645ac))return![];}}return!![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF (?:HAS|HAVE) ANY[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xbc7fdb(0x3fa)!==_0xbc7fdb(0x3fa))this[_0xbc7fdb(0x302)][_0x25f42f]=_0x6fa54e[_0xbc7fdb(0x21a)][_0xbc7fdb(0x417)]['States'][_0xbc7fdb(0x451)];else{const _0x4374b7=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0xf10643 of _0x4374b7){if(_0x5c88ee[_0xbc7fdb(0x353)](_0xf10643))return!![];}return![];}}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<SHOW IF (?:HAS|HAVE) ANY[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x220f83=RegExp['$1']['split'](',');for(const _0x2c1760 of _0x220f83){const _0x330562=DataManager[_0xbc7fdb(0x43f)](_0x2c1760);if(!_0x330562)continue;if(_0x5c88ee[_0xbc7fdb(0x353)](_0x330562))return!![];}return![];}}if(_0x28a71a['match'](/<HIDE IF (?:HAS|HAVE)[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x4f4557=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x2eb1ca of _0x4f4557){if('VTrJU'===_0xbc7fdb(0x227))return _0x3a4c6f[_0xbc7fdb(0x3bb)]();else{if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x2eb1ca))return!![];}}return![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF (?:HAS|HAVE)[ ](?:SKILL|SKILLS):[ ](.*)>/i)){if(_0xbc7fdb(0x17b)!=='GgxKK'){const _0x49c26c=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x4f2987 of _0x49c26c){if(_0xbc7fdb(0x3f6)!==_0xbc7fdb(0x3f6)){const _0xdd6c32=this[_0xbc7fdb(0x3b7)](_0x265fac);this['addCommand'](_0xdd6c32,_0xbc7fdb(0x1f1),!![],_0x4827f0);}else{const _0x246b98=DataManager['getSkillIdWithName'](_0x4f2987);if(!_0x246b98)continue;if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x246b98))return!![];}}return![];}else{const _0x53e526=_0x40f68c[_0xbc7fdb(0x21a)][_0xbc7fdb(0x2bc)][_0xbc7fdb(0x277)](this);return this['allowCreateShopStatusWindow']()&&this[_0xbc7fdb(0x1a7)]()&&(_0x53e526[_0xbc7fdb(0x2b1)]-=this[_0xbc7fdb(0x25f)]()),_0x53e526;}}}if(_0x28a71a['match'](/<HIDE IF (?:HAS|HAVE) ALL[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){if(_0xbc7fdb(0x280)===_0xbc7fdb(0x237)){const _0x57d6dd=this[_0xbc7fdb(0x25d)]();for(const _0x5c7ac8 of _0x57d6dd){if(_0x5c7ac8&&this[_0xbc7fdb(0x24d)](_0x5c7ac8))this['eraseState'](_0x5c7ac8['id']);}this[_0xbc7fdb(0x458)]={};}else{const _0x28cd6c=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x45e60d of _0x28cd6c){if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x45e60d))return!![];}return![];}}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF (?:HAS|HAVE) ALL[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x4fe593=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x48600d of _0x4fe593){if(_0xbc7fdb(0x442)!==_0xbc7fdb(0x442))return this[_0xbc7fdb(0x458)]=this[_0xbc7fdb(0x458)]||{},this['_cache'][_0x4df4bb]!==_0x11da1e;else{const _0x3cbce5=DataManager[_0xbc7fdb(0x43f)](_0x48600d);if(!_0x3cbce5)continue;if(!_0x5c88ee[_0xbc7fdb(0x353)](_0x3cbce5))return!![];}}return![];}}if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF (?:HAS|HAVE) ANY[ ](?:SKILL|SKILLS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x52497b=JSON[_0xbc7fdb(0x256)]('['+RegExp['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x4a9759 of _0x52497b){if(_0x5c88ee[_0xbc7fdb(0x353)](_0x4a9759))return![];}return!![];}else{if(_0x28a71a[_0xbc7fdb(0x138)](/<HIDE IF (?:HAS|HAVE) ANY[ ](?:SKILL|SKILLS):[ ](.*)>/i)){const _0x349b3d=RegExp['$1'][_0xbc7fdb(0x344)](',');for(const _0x4601c9 of _0x349b3d){if(_0xbc7fdb(0x285)!=='qYdAw'){const _0x2eece1=_0x34e200[_0xbc7fdb(0x256)]('['+_0x14f6d1['$1'][_0xbc7fdb(0x138)](/\d+/g)+']');for(const _0x55da7e of _0x2eece1){if(_0x58d66f['hasSkill'](_0x55da7e))return!![];}return![];}else{const _0xc3caa7=DataManager['getSkillIdWithName'](_0x4601c9);if(!_0xc3caa7)continue;if(_0x5c88ee[_0xbc7fdb(0x353)](_0xc3caa7))return![];}}return!![];}}return!![];},Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x3f9)]=function(_0x2a7063){const _0x30f30b=_0x19f7cd,_0x3f114d=_0x2a7063[_0x30f30b(0x1ce)],_0x76ecea=VisuMZ[_0x30f30b(0x21a)][_0x30f30b(0x28c)];return _0x76ecea[_0x2a7063['id']]?_0x76ecea[_0x2a7063['id']][_0x30f30b(0x277)](this,_0x2a7063):!![];},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x28e)]=Window_SkillList[_0x19f7cd(0x296)]['drawItem'],Window_SkillList['prototype'][_0x19f7cd(0x215)]=function(_0x5af937){const _0x3530b0=_0x19f7cd,_0x336c7e=this[_0x3530b0(0x253)](_0x5af937),_0x37837b=_0x336c7e?_0x336c7e['name']:'';if(_0x336c7e)this[_0x3530b0(0x432)](_0x336c7e);VisuMZ['SkillsStatesCore'][_0x3530b0(0x28e)][_0x3530b0(0x277)](this,_0x5af937);if(_0x336c7e)_0x336c7e[_0x3530b0(0x44c)]=_0x37837b;},Window_SkillList[_0x19f7cd(0x296)]['alterSkillName']=function(_0x4f5e40){const _0x41ad40=_0x19f7cd;if(_0x4f5e40&&_0x4f5e40[_0x41ad40(0x1ce)][_0x41ad40(0x138)](/<LIST NAME:[ ](.*)>/i)){_0x4f5e40[_0x41ad40(0x44c)]=String(RegExp['$1'])[_0x41ad40(0x467)]();for(;;){if(_0x4f5e40[_0x41ad40(0x44c)]['match'](/\\V\[(\d+)\]/gi))_0x4f5e40[_0x41ad40(0x44c)]=_0x4f5e40['name'][_0x41ad40(0x1d8)](/\\V\[(\d+)\]/gi,(_0x5ab52d,_0x273ed0)=>$gameVariables[_0x41ad40(0x151)](parseInt(_0x273ed0)));else{if(_0x41ad40(0x238)!==_0x41ad40(0x262))break;else _0x5ddb69[_0x41ad40(0x21a)]['Settings'][_0x41ad40(0x180)][_0x41ad40(0x181)]['call'](this,_0xe70195);}}}},Window_SkillList['prototype'][_0x19f7cd(0x28f)]=function(_0x4c696c,_0x2d4e98,_0x8c3621,_0x13915f){const _0x499742=_0x19f7cd;Window_Base[_0x499742(0x296)][_0x499742(0x28f)]['call'](this,this[_0x499742(0x15a)],_0x4c696c,_0x2d4e98,_0x8c3621,_0x13915f);},Window_SkillList[_0x19f7cd(0x296)][_0x19f7cd(0x14d)]=function(_0x392f7d){const _0x22f77e=_0x19f7cd;this[_0x22f77e(0x1af)]=_0x392f7d,this[_0x22f77e(0x1f5)]();},VisuMZ[_0x19f7cd(0x21a)][_0x19f7cd(0x1d3)]=Window_SkillList['prototype'][_0x19f7cd(0x153)],Window_SkillList['prototype'][_0x19f7cd(0x153)]=function(){const _0x5894a6=_0x19f7cd;VisuMZ[_0x5894a6(0x21a)][_0x5894a6(0x1d3)][_0x5894a6(0x277)](this);if(this['_statusWindow']&&this[_0x5894a6(0x1af)][_0x5894a6(0x1cf)]===Window_ShopStatus){if(_0x5894a6(0x214)!==_0x5894a6(0x1b4))this['_statusWindow'][_0x5894a6(0x27b)](this['item']());else return this;}};function _0x24f9(){const _0x367ef9=['opacity','CanPayJS','NUM','_stored_debuffColor','meetsPassiveStateConditionSwitches','getPassiveStatesFromObj','cegQw','RDHIR','regenerateAll','ldGIO','allSwitchOn','<member-%1>','uiHelpPosition','parameters','Param','ALL','gaugeLineHeight','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20visible\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this._actor;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this._actor;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this._actor;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this._actor;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20visible;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','isBuffExpired','onExpireDebuffGlobalJS','sKMfl','xePNW','gvvlI','Enemy','getClassIdWithName','isStateRestrict','traitsSet','Game_BattlerBase_meetsSkillConditions','onEraseStateGlobalJS','stateCategoriesResisted','filter','enemy','onChange','Game_BattlerBase_isStateResist','_currentActor','Game_BattlerBase_skillTpCost','getPassiveStateConditionClassesData','EGMzn','setStateOrigin','addState','hasStateCategory','isStateAffected','makeCommandName','description','GaugeDrawJS','placeGauge','outlineColor','frfXb','_skills','ZQXKI','%1\x20%2\x20%3','EnemyIndex','isPassiveStateStackable','Game_BattlerBase_states','updateStatesActionEnd','updateTurnDisplaySprite','includes','gaugeRate','mainAreaTop','valueFontFace','CheckIncompatibleStates','12jXAkSA','ParseAllNotetags','PassiveStates','toUpperCase','shopStatusWindowRectSkillsStatesCore','magicSkills','StateTurnsActorChangeTo','StackBuffMax','traitObjects','VisuMZ_2_ClassChangeSystem','EnableLayout','VisuMZ_0_CoreEngine','onAddDebuffGlobalJS','inBattle','isMaxBuffAffected','_checkingTraitsSetSkillsStatesCore','multiClass','checkCacheKey','hyKff','DataFontSize','Game_BattlerBase_traitsSet','tSpzK','_stateTurns','addBuffTurns','state','Vpdpe','_stored_buffColor','DEF','vrDTm','categories','EwTLv','placeExactGauge','updatedLayoutStyle','removeStatesByCategory','_stypeIDs','setStateTurns','YLOVc','Game_Battler_addState','skillCostSeparator','itemLineRect','hpDamage','meetsSkillConditionsGlobalJS','retrieveStateColor','jreKo','nJaFI','isSceneBattle','FKuRe','checkShowHideJS','oMHAT','_turnDisplaySprite','stepsForTurn','_hidden','gCQRH','wPdwp','WgHDR','Window_StatusBase_drawActorIcons','XyoiQ','testSkillStatesCoreNotetags','JSON','isPlaytest','nFouP','FmHZX','fontFace','gaugeColor1','POSITIVE','qFObU','_costSettings','createKeyJS','stypeId','rCWkD','onEraseBuffGlobalJS','ColorNeutral','XyofR','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','textColor','qyPqN','canPaySkillCost','Settings','createCommandNameWindow','EkWPu','onRemoveState','_battler','fontSize','GROEh','rgba(0,\x200,\x200,\x200)','recalculateSlipDamageJS','YPGRr','Name','menuActor','skillMpCost','autoRemovalTiming','isGroupDefeatStateAffected','_stateRetainType','labelFontFace','drawExtendedSkillsStatesCoreStatus','increaseBuff','_scene','_currentTroopUniqueID','_stateSteps','fIoUf','onExpireStateCustomJS','initMembers','stateId','_stateDisplay','alterSkillName','stateHpSlipHealJS','multiclasses','qomvX','onExpireDebuffJS','SwVZe','onExpireDebuff','WCcCe','bUIuY','Game_Action_applyItemUserEffect','gaugeColor2','skillTpCost','SqVbh','getSkillIdWithName','isUseSkillsStatesCoreUpdatedLayout','normalColor','xVZdI','resetStateCounts','isCommandEnabled','addPassiveStatesFromOtherPlugins','JqgHT','CheckVisibleBattleNotetags','Game_Battler_addDebuff','onDatabaseLoaded','removeBuff','RVKpw','name','maxSlipDamage','helpWindowRectSkillsStatesCore','DvnOr','Sprite_Gauge_currentMaxValue','MaxTurns','ARRAYNUM','XIxQL','registerCommand','innerWidth','process_VisuMZ_SkillsStatesCore_Notetags','_cache_getPassiveStateConditionSwitchData','_cache','GqgyW','currentValueSkillsStatesCore','Parse_Notetags_State_PassiveJS','IconStypeNorm','skillEnableJS','allowCreateShopStatusWindow','updateVisibility','anySwitchOn','TurnOffsetY','ignore','getStypeIdWithName','Game_BattlerBase_die','floor','map','trim','\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20%2\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20origin\x20=\x20this.getStateOrigin(stateId);\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20$dataStates[stateId];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20origin;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20origin;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20%2\x20=\x20Math.round(Math.max(0,\x20%2)\x20*\x20%3);\x0a\x20\x20\x20\x20\x20\x20\x20\x20this.setStateData(stateId,\x20\x27%4\x27,\x20%2);\x0a\x20\x20\x20\x20','adjustSkillCost','currentDisplayedValue','BMaJJ','number','onExpireStateJS','_stateOrigin','createTurnDisplaySprite','stateAddJS','addPassiveStatesByPluginParameters','onAddStateJS','meetsSkillConditions','ColorPositive','makeCurrentTroopUniqueID','StateTurnsEnemyChangeTo','MultiplierJS','isDebuffAffected','_cache_getPassiveStatesFromObj','drawActorStateTurns','trlJi','reset','_passiveStateResults','setBackgroundType','Gauge','EAZvL','MOnlX','drawExtendedParameter','Game_Battler_isStateAddable','ActorIDs','clear','KGNbo','calcWindowHeight','isSkillTypeMatchForUse','17316TpgKmP','currentMaxValueSkillsStatesCore','itemWindowRect','regenerateAllSkillsStatesCore','deadMembers','drawActorStateData','numberFontFace','restriction','_shopStatusWindow','Window_SkillList_includes','drawActorIcons','icon','bvNXo','gainHp','clearStates','sort','convertGaugeTypeSkillsStatesCore','StateID','VisuMZ_1_MainMenuCore','CRSBw','LCRfa','Abhyf','addWindow','Window_SkillStatus_refresh','exit','Game_BattlerBase_initMembers','match','pnoMR','_classIDs','useDigitGrouping','applyDebuffTurnManipulationEffects','CheckVisibleSwitchNotetags','buffColor','damage','eanmO','makeSuccess','ARRAYSTR','dHrwK','dOWTY','totalStateCategory','NivoB','innerHeight','Window_SkillType_initialize','_endingBattle','dHdLu','add','isRightInputMode','setStatusWindow','allSwitchOff','iconText','BattleHiddenSkillTypes','value','IjECS','updateHelp','clamp','onAddStateGlobalJS','IconStypeMagic','fontBold','tYVrv','paySkillCost','_actor','pJANP','iconIndex','SGlTT','addStateTurns','debuffTurns','helpAreaHeight','dqtkF','LgfEz','<actor-%1>','ShowShopStatus','xUZSL','labelColor','_commandNameWindow','ValueOutlineSolid','checkSkillConditionsSwitchNotetags','applyStateTurnManipulationEffects','uhDLh','actor','lfkIn','_stateData','commandStyleCheck','_animationIndex','height','BRGVj','SkillSceneStatusBgType','getColorDataFromPluginParameters','OgeUi','zCRzH','jUWMo','paramBuffRate','_buffTurns','XCnPn','ycRQB','_colorCache','testApply','equips','center','Buffs','onExpireBuffJS','priority','mpDamage','createSkillCostText','Costs','Actor-%1-%2','rORzO','Zxmrh','slipTp','endAction','FUNC','aliveMembers','enemyId','applyBuffTurnManipulationEffects','mainAreaHeight','createPassiveStatesCache','Global','drawTextEx','bcbxe','currentClass','buffTurns','forgetSkill','mqhxO','loadBitmap','drawItemStyleIcon','zlkgd','Skill-%1-%2','isActor','ParseStateNotetags','helpWindowRect','stateExpireJS','changeOutlineColor','oXBta','_stored_state-%1-color','WzaDJ','%1%','onAddStateMakeCustomSlipValues','isStateCategoryResisted','adjustItemWidthByShopStatus','heal','eraseBuff','1204959SyyAUG','987610NgUYzw','Scene_Skill_statusWindowRect','Game_BattlerBase_eraseState','AGI','_statusWindow','StackDebuffMax','setBuffTurns','ATK','ayKPs','DfJPh','YRQBd','process_VisuMZ_SkillsStatesCore_Skill_Notetags','max','DjUDR','_tempActor','bAHon','fDaWs','drawActorBuffTurns','stateTpSlipDamageJS','setStypeId','RUsVz','ERSMU','ColorNegative','DataOffsetY','gainSilentTp','UzYAn','TurnFontSize','NEGATIVE','updateCommandNameWindow','gaugeBackColor','GFbqP','item','getSkillTypes','getColor','stateHpSlipDamageJS','note','constructor','KDVDw','TwncO','initMembersSkillsStatesCore','Window_SkillList_updateHelp','learnSkill','kkhSS','osmoL','XBVQw','replace','zxCvi','user','currentMaxValue','CoreEngine','onExpireBuffGlobalJS','ValueOutlineWidth','FyOUr','status','isSkillCostShown','_checkingVisuMzPassiveStateObjects','UhOyt','applyStateCategoryRemovalEffects','Item-%1-%2','enfsk','OvHTk','stateMpSlipHealJS','setDebuffTurns','EVAL','stateMaximumTurns','stateData','Sprite_StateIcon_updateFrame','Game_BattlerBase_buffIconIndex','KcfGK','pHcmQ','skill','actions','ZoisK','isLearnedSkill','callUpdateHelp','statusWindowRectSkillsStatesCore','onExpireBuff','buffIconIndex','isBottomHelpMode','RsyGU','isSkillHidden','currentValue','convertTargetToStateOriginKey','getCurrentStateActiveUser','shopStatusWindowRect','TEllg','Sprite_Gauge_gaugeRate','itemWindowRectSkillsStatesCore','commandStyle','qYAYI','neyRC','anySwitchOff','DisplayedParams','Window_StatusBase_placeGauge','_stypeId','AutoAddState','AHTtq','JxcEm','fVLaO','addChild','fillRect','setPassiveStateSlipDamageJS','AXehO','27277591rNjwgQ','skillTypeWindowRectSkillsStatesCore','Tthkh','drawItem','smlHi','shift','khClg','Game_BattlerBase_clearStates','SkillsStatesCore','Window_SkillList_setActor','_states','rtbGt','Sprite_StateIcon_loadBitmap','resetTextColor','clearStateDisplay','ConvertParams','lJxEg','drawText','eraseState','Turns','onAddBuffGlobalJS','JCSOI','lvzIs','GaugeMaxJS','addPassiveStates','boxWidth','auto','recoverAll','LayoutStyle','getStateDisplay','AeFjJ','setActor','isBuffAffected','onExpireStateGlobalJS','Scene_Skill_skillTypeWindowRect','textSizeEx','_tempBattler','RmEuU','BlQxO','oCdoo','nwwnp','success','death','removeState','onEraseStateCustomJS','getStateData','sQDCB','createShopStatusWindow','PayJS','drawActorBuffRates','iconHeight','drawItemStyleIconText','setup','meetsPassiveStateConditions','_result','skills','valueOutlineWidth','StateTurnsEnemyChangeBy','CalcJS','canClearState','Parse_Notetags_Skill_JS','_skillIDs','Game_Unit_deadMembers','Parse_Notetags_State_ApplyRemoveLeaveJS','Game_Actor_forgetSkill','itemAt','mainFontSize','action','parse','removeOtherStatesOfSameCategory','log','cIZtu','buffLength','makeResistedStateCategories','anchor','states','9950910AwEibv','shopStatusWidth','zLdxB','mainFontFace','FPMGr','buttonAssistText1','LabelFontMainType','Parse_Notetags_Skill_Cost','changePaintOpacity','checkShowHideNotetags','\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20origin\x20=\x20this.getStateOrigin(stateId);\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20$dataStates[stateId];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this.getCurrentStateActiveUser();\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20origin;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20','passiveStateIDs','onEraseDebuffJS','dwswF','totalStateCategoryAffected','Game_Troop_setup','onAddDebuff','RSbmo','Skills','stateTpSlipHealJS','push','jCaBy','isUseModernControls','getStateRetainType','createItemWindow','call','setStateRetainType','hYvSa','addPassiveStatesTraitSets','setItem','getCurrentStateOriginKey','vPlTY','KWPJb','passiveStates','ZGWUc','passiveStateObjects','Game_BattlerBase_skillMpCost','commandNameWindowCenter','UYhGR','qYdAw','maxItems','isStateCategoryAffected','HiddenSkillTypes','lNODq','OVjuE','_stateIDs','skillVisibleJS','MAXHP','Window_SkillList_drawItem','drawSkillCost','ParseClassIDs','isMaxDebuffAffected','Game_BattlerBase_overwriteBuffTurns','coQhN','vVdzR','statesByCategory','prototype','bitmap','3903HyUbhc','mpCost','format','WoUjN','Game_Action_testApply','omjOk','<troop-%1>','groupDefeat','EHGIu','775985SXpWIA','prepareResetStateCounts','debuffColor','xeJNy','removeStatesByCategoryAll','iconWidth','ShowData','skillTypes','removeBuffsAuto','SJDwK','Game_Battler_addBuff','NVoAC','1294HyheFN','\x5cI[%1]%2','LONiP','members','width','text','iyiDj','return\x200','decreaseBuff','SZegJ','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20enabled\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20enabled;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','VisuMZ_1_ElementStatusCore','UTLFx','gxtHr','refresh','Scene_Skill_itemWindowRect','_checkingPassiveStates','valueOutlineColor','dqRBS','wONAP','itemTextAlign','allIcons','<enemy-%1>','drawFullGauge','ActionEndUpdate','getPassiveStateConditionSwitchData','actorId','onRegenerateCustomStateDamageOverTime','isStateAddable','Game_Switches_onChange','VisuMZ_1_ItemsEquipsCore','KPkJv','commandNameWindowDrawBackground','addDebuff','Sprite_Gauge_currentValue','SkillID','getStateOriginByKey','onAddDebuffJS','onEraseDebuffGlobalJS','Game_Actor_learnSkill','ShowTurns','RiTrz','Game_Battler_onBattleEnd','getCurrentTroopUniqueID','Scene_Skill_helpWindowRect','MAT','LabelOutlineWidth','XBMVA','Game_Battler_regenerateAll','statusWidth','convertPassiveStates','ARRAYEVAL','Sprite_Gauge_redraw','Kchib','ColorBuff','recover\x20all','isBuffOrDebuffAffected','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','index','Scene_Boot_onDatabaseLoaded','gainMp','concat','allBattleMembers','sEeKM','RlYwf','onAddState','zQAWl','slipMp','hBAnO','whUmr','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20condition\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20condition;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','qmbiJ','CmdStyle','overwriteBuffTurns','MDF','process_VisuMZ_SkillsStatesCore_State_Notetags','greater','canUse','Sprite_Gauge_setup','RDtlU','onEraseBuffJS','onAddBuff','JSQZi','slipHp','clearAllStateOrigins','_stateMaxTurns','CGCER','labelOutlineColor','MatchLabelGaugeColor','toLowerCase','rRFSC','#%1','xaGWZ','gradientFillRect','clearStateOrigin','clearStateData','die','ShWBy','drawActorIconsAllTurnCounters','bQGzi','xHYkA','SkillSceneAdjustSkillList','length','getStateIdWithName','addDebuffTurns','meetsStateCondition','onEraseStateJS','statePassiveConditionJS','CheckVisibleSkillNotetags','isSkillUsableForAutoBattle','isAllDead','setupSkillsStatesCore','RefreshCacheSwitch','getStateReapplyRulings','commandNameWindowDrawText','stateTurns','helpAreaTop','xerij','buff','RdYpu','8sEqirj','onEraseDebuff','Parse_Notetags_State_SlipEffectJS','Game_Actor_skillTypes','_cache_getPassiveStateConditionClassesData','ReapplyRules','colSpacing','indexOf','resetFontSettings','States','uiMenuStyle','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','contents','onBattleEnd','isStateResist','LMYIX','isPartyAllAffectedByGroupDefeatStates','4968ZpueUT','ValueFontMainType','frameCount','stateColor','setStateDisplay','Window_SkillList_maxCols','changeTextColor','isBuffPrevented','skillTypeWindowRect','stateEraseJS','_categoryWindow','Game_BattlerBase_refresh','keys','BKWEF','split','JDuJv','SkillConditionJS','Sprite_Gauge_initMembers','meetsPassiveStateGlobalConditionJS','onAddStateCustomJS','GGDsf','onEraseBuff','pueRh','hWYLV','maxCols','checkSkillConditionsNotetags','right','buttonAssistSwitch','PTDay','hasSkill','TrhtR','_subject','CbAoB','ptLFW','PassiveConditionJS','RQZMw','statusWindowRect','clearStatesWithStateRetain','CmdWidth','_skillTypeWindow','stateMpSlipDamageJS','hasState','Class-%1-%2','ceil','uddSi','TurnEndOnMap','active','_buffs','54SYspVI','QxScj','commandName','rgba(0,\x200,\x200,\x201)','PQsOK','version','addPassiveStatesByNotetag','Game_BattlerBase_eraseBuff','Game_BattlerBase_decreaseBuff','CmdTextAlign','getStateOrigin','BattleManager_endAction','_itemWindow','mainCommandWidth','clearStateRetainType','onExpireState','createAllSkillCostText','pskcx','makeCommandList','TextJS','includesSkillsStatesCore','ParseSkillNotetags','SkillMenuStatusRect','odfIf','meetsSkillConditionsEnableJS','meetsPassiveStateConditionJS','Game_Variables_onChange','STR','GQAiS','Game_BattlerBase_resetStateCounts','LUK','meetsPassiveStateConditionClasses','Parse_Notetags_State_Category','ColorDebuff','removeStatesAuto','applySkillsStatesCoreEffects','qGKmW','checkSkillTypeMatch','_lastStatesActionEndFrameCount'];_0x24f9=function(){return _0x367ef9;};return _0x24f9();}